/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.implementation;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import javax.annotation.Resource;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.EJBContext;
import javax.ejb.MessageDriven;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.transaction.UserTransaction;
import org.ow2.jasmine.jadort.api.JadortServiceException;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ProgressState;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressState;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressState;
import org.ow2.jasmine.jadort.api.entities.topology.VMBean;
import org.ow2.jasmine.jadort.service.action.AbstractAction;
import org.ow2.jasmine.jadort.service.action.ServerAction;
import org.ow2.jasmine.jadort.service.action.VMMAction;
import org.ow2.jasmine.jadort.service.action.WorkerAction;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;
import org.ow2.jonas.lib.security.context.Marshalling;
import org.ow2.jonas.lib.security.context.SecurityContext;
import org.ow2.jonas.lib.security.context.SecurityCurrent;

@MessageDriven(activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Queue"), @ActivationConfigProperty(propertyName="destination", propertyValue="queue/JadortServiceJMSQueue")})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class JMSReceiver
implements MessageListener {
    static final String QUEUE_NAME = "queue/JadortServiceJMSQueue";
    static final String SECURITY_CONTEXT = "securityContext";
    static final String SECURITY_SIGNATURE = "securitySignature";
    static final String SERVER_PROGRESS_ID = "serverProgressId";
    static final String WORKER_PROGRESS_ID = "workerProgressId";
    static final String AIMED_PROGRESS_PERCENT = "aimedProgressPercent";
    static final String AIMED_STATE = "aimedState";
    static final String APPLICATION_ID = "applicationId";
    static final String VM_IMAGE_UUID = "vmImageUUID";
    static final String ACTION_TYPE = "actionType";
    static final String APPLICATION_NAME = "applicationName";
    static final String VM_NAME = "vmName";
    static final String CHECK_IF_HOST_HALTED = "checkIfHostHalted";
    static final String OPERATION_TYPE = "operationType";
    private static final int START_TIMEOUT = 90;
    private static final int STOP_TIMEOUT = 45;
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
    @PersistenceContext
    protected EntityManager em;
    @Resource
    protected EJBContext context;

    @TransactionAttribute(value=TransactionAttributeType.SUPPORTS)
    public void onMessage(Message message) {
        try {
            try {
                SecurityCurrent securityCurrent = SecurityCurrent.getCurrent();
                if (securityCurrent != null) {
                    String context = message.getStringProperty(SECURITY_CONTEXT);
                    String signature = message.getStringProperty(SECURITY_SIGNATURE);
                    if (context != null) {
                        SecurityContext securityContext = Marshalling.unmarshallSecurityContext((byte[])context.getBytes());
                        if (signature != null) {
                            securityContext.setSignature(signature.getBytes());
                        }
                        securityCurrent.setSecurityContext(securityContext);
                    }
                }
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            AbstractAction action = null;
            ProgressBean progressBean = null;
            ByteArrayOutputStream stackTrace = null;
            ProgressState aimedState = null;
            Integer aimedProgressPercent = message.getIntProperty(AIMED_PROGRESS_PERCENT);
            ActionType actionType = ActionType.valueOf(message.getStringProperty(ACTION_TYPE));
            try {
                Enumeration properties = message.getPropertyNames();
                while (properties.hasMoreElements()) {
                    String propertyName = properties.nextElement().toString();
                    if (SERVER_PROGRESS_ID.equals(propertyName)) {
                        ServerAction serverAction;
                        aimedState = ServerProgressState.valueOf(message.getStringProperty(AIMED_STATE));
                        Integer serverProgressId = message.getIntProperty(SERVER_PROGRESS_ID);
                        ServerProgressBean serverProgressBean = (ServerProgressBean)this.em.find(ServerProgressBean.class, (Object)serverProgressId);
                        progressBean = serverProgressBean;
                        if (ActionType.START_VM.equals((Object)actionType) || ActionType.STOP_VM.equals((Object)actionType) || ActionType.CREATE_VM.equals((Object)actionType) || ActionType.DESTROY_VM.equals((Object)actionType)) {
                            ServerAction serverAction2;
                            if (ActionType.STOP_VM.equals((Object)actionType)) {
                                serverAction = ServerAction.getServerAction(serverProgressBean.getServer());
                                action = serverAction;
                                this.handleServerAction(serverProgressBean, serverAction, ActionType.STOP_SERVER, message);
                                progressBean.appendToLog(action.flushLog());
                            }
                            String vmName = message.getStringProperty(VM_NAME);
                            VMBean vm = new VMBean();
                            vm.setConnector(serverProgressBean.getServer().getVm().getConnector());
                            VMMAction vmmAction = VMMAction.getVMMAction(vm);
                            action = vmmAction;
                            this.handleVMMAction(serverProgressBean, vmmAction, vmName, actionType, message);
                            if (ActionType.START_VM.equals((Object)actionType) && !(serverAction2 = ServerAction.getServerAction(serverProgressBean.getServer())).isStarted()) {
                                progressBean.appendToLog(action.flushLog());
                                action = serverAction2;
                                this.handleServerAction(serverProgressBean, serverAction2, ActionType.START_SERVER, message);
                            }
                        } else {
                            serverAction = ServerAction.getServerAction(serverProgressBean.getServer());
                            action = serverAction;
                            this.handleServerAction(serverProgressBean, serverAction, actionType, message);
                        }
                    } else {
                        if (!WORKER_PROGRESS_ID.equals(propertyName)) continue;
                        aimedState = WorkerProgressState.valueOf(message.getStringProperty(AIMED_STATE));
                        Integer workerProgressId = message.getIntProperty(WORKER_PROGRESS_ID);
                        WorkerProgressBean workerProgressBean = (WorkerProgressBean)this.em.find(WorkerProgressBean.class, (Object)workerProgressId);
                        progressBean = workerProgressBean;
                        WorkerAction workerAction = WorkerAction.getWorkerAction(workerProgressBean.getWorker());
                        action = workerAction;
                        this.handleWorkerAction(workerProgressBean, workerAction, actionType, message);
                    }
                    break;
                }
            }
            catch (Exception e) {
                stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
            }
            if (progressBean != null) {
                if (action != null) {
                    progressBean.appendToLog(action.flushLog());
                }
                if (stackTrace != null) {
                    String line;
                    BufferedReader br = new BufferedReader(new StringReader(((Object)stackTrace).toString()));
                    while ((line = br.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        progressBean.appendToLog(line);
                    }
                }
                progressBean.setProgress(aimedProgressPercent);
                if (stackTrace == null && OperationStateBean.ActionState.RUNNING.equals(progressBean.getActionState())) {
                    progressBean.setActionState(OperationStateBean.ActionState.WAITING);
                    progressBean.setProgressState(aimedState);
                } else {
                    progressBean.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
                UserTransaction ut = this.context.getUserTransaction();
                ut.begin();
                this.em.merge((Object)progressBean);
                this.em.flush();
                ut.commit();
            }
        }
        catch (Exception e) {
            System.out.println("Failed processing JMS message '" + message + "': " + e.getMessage());
            e.printStackTrace();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handleServerAction(ServerProgressBean serverProgressBean, ServerAction serverAction, ActionType actionType, Message message) throws Exception {
        switch (1.$SwitchMap$org$ow2$jasmine$jadort$service$implementation$JMSReceiver$ActionType[actionType.ordinal()]) {
            case 1: {
                applicationId = message.getIntProperty("applicationId");
                application = (ApplicationBean)this.em.find(ApplicationBean.class, (Object)applicationId);
                newApplication = serverAction.upload(application);
                serverProgressBean.setNewDeploymentItem(newApplication);
                return;
            }
            case 2: {
                applicationName = message.getStringProperty("applicationName");
                serverAction.deploy(applicationName);
                return;
            }
            case 3: {
                applicationName = message.getStringProperty("applicationName");
                previousDefault = serverAction.setDefault(applicationName);
                if (previousDefault != null && !previousDefault.endsWith(applicationName) && serverProgressBean.getOldDeploymentItem() == null) {
                    serverProgressBean.setOldDeploymentItem(previousDefault);
                }
                return;
            }
            case 4: {
                applicationName = message.getStringProperty("applicationName");
                serverAction.undeploy(applicationName);
                return;
            }
            case 5: {
                applicationName = message.getStringProperty("applicationName");
                serverAction.erase(applicationName);
                if (applicationName.equals(serverProgressBean.getNewDeploymentItem())) {
                    serverProgressBean.setNewDeploymentItem(null);
                } else if (applicationName.equals(serverProgressBean.getOldDeploymentItem())) {
                    // empty if block
                }
                return;
            }
            case 6: {
                startException = null;
                try {
                    serverAction.start();
                }
                catch (Exception e) {
                    startException = e;
                }
                try {
                    serverAction.checkJMXConnection();
                }
                catch (Exception e) {
                    if (serverProgressBean.getServer().getManagerConnector() != null) ** GOTO lbl59
                    startException = null;
                    serverAction.appendToLog("Waiting for server core to start");
                    started = false;
                    stopTime = System.currentTimeMillis() + 90000L;
                    while (!started && System.currentTimeMillis() < stopTime) {
                        Thread.sleep(1000L);
                        try {
                            serverAction.checkJMXConnection();
                            started = true;
                        }
                        catch (Exception ignored) {}
                    }
                    if (started) {
                        serverAction.appendToLog("Server core is online");
                    }
                    throw new JadortServiceException("Server core did not start after 90 seconds! Try retrying manually using the \"Retry server\" button...", startException);
                }
lbl59:
                // 3 sources

                this.waitForServerState(serverAction, true, startException);
                return;
            }
            case 7: {
                stopException = null;
                try {
                    serverAction.stop();
                }
                catch (Exception e) {
                    stopException = e;
                }
                this.waitForServerState(serverAction, false, stopException);
                serverAction.disconnectJMX();
                return;
            }
            case 8: {
                if (!serverAction.enableOrDisableApplications(false)) {
                    serverProgressBean.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
                return;
            }
            case 9: {
                if (!serverAction.enableOrDisableApplications(true)) {
                    serverProgressBean.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                }
                return;
            }
        }
        throw new IllegalStateException("Unknown ActionType for a server: " + (Object)actionType);
    }

    private void handleWorkerAction(WorkerProgressBean workerProgressBean, WorkerAction workerAction, ActionType actionType, Message message) throws Exception {
        switch (actionType) {
            case START_WORKER: {
                workerAction.enable();
                return;
            }
            case STOP_WORKER: {
                workerAction.disable();
                return;
            }
        }
        throw new IllegalStateException("Unknown ActionType for a worker: " + (Object)((Object)actionType));
    }

    private void handleVMMAction(ServerProgressBean serverProgressBean, VMMAction vmmAction, String vmName, ActionType actionType, Message message) throws Exception {
        switch (actionType) {
            case START_VM: {
                if (!VirtualMachineMXBean.PowerState.RUNNING.equals((Object)vmmAction.getVMState(vmName))) {
                    vmmAction.startVM(vmName);
                }
                vmmAction.waitForVMState(vmName, VirtualMachineMXBean.PowerState.RUNNING, 90L);
                return;
            }
            case STOP_VM: {
                if (!VirtualMachineMXBean.PowerState.HALTED.equals((Object)vmmAction.getVMState(vmName))) {
                    vmmAction.stopVM(vmName);
                }
                vmmAction.waitForVMState(vmName, VirtualMachineMXBean.PowerState.HALTED, 45L);
                return;
            }
            case CREATE_VM: {
                Date now = new Date();
                String vmImageUUID = message.getStringProperty(VM_IMAGE_UUID);
                String vmPath = vmName.substring(0, vmName.lastIndexOf(47));
                String vmNameLabel = vmName.substring(vmName.lastIndexOf(47) + 1);
                if (vmNameLabel.indexOf(95) > 0) {
                    vmNameLabel = vmNameLabel.substring(0, vmNameLabel.indexOf(95));
                }
                String newVmName = vmPath + '/' + vmNameLabel + '_' + dateFormat.format(now);
                vmmAction.deployImageOnVM(vmName, newVmName, vmImageUUID);
                serverProgressBean.setNewDeploymentItem(newVmName);
                return;
            }
            case DESTROY_VM: {
                VirtualMachineMXBean.PowerState currentState;
                boolean checkIfHostHalted = message.getBooleanProperty(CHECK_IF_HOST_HALTED);
                if (checkIfHostHalted && !VirtualMachineMXBean.PowerState.HALTED.equals((Object)(currentState = vmmAction.getVMState(vmName)))) {
                    throw new IllegalStateException("The state of the VM host \"" + vmName + "\" is currently " + currentState + ", it is expected to be " + VirtualMachineMXBean.PowerState.HALTED);
                }
                vmmAction.destroyVM(vmName);
                if (vmName.equals(serverProgressBean.getNewDeploymentItem())) {
                    serverProgressBean.setNewDeploymentItem(null);
                } else if (vmName.equals(serverProgressBean.getOldDeploymentItem())) {
                    serverProgressBean.setOldDeploymentItem(null);
                }
                return;
            }
        }
        throw new IllegalStateException("Unknown ActionType for a VM: " + (Object)((Object)actionType));
    }

    private void waitForServerState(ServerAction serverAction, boolean state, Exception potentialCause) throws Exception {
        serverAction.appendToLog("Waiting for server to " + (state ? "start" : "stop"));
        long timeout = state ? 90L : 45L;
        boolean currentState = !state;
        long stopTime = System.currentTimeMillis() + timeout * 1000L;
        while (currentState != state && System.currentTimeMillis() < stopTime) {
            Thread.sleep(1000L);
            currentState = serverAction.isStarted();
        }
        if (currentState != state) {
            throw new JadortServiceException("Server did not " + (state ? "start" : "stop") + " after " + timeout + " seconds! Try retrying manually using the \"Retry server\" button...", potentialCause);
        }
        serverAction.appendToLog("Server is " + (state ? "started" : "stopped"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ActionType {
        UPLOAD,
        DEPLOY,
        SET_DEFAULT,
        UNDEPLOY,
        ERASE,
        START_SERVER,
        STOP_SERVER,
        START_WORKER,
        STOP_WORKER,
        DISABLE_APPLICATIONS,
        ENABLE_APPLICATIONS,
        START_VM,
        CREATE_VM,
        DESTROY_VM,
        STOP_VM;

    }
}

