/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiServerAction
extends ServerAction {
    private String name;
    private ConnectorBean serverConnector;
    private ObjectName osgiServerObjectName;

    public OSGiServerAction(ServerBean server) {
        this.name = server.getName();
        this.serverConnector = server.getServerConnector();
        this.appendToLog("Created OSGiServerAction for server '" + this.name + "'");
    }

    @Override
    public boolean canDeployApplications() throws Exception {
        return true;
    }

    @Override
    public boolean canStartStopServer() throws Exception {
        return false;
    }

    @Override
    public void deploy(String bundleId) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Starting bundle '" + bundleId + "'");
        Object[] opParamStart = new Object[]{new Long(bundleId)};
        String[] opSigStart = new String[]{"long"};
        this.mbscnx.invoke(this.osgiServerObjectName, "startBundle", opParamStart, opSigStart);
        this.appendToLog("Call to BundleManager.startBundle successful for bundle '" + bundleId + "'");
    }

    @Override
    public void undeploy(String bundleId) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Stopping bundle '" + bundleId + "'");
        Object[] opParamStart = new Object[]{new Long(bundleId)};
        String[] opSigStart = new String[]{"long"};
        this.mbscnx.invoke(this.osgiServerObjectName, "stopBundle", opParamStart, opSigStart);
        this.appendToLog("Call to BundleManager.stopBundle successful for bundle '" + bundleId + "'");
    }

    @Override
    public boolean enableOrDisableApplications(boolean enable) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public void erase(String bundleId) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Uninstalling bundle '" + bundleId + "'");
        Object[] opParamStart = new Object[]{new Long(bundleId)};
        String[] opSigStart = new String[]{"long"};
        this.mbscnx.invoke(this.osgiServerObjectName, "uninstallBundle", opParamStart, opSigStart);
        this.appendToLog("Call to BundleManager.uninstallBundle successful for bundle '" + bundleId + "'");
    }

    @Override
    public int getActiveSessions(String appName) throws Exception {
        return 0;
    }

    @Override
    public int getActiveSessions() throws Exception {
        return 0;
    }

    @Override
    public ApplicationBean getApplicationBean(String appName) throws Exception {
        this.checkJMXConnection();
        Long bundleId = new Long(appName);
        Object[] opParamStart = new Object[]{bundleId};
        String[] opSigStart = new String[]{"long"};
        String bundleInfo = (String)this.mbscnx.invoke(this.osgiServerObjectName, "bundleInfo", opParamStart, opSigStart);
        if (bundleInfo != null) {
            return this.createApplicationBean(bundleId, bundleInfo);
        }
        return null;
    }

    private ApplicationBean createApplicationBean(Long id, String bundleIdentifier) throws Exception {
        ApplicationBean aBean = new ApplicationBean();
        String symbolicName = bundleIdentifier.split(";")[0];
        String version = bundleIdentifier.split(";")[1];
        aBean.setName(symbolicName);
        aBean.setVersion(version);
        Object[] opParamStart = new Object[]{new Long(id)};
        String[] opSigStart = new String[]{"long"};
        String state = (String)this.mbscnx.invoke(this.osgiServerObjectName, "stateOfBundle", opParamStart, opSigStart);
        aBean.setState(state);
        return aBean;
    }

    @Override
    public boolean isStarted() {
        try {
            this.checkJMXConnection();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<ApplicationBean> listOfApplications() throws Exception {
        this.checkJMXConnection();
        ArrayList<ApplicationBean> applications = new ArrayList<ApplicationBean>();
        Map bundlesMap = new Hashtable();
        bundlesMap = (Map)this.mbscnx.invoke(this.osgiServerObjectName, "allBundles", null, null);
        for (Map.Entry pairs : bundlesMap.entrySet()) {
            Long id = (Long)pairs.getKey();
            String bundleIdentifier = (String)pairs.getValue();
            applications.add(this.createApplicationBean(id, bundleIdentifier));
        }
        return applications;
    }

    @Override
    public String setDefault(String appName) throws Exception {
        return appName;
    }

    @Override
    public void start() throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public void stop() throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public String upload(ApplicationBean application) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Installing bundle for ApplicationBean '" + application + "'");
        String fileName = application.getName();
        Object[] param = new Object[]{fileName, ServerAction.obtainByteData(application.getFile())};
        String[] sign = new String[]{String.class.getName(), byte[].class.getName()};
        long bundleId = (Long)this.mbscnx.invoke(this.osgiServerObjectName, "installBundle", param, sign);
        this.appendToLog("Call to BundleManager.installBundle successful for ApplicationBean '" + application + "', bundle identifier is '" + bundleId + "'");
        return String.valueOf(bundleId);
    }

    @Override
    protected void connectViaJMX() throws Exception {
        String url = this.serverConnector.getConnectorUrl();
        String username = this.serverConnector.getUsername();
        String password = this.serverConnector.getPassword();
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (username != null && password != null) {
            String[] creds = new String[]{username, password};
            env.put("jmx.remote.credentials", creds);
        }
        this.establishJMXConnection(new JMXServiceURL(url), env);
        Set<ObjectName> bundleManagers = this.mbscnx.queryNames(new ObjectName("*:type=jmx.bundle.manager.impl.BundleManagerImpl,*"), null);
        if ((null == bundleManagers || bundleManagers.isEmpty()) && (null == (bundleManagers = this.mbscnx.queryNames(new ObjectName("*:type=BundleManager,instance=JmxBundleManager,*"), null)) || bundleManagers.isEmpty())) {
            throw new Exception("JMXBundleManager not found on the OSGi framework");
        }
        this.osgiServerObjectName = bundleManagers.iterator().next();
        this.appendToLog("JMX server connection OK for server '" + this.name + "', OSGiServer's bundleManager is '" + this.osgiServerObjectName + "'");
    }
}

