/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.implementation;

import java.io.File;
import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.ow2.jasmine.deployme.generated.Configuration;
import org.ow2.jasmine.deployme.generated.Topology;
import org.ow2.jasmine.jadort.api.JadortServiceException;
import org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.api.entities.topology.TopologyBean;
import org.ow2.jasmine.jadort.api.entities.topology.VMBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.service.implementation.JadortServiceStatefulBean;
import org.ow2.jasmine.jadort.service.topology.xml.Balancer;
import org.ow2.jasmine.jadort.service.topology.xml.Server;
import org.ow2.jasmine.jadort.service.topology.xml.Target;
import org.ow2.jasmine.jadort.service.topology.xml.Topology;
import org.ow2.jasmine.jadort.service.topology.xml.URLConnector;
import org.ow2.jasmine.jadort.service.topology.xml.VM;
import org.ow2.jasmine.jadort.service.topology.xml.VMM;
import org.ow2.jasmine.jadort.service.topology.xml.Worker;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TopologyReader {
    public static final String XSD_PATH_JADORT = "XMLSchema/topology_JadortSpecific.xsd";
    public static final String XSD_PATH_DEPLOYME = "xml/topology.xsd";

    public static TopologyBean loadJadortSpecificTopology(File xmlTopoFile) throws UnmarshalException, JadortServiceException {
        Topology xmlTopology = TopologyReader.loadSchemaAndFile(XSD_PATH_JADORT, Topology.class, xmlTopoFile);
        TopologyBean topologyBean = new TopologyBean();
        HashMap<String, Worker> workerXMLs = new HashMap<String, Worker>();
        for (Worker workerXML : xmlTopology.getWorker()) {
            workerXMLs.put(workerXML.getName(), workerXML);
        }
        HashMap<String, VMM> vmmXMLs = new HashMap<String, VMM>();
        for (VMM vmmXML : xmlTopology.getVMM()) {
            vmmXMLs.put(vmmXML.getName(), vmmXML);
        }
        ArrayList<GroupBean> groups = new ArrayList<GroupBean>();
        for (Topology.Group groupXML : xmlTopology.getGroup()) {
            GroupBean groupBean = new GroupBean();
            groupBean.setName(groupXML.getName());
            groupBean.setClustered(groupXML.isClustered());
            groupBean.setConnected(true);
            ArrayList<ServerBean> servers = new ArrayList<ServerBean>();
            ArrayList<WorkerBean> workers = new ArrayList<WorkerBean>();
            boolean atLeastOneServerHasVM = false;
            String VMMName = "";
            for (Server serverXML : groupXML.getServer()) {
                VM vmXML;
                List<Balancer> balancerXMLs;
                ServerBean serverBean = new ServerBean();
                serverBean.setName(serverXML.getName());
                if (serverXML.getCapacity() != null) {
                    serverBean.setCapacity(serverXML.getCapacity());
                }
                serverBean.setType(ServerBean.Type.valueOf(serverXML.getType().name()));
                serverBean.setServerConnector(TopologyReader.createJMXConnectorBean(serverXML.getURLConnector()));
                if (serverXML.getManager() != null) {
                    serverBean.setManagerConnector(TopologyReader.createJMXConnectorBean(serverXML.getManager().getURLConnector()));
                }
                Target targetXML = serverXML.getTarget();
                ServerBean target = null;
                if (targetXML != null) {
                    target = new ServerBean();
                    target.setName(targetXML.getName());
                    target.setType(ServerBean.Type.valueOf(targetXML.getType().name()));
                    target.setServerConnector(TopologyReader.createJMXConnectorBean(targetXML.getURLConnector()));
                    if (targetXML.getManager() != null) {
                        target.setManagerConnector(TopologyReader.createJMXConnectorBean(targetXML.getManager().getURLConnector()));
                    }
                    serverBean.setTarget(target);
                }
                if ((balancerXMLs = serverXML.getBalancer()) != null) {
                    for (Balancer balancerXML : balancerXMLs) {
                        Worker workerXML = (Worker)workerXMLs.get(balancerXML.getWorker());
                        if (workerXML == null) {
                            throw new JadortServiceException("There is no worker named \"" + balancerXML.getWorker() + "\", please check your topology file.", null);
                        }
                        WorkerBean workerBean = new WorkerBean();
                        workerBean.setName(balancerXML.getServer());
                        workerBean.setWorkerName(workerXML.getName());
                        workerBean.setType(WorkerBean.Type.valueOf(workerXML.getType().name()));
                        workerBean.setServerName(balancerXML.getServer());
                        workerBean.setConnector(TopologyReader.createJMXConnectorBean(workerXML.getURLConnector()));
                        workerBean.setServer(serverBean);
                        workers.add(workerBean);
                    }
                }
                if ((vmXML = serverXML.getVM()) != null) {
                    atLeastOneServerHasVM = true;
                    VMM vmmXML = (VMM)vmmXMLs.get(vmXML.getVmm());
                    if (vmmXML != null) {
                        VMBean vmBean = new VMBean();
                        vmBean.setName(vmXML.getName());
                        vmBean.setVmm(vmXML.getVmm());
                        vmBean.setConnector(TopologyReader.createJMXConnectorBean(vmmXML.getURLConnector()));
                        serverBean.setVm(vmBean);
                        VMMName = vmmXML.getName();
                    } else {
                        throw new JadortServiceException("VMM not defined\", please check your topology file.", null);
                    }
                }
                servers.add(serverBean);
            }
            for (ServerBean server : servers) {
                if (atLeastOneServerHasVM && server.getVm() == null || !atLeastOneServerHasVM && server.getVm() != null) {
                    throw new JadortServiceException("All servers in a group must have a VM or no server has one\", please check your topology file.", null);
                }
                if (server.getVm() == null || server.getVm().getVmm().equals(VMMName)) continue;
                throw new JadortServiceException("All servers in a group must have the same VMM\", please check your topology file.", null);
            }
            groupBean.setServers(servers);
            groupBean.setWorkers(workers);
            groups.add(groupBean);
        }
        topologyBean.setGroups(groups);
        return topologyBean;
    }

    public static TopologyBean loadDeployMETopology(File xmlTopoFile) throws UnmarshalException, JadortServiceException {
        org.ow2.jasmine.deployme.generated.Topology xmlTopology = TopologyReader.loadSchemaAndFile(XSD_PATH_DEPLOYME, org.ow2.jasmine.deployme.generated.Topology.class, xmlTopoFile);
        TopologyBean topologyBean = new TopologyBean();
        ArrayList<GroupBean> groups = new ArrayList<GroupBean>();
        for (Topology.Domains.Domain domain : xmlTopology.getDomains().getDomain()) {
            Configuration conf = domain.getConfiguration();
            String defaultHost = null;
            int defaultPort = 0;
            Configuration.Protocols protocols = null;
            if (conf != null) {
                if (conf.getGlobalJonas() != null) {
                    defaultHost = conf.getGlobalJonas().getHost();
                }
                protocols = conf.getProtocols();
            }
            if (defaultHost == null) {
                defaultHost = "localhost";
            }
            String defaultProtocol = null;
            if (protocols != null) {
                defaultProtocol = protocols.getProtocolsList();
                BigInteger jrmpPort = protocols.getJrmpPort();
                if (jrmpPort != null) {
                    defaultPort = jrmpPort.intValue();
                }
            }
            defaultProtocol = defaultProtocol != null ? defaultProtocol.split(",")[0] : "jrmp";
            GroupBean groupBean = new GroupBean();
            groupBean.setName(domain.getName());
            boolean clustered = false;
            try {
                clustered = conf.getActiveServices().getWeb().isHttpReplicationActivated().booleanValue();
            }
            catch (NullPointerException ignored) {
                // empty catch block
            }
            ArrayList<ServerBean> servers = new ArrayList<ServerBean>();
            for (Topology.Domains.Domain.Servers.Server server : domain.getServers().getServer()) {
                String transport;
                conf = server.getConfiguration();
                String host = null;
                if (conf != null) {
                    if (conf.getGlobalJonas() != null) {
                        host = conf.getGlobalJonas().getHost();
                    }
                    protocols = conf.getProtocols();
                }
                if (host == null) {
                    host = defaultHost;
                }
                String name = server.getName();
                int port = defaultPort;
                String protocol = null;
                if (protocols != null) {
                    protocol = protocols.getProtocolsList();
                    BigInteger jrmpPort = protocols.getJrmpPort();
                    if (jrmpPort != null) {
                        port = jrmpPort.intValue();
                    }
                }
                if ((protocol = protocol != null ? protocol.split(",")[0] : defaultProtocol).equals("irmi")) {
                    transport = "rmi";
                    if (port == 0) {
                        port = 1098;
                    }
                } else if (protocol.equals("jrmp")) {
                    transport = "rmi";
                    if (port == 0) {
                        port = 1099;
                    }
                } else if (protocol.equals("iiop")) {
                    transport = "iiop";
                    if (port == 0) {
                        port = 2001;
                    }
                } else {
                    throw new JadortServiceException("Unknown protocol \"" + protocol + "\" for server \"" + name + "\".", null);
                }
                String jmxURL = "service:jmx:" + transport + "://" + host + "/jndi/" + transport + "://" + host + ":" + port + "/" + protocol + "connector_" + name;
                ConnectorBean connector = new ConnectorBean();
                connector.setConnectorUrl(jmxURL);
                ServerBean serverBean = new ServerBean();
                serverBean.setName(name);
                serverBean.setServerConnector(connector);
                if (JadortServiceStatefulBean.DUMMY) {
                    serverBean.setType(ServerBean.Type.DUMMY);
                } else {
                    serverBean.setType(ServerBean.Type.JONAS);
                }
                servers.add(serverBean);
                try {
                    if (conf.getActiveServices().getWeb().isHttpReplicationActivated().booleanValue()) {
                        clustered = true;
                        continue;
                    }
                    clustered = false;
                }
                catch (NullPointerException ignored) {}
            }
            if (domain.getClusterDaemons() != null) {
                for (Topology.Domains.Domain.ClusterDaemons.ClusterDaemon cd : domain.getClusterDaemons().getClusterDaemon()) {
                    int nb = 1;
                    String prefix = cd.getServerNamePrefix();
                    for (String serverName : cd.getServers().getServerName()) {
                        boolean found = false;
                        for (ServerBean s : servers) {
                            String transport;
                            if (!s.getName().equals(serverName)) continue;
                            s.setName(prefix + nb);
                            s.getServerConnector().setConnectorUrl(s.getServerConnector().getConnectorUrl().replace("connector_" + serverName, "connector_" + s.getName()));
                            ++nb;
                            String protocol = cd.getClusterDaemonProtocol();
                            protocol = protocol != null ? protocol.split(",")[0] : defaultProtocol;
                            int port = defaultPort;
                            Integer portInteger = cd.getClusterDaemonPort();
                            if (portInteger != null) {
                                port = portInteger;
                            }
                            if (protocol.equals("irmi")) {
                                transport = "rmi";
                                if (port == 0) {
                                    port = 1098;
                                }
                            } else if (protocol.equals("jrmp")) {
                                transport = "rmi";
                                if (port == 0) {
                                    port = 1099;
                                }
                            } else if (protocol.equals("iiop")) {
                                transport = "iiop";
                                if (port == 0) {
                                    port = 2001;
                                }
                            } else {
                                throw new JadortServiceException("Unknown protocol \"" + protocol + "\" for cluster daemon \"" + cd.getName() + "\".", null);
                            }
                            String serverURL = s.getServerConnector().getConnectorUrl();
                            int hostStart = serverURL.indexOf("://") + 3;
                            String host = serverURL.substring(hostStart, serverURL.indexOf(47, hostStart));
                            String jmxURL = "service:jmx:" + transport + "://" + host + "/jndi/" + transport + "://" + host + ":" + port + "/" + protocol + "connector_" + cd.getName();
                            ConnectorBean manager = new ConnectorBean();
                            manager.setConnectorUrl(jmxURL);
                            s.setManagerConnector(manager);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        throw new JadortServiceException("Cannot find server \"" + serverName + "\" for cluster daemon \"" + cd.getName() + "\".", null);
                    }
                }
            }
            groupBean.setServers(servers);
            groupBean.setClustered(clustered);
            groups.add(groupBean);
        }
        topologyBean.setGroups(groups);
        return topologyBean;
    }

    protected static <T> T loadSchemaAndFile(String xsdPath, Class<T> rootClass, File xmlFile) throws JadortServiceException, UnmarshalException {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)rootClass.getPackage().getName());
            Unmarshaller unMarshaller = jc.createUnmarshaller();
            URL xsdURL = TopologyReader.class.getClassLoader().getResource(xsdPath);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = schemaFactory.newSchema(xsdURL);
            unMarshaller.setSchema(schema);
            return (T)unMarshaller.unmarshal(xmlFile);
        }
        catch (JAXBException e) {
            if (e instanceof UnmarshalException) {
                UnmarshalException ue = (UnmarshalException)e;
                if (ue.getLinkedException() != null) {
                    throw new UnmarshalException(ue.getLinkedException().getMessage(), (Throwable)e);
                }
                throw ue;
            }
            throw new JadortServiceException("Error creating the topology parser: " + e.getMessage(), (Exception)((Object)e));
        }
        catch (SAXException e) {
            throw new JadortServiceException("Error creating the topology parser: " + e.getMessage(), e);
        }
    }

    protected static ConnectorBean createJMXConnectorBean(URLConnector urlConnector) {
        ConnectorBean jmxConnectorBean = new ConnectorBean();
        jmxConnectorBean.setConnectorUrl(urlConnector.getURL());
        if (urlConnector.getUsername() != null && urlConnector.getPassword() != null) {
            jmxConnectorBean.setUsername(urlConnector.getUsername());
            jmxConnectorBean.setPassword(urlConnector.getPassword());
        }
        return jmxConnectorBean;
    }
}

