/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.implementation;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.JadortServiceException;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressState;
import org.ow2.jasmine.jadort.api.entities.deployment.VMImageBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressState;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.api.entities.topology.VMBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;
import org.ow2.jasmine.jadort.service.action.VMMAction;
import org.ow2.jasmine.jadort.service.implementation.JMSSender;
import org.ow2.jasmine.jadort.service.implementation.OperationPersistenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionManager
extends OperationPersistenceManager {
    protected void reachAimedServerProgressState(ServerProgressBean serverProgress) {
        ServerProgressState aimedServerProgressState;
        ServerProgressState currentServerProgressState;
        block59: {
            currentServerProgressState = serverProgress.getProgressState();
            aimedServerProgressState = this.operation.getAimedServerProgressState();
            try {
                IJadortService.OperationType type = this.operation.getType();
                if (type.equals(IJadortService.OperationType.MAINTAIN)) {
                    if (currentServerProgressState.equals(ServerProgressState.INITIAL)) {
                        if (this.operation.getSelectedGroup().getClustered()) {
                            if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                                if (serverProgress.getServer().getVm() != null) {
                                    JMSSender.stopVM(this.operation, serverProgress, false, serverProgress.getOldDeploymentItem());
                                } else {
                                    JMSSender.stopServer(this.operation, serverProgress, false);
                                }
                                return;
                            }
                        } else if (aimedServerProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                            JMSSender.disableApplications(this.operation, serverProgress);
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                JMSSender.stopVM(this.operation, serverProgress, false, serverProgress.getOldDeploymentItem());
                            } else {
                                JMSSender.stopServer(this.operation, serverProgress, false);
                            }
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                            JMSSender.enableApplications(this.operation, serverProgress);
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.STOP_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                JMSSender.createVM(this.operation, serverProgress, serverProgress.getOldDeploymentItem());
                            } else {
                                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                                serverProgress.setProgress(this.operation.getAimedProgressPercent());
                                serverProgress.setProgressState(this.operation.getAimedServerProgressState());
                            }
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                            if (serverProgress.getServer().getVm() != null) {
                                JMSSender.startVM(this.operation, serverProgress, false, serverProgress.getOldDeploymentItem());
                            } else {
                                JMSSender.startServer(this.operation, serverProgress, false);
                            }
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                JMSSender.startVM(this.operation, serverProgress, false, serverProgress.getOldDeploymentItem());
                            } else {
                                JMSSender.startServer(this.operation, serverProgress, false);
                            }
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.START_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                JMSSender.startVM(this.operation, serverProgress, true, serverProgress.getNewDeploymentItem());
                            } else {
                                JMSSender.startServer(this.operation, serverProgress, true);
                            }
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.STOP_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                JMSSender.destroyVM(this.operation, serverProgress, serverProgress.getNewDeploymentItem(), false);
                            } else {
                                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                                serverProgress.setProgress(this.operation.getAimedProgressPercent());
                                serverProgress.setProgressState(this.operation.getAimedServerProgressState());
                            }
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.START_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                            if (serverProgress.getServer().getVm() != null) {
                                JMSSender.stopVM(this.operation, serverProgress, true, serverProgress.getNewDeploymentItem());
                            } else {
                                JMSSender.stopServer(this.operation, serverProgress, true);
                            }
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.DESTROY_VM_HOSTS_OK)) {
                            JMSSender.destroyVM(this.operation, serverProgress, serverProgress.getOldDeploymentItem(), true);
                            return;
                        }
                        break block59;
                    }
                    throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                }
                if (type.equals(IJadortService.OperationType.MIGRATE)) {
                    if (currentServerProgressState.equals(ServerProgressState.INITIAL)) {
                        if (aimedServerProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                            JMSSender.upload(this.operation, serverProgress, this.operation.getApplication());
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                            JMSSender.deploy(this.operation, serverProgress, serverProgress.getNewDeploymentItem());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.INITIAL)) {
                            JMSSender.erase(this.operation, serverProgress, serverProgress.getNewDeploymentItem());
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                            JMSSender.setAsDefault(this.operation, serverProgress, serverProgress.getNewDeploymentItem());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                            JMSSender.undeploy(this.operation, serverProgress, serverProgress.getNewDeploymentItem());
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.UNDEPLOY_OK)) {
                            if (!serverProgress.hasOldDeploymentItem()) {
                                throw new Exception("There's no old version or the old and new versions are the same");
                            }
                            JMSSender.undeploy(this.operation, serverProgress, serverProgress.getOldDeploymentItem());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                            if (serverProgress.getOldDeploymentItem() == null) {
                                serverProgress.appendToLog("There's no old version, ignoring step.\nThis implies that the new [and only] version will keep on being the default one.");
                                serverProgress.setProgress(this.operation.getAimedProgressPercent());
                                serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
                                serverProgress.setProgressState(aimedServerProgressState);
                            } else {
                                JMSSender.setAsDefault(this.operation, serverProgress, serverProgress.getOldDeploymentItem());
                            }
                            return;
                        }
                        break block59;
                    }
                    if (currentServerProgressState.equals(ServerProgressState.UNDEPLOY_OK)) {
                        if (aimedServerProgressState.equals(ServerProgressState.ERASE_OK)) {
                            if (!serverProgress.hasOldDeploymentItem()) {
                                throw new Exception("There's no old version or the old and new versions are the same");
                            }
                            JMSSender.erase(this.operation, serverProgress, serverProgress.getOldDeploymentItem());
                            return;
                        }
                        if (aimedServerProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                            JMSSender.deploy(this.operation, serverProgress, serverProgress.getOldDeploymentItem());
                            return;
                        }
                        break block59;
                    }
                    throw new IllegalStateException("Unknown ServerProgressState: " + aimedServerProgressState);
                }
                throw new IllegalStateException("Unknown OperationType: " + type);
            }
            catch (Exception e) {
                serverProgress.appendToLog("Failed executing server action: " + e.getClass().getCanonicalName() + ", " + e.getMessage());
                ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
                BufferedReader br = new BufferedReader(new StringReader(((Object)stackTrace).toString()));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        serverProgress.appendToLog(line);
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                serverProgress.setProgress(this.operation.getAimedProgressPercent());
                serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                serverProgress.setProgressState(this.operation.getAimedServerProgressState());
                return;
            }
        }
        serverProgress.appendToLog("Don't know what to do: operation.getAimedServerProgressState() is " + aimedServerProgressState + ", serverProgress.getProgressState() is " + currentServerProgressState);
        serverProgress.setProgress(this.operation.getAimedProgressPercent());
        serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
    }

    protected void reachAimedWorkerProgressState(WorkerProgressBean workerProgress) {
        WorkerProgressState aimedWorkerProgressState;
        WorkerProgressState currentWorkerProgressState;
        block13: {
            currentWorkerProgressState = workerProgress.getProgressState();
            aimedWorkerProgressState = this.operation.getAimedWorkerProgressState();
            try {
                IJadortService.OperationType type = this.operation.getType();
                if (type.equals(IJadortService.OperationType.MAINTAIN)) {
                    if (currentWorkerProgressState.equals(WorkerProgressState.INITIAL)) {
                        if (aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) {
                            JMSSender.stopWorker(this.operation, workerProgress);
                            return;
                        }
                        break block13;
                    }
                    if (currentWorkerProgressState.equals(WorkerProgressState.STOP_OK)) {
                        if (aimedWorkerProgressState.equals(WorkerProgressState.START_OK)) {
                            JMSSender.startWorker(this.operation, workerProgress);
                            return;
                        }
                        if (aimedWorkerProgressState.equals(WorkerProgressState.INITIAL)) {
                            JMSSender.startWorker(this.operation, workerProgress);
                            return;
                        }
                        break block13;
                    }
                    if (currentWorkerProgressState.equals(WorkerProgressState.START_OK)) {
                        if (aimedWorkerProgressState.equals(WorkerProgressState.STOP_OK)) {
                            JMSSender.stopWorker(this.operation, workerProgress);
                            return;
                        }
                        break block13;
                    }
                    throw new IllegalStateException("Unknown WorkerProgressState: " + currentWorkerProgressState);
                }
                throw new IllegalStateException("Unknown OperationType: " + type);
            }
            catch (Exception e) {
                workerProgress.appendToLog("Failed executing worker action: " + e.getClass().getCanonicalName() + ", " + e.getMessage());
                ByteArrayOutputStream stackTrace = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(stackTrace));
                BufferedReader br = new BufferedReader(new StringReader(((Object)stackTrace).toString()));
                try {
                    String line;
                    while ((line = br.readLine()) != null) {
                        if (line.length() <= 0) continue;
                        workerProgress.appendToLog(line);
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                workerProgress.setProgress(this.operation.getAimedProgressPercent());
                workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
                workerProgress.setProgressState(this.operation.getAimedWorkerProgressState());
                return;
            }
        }
        workerProgress.appendToLog("Don't know what to do: operation.getAimedWorkerProgressState() is " + aimedWorkerProgressState + ", workerProgress.getAimedWorkerProgressState() is " + currentWorkerProgressState);
        workerProgress.setProgress(this.operation.getAimedProgressPercent());
        workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
    }

    protected void fillApplications(GroupBean groupBean) throws JadortServiceException {
        TreeMap<String, ApplicationBean> groupApplications = new TreeMap<String, ApplicationBean>();
        if (groupBean.getConnected()) {
            for (ServerBean serverBean : groupBean.getServers()) {
                ServerAction serverAction = ServerAction.getServerAction(serverBean);
                try {
                    TreeMap<String, ApplicationBean> serverApplications = new TreeMap<String, ApplicationBean>();
                    for (ApplicationBean applicationBean : serverAction.listOfApplications()) {
                        groupApplications.put(applicationBean.toString(), applicationBean);
                        serverApplications.put(applicationBean.toString(), applicationBean);
                    }
                    serverBean.setApplications(new ArrayList<ApplicationBean>(serverApplications.values()));
                }
                catch (Exception e) {
                    String message = e.getClass().getName() + ": " + e.getMessage();
                    throw new JadortServiceException("Failed getting the applications on the server " + serverBean.getName() + ": " + message, e);
                }
            }
            groupBean.setApplications(new ArrayList<ApplicationBean>(groupApplications.values()));
        }
    }

    protected void fillVMImages(GroupBean groupBean) throws JadortServiceException {
        ServerBean serverBean = groupBean.getServers().iterator().next();
        ArrayList<VMImageBean> vmImages = new ArrayList<VMImageBean>();
        VMBean vmBean = serverBean.getVm();
        if (vmBean != null) {
            VMMAction vmAction = VMMAction.getVMMAction(vmBean);
            try {
                for (VMImageBean vmImageBean : vmAction.getVMImages()) {
                    vmImages.add(vmImageBean);
                }
            }
            catch (Exception e) {
                String message = e.getClass().getName() + ": " + e.getMessage();
                throw new JadortServiceException("Failed getting the VM images on the virtual machine manager " + vmBean.getVmm() + ": " + message, e);
            }
            groupBean.setVmImages(vmImages);
        }
    }

    protected List<GroupBean> fetchGroups(boolean fillApplications) throws JadortServiceException {
        if (this.operation.getTopology() != null && this.operation.getTopology().getGroups() != null) {
            ArrayList<GroupBean> result = new ArrayList<GroupBean>(this.operation.getTopology().getGroups().size());
            for (GroupBean groupBean : this.operation.getTopology().getGroups()) {
                GroupBean groupBeanCopy = new GroupBean();
                groupBeanCopy.setId(groupBean.getId());
                groupBeanCopy.setWorkers(new ArrayList<WorkerBean>(groupBean.getWorkers()));
                groupBeanCopy.setName(groupBean.getName());
                groupBeanCopy.setServers(new ArrayList<ServerBean>(groupBean.getServers()));
                groupBeanCopy.setClustered(groupBean.getClustered());
                if (fillApplications) {
                    if (groupBean.getServers() != null) {
                        for (ServerBean server : groupBean.getServers()) {
                            ServerAction serverAction = ServerAction.getServerAction(server);
                            try {
                                serverAction.listOfApplications();
                            }
                            catch (Exception e) {
                                groupBeanCopy.setConnected(false);
                            }
                            if (server.getVm() == null) continue;
                            VMMAction vmmAction = VMMAction.getVMMAction(server.getVm());
                            try {
                                String fullServerName = vmmAction.getFullVMName(server.getVm().getName());
                                vmmAction.getVMState(fullServerName);
                            }
                            catch (Exception e) {
                                groupBeanCopy.setConnected(false);
                            }
                        }
                    }
                    this.fillApplications(groupBeanCopy);
                }
                result.add(groupBeanCopy);
            }
            return result;
        }
        return null;
    }

    protected boolean isSameApplication(ApplicationBean a1, ApplicationBean a2) {
        if (a1 == null || a2 == null || a1.getName() == null) {
            return false;
        }
        return a1.getName().equals(a2.getName()) && (a1.getVersion() == a2.getVersion() || a1.getVersion() != null && a1.getVersion().equals(a2.getVersion()));
    }

    protected boolean checkApplication(ServerProgressBean serverProgress, ApplicationBean application, String state, String policy) {
        if (state == null) {
            if (application != null) {
                serverProgress.appendToLog("Application " + application + " exists (it should not exist), checkServer will return false");
                return false;
            }
            return true;
        }
        if (state.equals(application.getState())) {
            if (policy == null) {
                if (application.getPolicy() != null) {
                    serverProgress.appendToLog("Application " + application + " has policy " + application.getPolicy() + " (it should not have any), checkServer will return false");
                    return false;
                }
                return true;
            }
            if (!policy.equals(application.getPolicy())) {
                serverProgress.appendToLog("Application " + application + " has policy " + application.getPolicy() + " instead of " + policy + ", checkServer will return false");
                return false;
            }
            return true;
        }
        serverProgress.appendToLog("Application " + application + " has state " + application.getState() + " instead of " + state + ", checkServer will return false");
        return false;
    }

    protected void refreshActiveSessions() throws JadortServiceException {
        block17: {
            try {
                if (this.operation == null) {
                    return;
                }
                IJadortService.OperationType type = this.operation.getType();
                if (type == null) {
                    return;
                }
                if (type.equals(IJadortService.OperationType.MAINTAIN) || OperationStateBean.Step.SELECT_SERVERS.equals(this.operation.getCurrentStep())) {
                    for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
                        ServerAction serverAction;
                        int activeSessions = 0;
                        try {
                            serverAction = ServerAction.getServerAction(server);
                            activeSessions = serverAction.getActiveSessions();
                        }
                        catch (Exception ignored) {
                            // empty catch block
                        }
                        if (activeSessions == 0 && server.getTarget() != null) {
                            try {
                                serverAction = ServerAction.getServerAction(server.getTarget());
                                activeSessions = serverAction.getActiveSessions();
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                        }
                        server.setActiveSessions(activeSessions);
                    }
                    break block17;
                }
                if (type.equals(IJadortService.OperationType.MIGRATE)) {
                    if (this.operation.getServerProgressList() != null) {
                        for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
                            ServerAction serverAction = ServerAction.getServerAction(serverProgressBean.getServer());
                            String oldApplication = serverProgressBean.getOldDeploymentItem();
                            if (oldApplication != null) {
                                try {
                                    serverProgressBean.getServer().setActiveSessions(serverAction.getActiveSessions(oldApplication));
                                }
                                catch (Exception ignored) {
                                    serverProgressBean.getServer().setActiveSessions(0);
                                }
                                continue;
                            }
                            serverProgressBean.getServer().setActiveSessions(0);
                        }
                    }
                    break block17;
                }
                throw new IllegalStateException("Unknown operation type: " + type);
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot get the number of active sessions: " + e.getMessage(), e);
            }
        }
    }

    protected ServerProgressBean getServerProgress(ServerBean server) throws JadortServiceException {
        for (ServerProgressBean serverProgressBean : this.operation.getServerProgressList()) {
            if (!serverProgressBean.getServer().equals(server)) continue;
            return serverProgressBean;
        }
        throw new JadortServiceException("ServerBean \"" + server + "\" not found", null);
    }

    protected WorkerProgressBean getWorkerProgress(WorkerBean worker) throws JadortServiceException {
        for (WorkerProgressBean workerProgressBean : this.operation.getWorkerProgressList()) {
            if (!workerProgressBean.getWorker().getId().equals(worker.getId())) continue;
            return workerProgressBean;
        }
        throw new JadortServiceException("WorkerBean \"" + worker + "\" not found", null);
    }

    protected void fillWorkerProgressListBasedOnServerProgressList() {
        ArrayList<WorkerProgressBean> workerProgressList = new ArrayList<WorkerProgressBean>();
        HashSet<WorkerBean> workersList = new HashSet<WorkerBean>();
        for (WorkerBean worker : this.operation.getSelectedGroup().getWorkers()) {
            for (ServerProgressBean serverProgress : this.operation.getServerProgressList()) {
                if (!worker.getServer().equals(serverProgress.getServer())) continue;
                workersList.add(worker);
            }
        }
        for (WorkerBean worker : workersList) {
            boolean hasProgress = false;
            if (this.operation.getAllWorkerProgressList() != null) {
                for (WorkerProgressBean oldWorkerProgress : this.operation.getAllWorkerProgressList()) {
                    if (!oldWorkerProgress.getWorker().equals(worker)) continue;
                    hasProgress = true;
                    workerProgressList.add(oldWorkerProgress);
                    break;
                }
            }
            if (hasProgress) continue;
            workerProgressList.add(new WorkerProgressBean(worker));
        }
        this.operation.setWorkerProgressList(workerProgressList);
        this.operation.addAllWorkerProgressList(this.operation.getWorkerProgressList());
    }
}

