/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.api.entities.deployment;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;

@Entity(name="JaDOrT_ApplicationBean")
public class ApplicationBean
implements Serializable {
    private static final long serialVersionUID = -8995544046252693883L;
    @Id
    @GeneratedValue
    private Integer id;
    private String name;
    private String version;
    private File file;
    private String policy;
    private String state;

    public ApplicationBean() {
    }

    public ApplicationBean(File file) throws FileNotFoundException, DeployableHelperException, ArchiveException {
        IDeployable deployable;
        IArchive archive;
        if (!file.exists()) {
            throw new FileNotFoundException("File '" + file + "' not found");
        }
        this.file = file;
        try {
            archive = ArchiveManager.getInstance().getArchive((Object)file);
            deployable = DeployableHelper.getDeployable((IArchive)archive);
            if (deployable == null) {
                throw new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            throw new ArchiveException("File '" + file + "' not valid");
        }
        this.name = deployable.getModuleName();
        this.version = archive.getMetadata().get("Implementation-Version");
        if (this.version != null) {
            this.name = this.name.replace("-version" + this.version, "");
        }
    }

    public ApplicationBean(String name) {
        this.name = name;
    }

    public ApplicationBean(String name, String version) {
        this.name = name;
        this.version = version;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append("[name='");
        sb.append(this.name);
        if (this.version != null) {
            sb.append("', version='");
            sb.append(this.version);
        }
        sb.append("']");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof ApplicationBean) {
            ApplicationBean other = (ApplicationBean)obj;
            if (this.id != null && other.id != null) {
                return this.id.equals(other.id);
            }
        }
        return false;
    }
}

