/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.ow2.jasmine.jadort.api.entities.deployment.VMImageBean;
import org.ow2.jasmine.jadort.api.entities.topology.VMBean;
import org.ow2.jasmine.jadort.service.action.AbstractJMXAction;
import org.ow2.jasmine.jadort.service.action.JasmineVMMAction;
import org.ow2.jasmine.vmm.api.VirtualMachineMXBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VMMAction
extends AbstractJMXAction {
    private static Map<String, VMMAction> pool = new Hashtable<String, VMMAction>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VMMAction getVMMAction(VMBean vm) {
        Map<String, VMMAction> map = pool;
        synchronized (map) {
            String key = VMMAction.getKey(vm);
            VMMAction vmmAction = pool.get(key);
            if (vmmAction == null) {
                vmmAction = VMMAction.newInstance(vm);
                pool.put(key, vmmAction);
            }
            return vmmAction;
        }
    }

    private static String getKey(VMBean vm) {
        StringBuilder sb = new StringBuilder();
        sb.append(vm.getConnector().getConnectorUrl());
        if (vm.getConnector().getUsername() != null && vm.getConnector().getPassword() != null) {
            sb.append(vm.getConnector().getUsername());
            sb.append(vm.getConnector().getPassword());
        }
        return sb.toString();
    }

    protected static VMMAction newInstance(VMBean vm) {
        try {
            Constructor<? extends VMMAction> constructor = VMMAction.getConstructor(JasmineVMMAction.class);
            return constructor.newInstance(vm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed creating the VM action", e);
        }
    }

    protected static Constructor<? extends VMMAction> getConstructor(Class<? extends VMMAction> actionType) throws Exception {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = actionType.getDeclaredConstructors()) {
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length != 1 || params[0] != VMBean.class) continue;
            return constructor;
        }
        return null;
    }

    public abstract String getFullVMName(String var1) throws Exception;

    public abstract void startVM(String var1) throws Exception;

    public abstract void deployImageOnVM(String var1, String var2, String var3) throws Exception;

    public abstract void destroyVM(String var1) throws Exception;

    public abstract void stopVM(String var1) throws Exception;

    public abstract VirtualMachineMXBean.PowerState getVMState(String var1) throws Exception;

    public abstract void waitForVMState(String var1, VirtualMachineMXBean.PowerState var2, long var3) throws Exception;

    public abstract List<VMImageBean> getVMImages() throws Exception;

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VMState {
        RUNNING,
        HALTED;

    }
}

