/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action.modJK;

import org.apache.jk.status.JkBalancer;
import org.apache.jk.status.JkBalancerMember;
import org.apache.jk.status.JkStatus;
import org.ow2.jasmine.jadort.service.action.modJK.JkConnectionException;
import org.ow2.jasmine.jadort.service.action.modJK.JkUpdateAccessor;

public final class JkConnection {
    private JkUpdateAccessor accessor = new JkUpdateAccessor();
    private JkStatus status = null;
    private String urlJkStatus = null;
    private String username = null;
    private String password = null;

    public JkConnection(String urlJkStatus) {
        this(urlJkStatus, null, null);
    }

    public JkConnection(String urlJkStatus, String username, String password) {
        this.urlJkStatus = !urlJkStatus.endsWith("/") ? urlJkStatus + '/' : urlJkStatus;
        this.username = username;
        this.password = password;
    }

    private void getJkStatus() throws JkConnectionException {
        try {
            this.status = this.accessor.status(this.urlJkStatus, this.username, this.password);
            if (!this.status.getResult().getType().equals("OK") || !this.status.getResult().getMessage().equals("Action finished")) {
                throw new JkConnectionException("Invalid status: codeType=" + this.status.getResult().getType() + ", message=" + this.status.getResult().getMessage());
            }
        }
        catch (Exception e) {
            throw new JkConnectionException("Exception querying the accessor", e);
        }
    }

    public JkStatus readStatus_Offline() {
        return this.status;
    }

    public JkStatus readStatus_Online() throws JkConnectionException {
        this.getJkStatus();
        return this.readStatus_Offline();
    }

    public String readWebServerSoftware_Offline() {
        if (null != this.status) {
            return this.status.getSoftware().getWeb_server();
        }
        return null;
    }

    public String readWebServerSoftware_Online() throws JkConnectionException {
        this.getJkStatus();
        return this.readWebServerSoftware_Offline();
    }

    public String readJkVersion_Offline() {
        if (null != this.status) {
            return this.status.getSoftware().getJk_version();
        }
        return null;
    }

    public String readJkVersion_Online() throws JkConnectionException {
        this.getJkStatus();
        return this.readJkVersion_Offline();
    }

    public void updateBalancer(JkBalancer pJkBalancer) throws JkConnectionException {
        try {
            this.status = this.accessor.update(this.urlJkStatus, this.username, this.password, pJkBalancer);
            if (!this.status.getResult().getType().equals("OK") || !this.status.getResult().getMessage().equals("Action finished")) {
                throw new JkConnectionException("Invalid status: codeType=" + this.status.getResult().getType() + ", message=" + this.status.getResult().getMessage());
            }
        }
        catch (Exception e) {
            throw new JkConnectionException("Exception querying the balancer", e);
        }
    }

    public void updateBalancerMember(JkBalancer pJkBalancer, JkBalancerMember pJkBalancerMember) throws JkConnectionException {
        try {
            this.status = this.accessor.update(this.urlJkStatus, this.username, this.password, pJkBalancer, pJkBalancerMember);
            if (!this.status.getResult().getType().equals("OK") || !this.status.getResult().getMessage().equals("Action finished")) {
                throw new JkConnectionException("Invalid status: codeType=" + this.status.getResult().getType() + ", message=" + this.status.getResult().getMessage());
            }
        }
        catch (Exception e) {
            throw new JkConnectionException("Exception querying the balancer", e);
        }
    }
}

