/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action.modProxyBalancer;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.Balancer;
import org.ow2.jasmine.jadort.service.action.modProxyBalancer.Worker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModProxyBalancer {
    private String login;
    private String password;
    private String url;
    protected List<Balancer> balancers;
    protected String nonce;

    public ModProxyBalancer(String url, String login, String password) {
        this.url = url;
        this.login = login;
        this.password = password;
    }

    public ModProxyBalancer(String url) {
        this(url, null, null);
    }

    protected void updateBalancerInfo() throws Exception {
        String response = this.openConnection();
        this.parseAndUpdateModProxyBalancer(response);
    }

    protected void parseAndUpdateModProxyBalancer(String response) {
        ArrayList<Balancer> balancers = new ArrayList<Balancer>();
        String balancerName = null;
        ArrayList<Worker> workers = null;
        while (true) {
            int h3Start = response.indexOf("<h3>");
            int tdStart = response.indexOf("<td><a ");
            if (h3Start > -1 && (tdStart < 0 || h3Start < tdStart)) {
                int h3End;
                int balancerURLStart;
                String s;
                if (balancerName != null && workers != null) {
                    balancers.add(new Balancer(balancerName, workers));
                }
                balancerName = (s = (response = response.substring(h3Start + 4)).substring((balancerURLStart = response.indexOf("balancer://")) + 11, h3End = response.indexOf("</h3>"))).endsWith("</a>") ? s.substring(0, s.lastIndexOf(60)) : s;
                workers = new ArrayList<Worker>();
                response = response.substring(h3End + 4);
                continue;
            }
            if (tdStart <= -1 || h3Start >= 0 && tdStart >= h3Start) break;
            if (balancerName == null) {
                throw new IllegalStateException("Worker's row (<tr> element) is before the balancer's title (<h3> element)");
            }
            response = response.substring(tdStart + 7);
            int tagEnd = response.indexOf("\">");
            int aEnd = response.indexOf("</a></td>");
            int nonceIndex = response.indexOf("&nonce=");
            this.nonce = nonceIndex > 0 ? response.substring(nonceIndex + 7, tagEnd) : null;
            String workerName = response.substring(tagEnd + 2, aEnd);
            response = response.substring(aEnd);
            for (int i = 0; i < 4; ++i) {
                response = response.substring(response.indexOf("</td><td>") + 9);
            }
            String status = response.substring(0, response.indexOf("</td>"));
            try {
                Integer.parseInt(status);
                response = response.substring(response.indexOf("</td><td>") + 9);
                status = response.substring(0, response.indexOf("</td>"));
            }
            catch (NumberFormatException ignored) {
                // empty catch block
            }
            workers.add(new Worker(workerName, !status.startsWith("Dis")));
            response = response.substring(response.indexOf("</td></tr>") + 8);
        }
        if (balancerName != null && workers != null) {
            balancers.add(new Balancer(balancerName, workers));
        }
        this.balancers = balancers;
    }

    protected String openConnection() throws Exception {
        return this.openConnection(null);
    }

    protected String openConnection(String param) throws Exception {
        int responseCode;
        HttpURLConnection con = null;
        String response = null;
        con = param != null ? (HttpURLConnection)new URL(this.url + "?" + param).openConnection() : (HttpURLConnection)new URL(this.url).openConnection();
        con.setRequestMethod("GET");
        if (this.login != null) {
            Base64 enc = new Base64();
            String authData = this.login + ":" + this.password;
            byte[] base64AuthData = enc.encode(authData.getBytes());
            con.setRequestProperty("Authorization", "Basic " + new String(base64AuthData, "UTF-8"));
        }
        if ((responseCode = con.getResponseCode()) != 200) {
            throw new Exception("Connection error: " + con.getResponseMessage());
        }
        InputStream is = con.getInputStream();
        byte[] b = new byte[is.available()];
        int nbOctetsLus = is.read(b);
        response = new String(b, 0, nbOctetsLus);
        return response;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public List<Balancer> getBalancers() throws Exception {
        this.updateBalancerInfo();
        return this.balancers;
    }

    public void activateWorker(String balancerName, String workerUrl) throws Exception {
        this.updateBalancerInfo();
        StringBuffer param = new StringBuffer();
        param.append("dw=Enable");
        param.append("&w=");
        param.append(URLEncoder.encode(workerUrl, "UTF-8"));
        param.append("&b=");
        param.append(URLEncoder.encode(balancerName, "UTF-8"));
        if (this.nonce != null) {
            param.append("&nonce=");
            param.append(this.nonce);
        }
        String response = this.openConnection(param.toString());
        this.parseAndUpdateModProxyBalancer(response);
    }

    public void deactivateWorker(String balancerName, String workerUrl) throws Exception {
        this.updateBalancerInfo();
        StringBuffer param = new StringBuffer();
        param.append("dw=Disable");
        param.append("&w=");
        param.append(URLEncoder.encode(workerUrl, "UTF-8"));
        param.append("&b=");
        param.append(URLEncoder.encode(balancerName, "UTF-8"));
        if (this.nonce != null) {
            param.append("&nonce=");
            param.append(this.nonce);
        }
        String response = this.openConnection(param.toString());
        this.parseAndUpdateModProxyBalancer(response);
    }
}

