/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyServerAction
extends ServerAction {
    private String name;
    public static int CRASH_PROBA_PERCENT = 0;
    public static int MIN_SLEEP = 0;
    public static int MAX_SLEEP = 250;
    private static int MAX_SESSIONS = 20;
    private static Random random = new Random();
    private State state = State.STARTED;
    private Map<String, ApplicationInstanceInformation> applications = new Hashtable<String, ApplicationInstanceInformation>();

    private String dummyAppName(String application) {
        return "/" + this.name + "/apps/" + application + ".ear";
    }

    private void addDummyApplication(String name, ApplicationInstanceInformation.State state) {
        this.addDummyApplication(name, state, null, null);
    }

    private void addDummyApplication(String name, ApplicationInstanceInformation.State state, String version, ApplicationInstanceInformation.Policy policy) {
        String appName = version == null ? this.dummyAppName(name) : this.dummyAppName(name + "-version" + version);
        ApplicationInstanceInformation appInfo = new ApplicationInstanceInformation();
        appInfo.setName(name);
        appInfo.setVersion(version);
        appInfo.setState(state);
        appInfo.setPolicy(policy);
        this.applications.put(appName, appInfo);
    }

    protected DummyServerAction(ServerBean server) {
        this.name = server.getName();
        this.appendToLog("Created DummyServerAction for server '" + this.name + "'");
        this.addDummyApplication("app1", ApplicationInstanceInformation.State.DEPLOYED, "V1", ApplicationInstanceInformation.Policy.DISABLED);
        this.addDummyApplication("app1", ApplicationInstanceInformation.State.DEPLOYED, "V2", ApplicationInstanceInformation.Policy.DEFAULT);
        this.addDummyApplication("app2", ApplicationInstanceInformation.State.DEPLOYED);
    }

    @Override
    protected void connectViaJMX() throws Exception {
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
    }

    @Override
    public List<ApplicationBean> listOfApplications() throws Exception {
        if (this.state != State.STARTED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not started!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        ArrayList<ApplicationBean> result = new ArrayList<ApplicationBean>(this.applications.size());
        for (ApplicationInstanceInformation appInfo : this.applications.values()) {
            ApplicationBean application = new ApplicationBean(appInfo.getName());
            if (appInfo.getState() == ApplicationInstanceInformation.State.PRESENT) {
                application.setState("Present");
            } else {
                application.setState("Deployed");
            }
            if (appInfo.getVersion() != null) {
                application.setVersion(appInfo.getVersion());
                if (appInfo.getPolicy() != null) {
                    String policy = appInfo.getPolicy().toString();
                    policy = policy.charAt(0) + policy.substring(1).toLowerCase();
                    application.setPolicy(policy);
                }
            }
            result.add(application);
        }
        return result;
    }

    @Override
    public boolean canDeployApplications() throws Exception {
        return true;
    }

    @Override
    public boolean canStartStopServer() throws Exception {
        return true;
    }

    private ApplicationInstanceInformation checkState(String appName, ApplicationInstanceInformation.State state) {
        if (appName == null) {
            throw new NullPointerException("Application is null");
        }
        ApplicationInstanceInformation appInfo = this.applications.get(appName);
        if (state == null) {
            if (appInfo != null) {
                throw new IllegalArgumentException("Application '" + appName + "' is " + appInfo.getState().toString() + " whereas it should not exist");
            }
            return null;
        }
        if (appInfo == null) {
            throw new IllegalArgumentException("Application '" + appName + "' does not exist");
        }
        if (!state.equals((Object)appInfo.getState())) {
            throw new IllegalArgumentException("Application '" + appName + "' is " + appInfo.getState().toString() + " whereas it should be " + state.toString());
        }
        return appInfo;
    }

    private ApplicationInstanceInformation checkPolicy(String appName, ApplicationInstanceInformation.State state, ApplicationInstanceInformation.Policy[] policies) {
        ApplicationInstanceInformation appInfo = this.checkState(appName, state);
        if (policies == null) {
            if (appInfo.getPolicy() == null) {
                return appInfo;
            }
            throw new IllegalArgumentException("Application '" + appName + "' has policy " + appInfo.getPolicy().toString() + " whereas it shouldn't have any");
        }
        if (appInfo.getPolicy() == null) {
            throw new IllegalArgumentException("Application '" + appName + "' is not versioned (its policy is null)");
        }
        for (ApplicationInstanceInformation.Policy policy : policies) {
            if (!appInfo.getPolicy().equals((Object)policy)) continue;
            return appInfo;
        }
        throw new IllegalArgumentException("Application '" + appName + "' has policy " + appInfo.getPolicy().toString());
    }

    @Override
    public String upload(ApplicationBean application) throws Exception {
        this.appendToLog("Starting upload of application '" + application.toString() + "'");
        if (this.state != State.STARTED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not started!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is " + CRASH_PROBA_PERCENT);
        String appName = this.dummyAppName(application.toString());
        this.checkState(appName, null);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        ApplicationInstanceInformation appInfo = new ApplicationInstanceInformation();
        appInfo.setName(application.getName());
        appInfo.setVersion(application.getVersion());
        appInfo.setState(ApplicationInstanceInformation.State.PRESENT);
        this.applications.put(appName, appInfo);
        this.appendToLog("Upload of application '" + application.toString() + "' seems to be OK, now checking");
        this.checkState(appName, ApplicationInstanceInformation.State.PRESENT);
        this.appendToLog("Application '" + application.toString() + "' uploaded as '" + appName + "'");
        return appName;
    }

    @Override
    public void deploy(String appName) throws Exception {
        this.appendToLog("Starting deploy of application '" + appName + "'");
        if (this.state != State.STARTED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not started!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is " + CRASH_PROBA_PERCENT);
        ApplicationInstanceInformation appInfo = this.checkState(appName, ApplicationInstanceInformation.State.PRESENT);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        appInfo.setState(ApplicationInstanceInformation.State.DEPLOYED);
        if (appInfo.getVersion() != null) {
            appInfo.setPolicy(ApplicationInstanceInformation.Policy.RESERVED);
        }
        this.appendToLog("Deploy of application '" + appName + "' seems to be OK, now checking");
        this.checkState(appName, ApplicationInstanceInformation.State.DEPLOYED);
        this.appendToLog(appInfo.getVersion() == null ? "Non-versioned" : "Versioned application '" + appName + "' now " + appInfo.getState().toString());
    }

    @Override
    public String setDefault(String appName) throws Exception {
        this.appendToLog("Starting setting application '" + appName + "' as default");
        if (this.state != State.STARTED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not started!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is " + CRASH_PROBA_PERCENT);
        ApplicationInstanceInformation appInfo = this.checkPolicy(appName, ApplicationInstanceInformation.State.DEPLOYED, new ApplicationInstanceInformation.Policy[]{ApplicationInstanceInformation.Policy.RESERVED, ApplicationInstanceInformation.Policy.DISABLED, ApplicationInstanceInformation.Policy.PRIVATE});
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        String oldDefaultName = null;
        for (Map.Entry<String, ApplicationInstanceInformation> entry : this.applications.entrySet()) {
            if (!entry.getValue().getName().equals(appInfo.getName()) || !entry.getValue().getPolicy().equals((Object)ApplicationInstanceInformation.Policy.DEFAULT)) continue;
            entry.getValue().setPolicy(ApplicationInstanceInformation.Policy.DISABLED);
            oldDefaultName = entry.getKey();
            this.appendToLog("Application '" + oldDefaultName + "' now has policy " + entry.getValue().getPolicy().toString());
            break;
        }
        appInfo.setPolicy(ApplicationInstanceInformation.Policy.DEFAULT);
        this.appendToLog("Set application '" + appName + "' as default seems to be OK, now checking");
        this.checkPolicy(appName, ApplicationInstanceInformation.State.DEPLOYED, new ApplicationInstanceInformation.Policy[]{ApplicationInstanceInformation.Policy.DEFAULT});
        this.appendToLog("Application '" + appName + "' now has policy " + appInfo.getPolicy().toString());
        return oldDefaultName;
    }

    @Override
    public void undeploy(String appName) throws Exception {
        this.appendToLog("Starting undeploy of application '" + appName + "'");
        if (this.state != State.STARTED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not started!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is " + CRASH_PROBA_PERCENT);
        ApplicationInstanceInformation appInfo = this.checkState(appName, ApplicationInstanceInformation.State.DEPLOYED);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        appInfo.setState(ApplicationInstanceInformation.State.PRESENT);
        if (appInfo.getVersion() != null) {
            appInfo.setPolicy(null);
        }
        this.appendToLog("Undeploy of application '" + appName + "' seems to be OK, now checking");
        this.checkState(appName, ApplicationInstanceInformation.State.PRESENT);
        this.appendToLog("Application '" + appName + "' now " + appInfo.getState().toString());
    }

    @Override
    public void erase(String appName) throws Exception {
        this.appendToLog("Starting erase of application '" + appName + "'");
        if (this.state != State.STARTED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not started!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is " + CRASH_PROBA_PERCENT);
        this.checkState(appName, ApplicationInstanceInformation.State.PRESENT);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        this.applications.remove(appName);
        this.appendToLog("Erase of application '" + appName + "' seems to be OK, now checking");
        this.checkState(appName, null);
        this.appendToLog("Application '" + appName + "' erased");
    }

    @Override
    public ApplicationBean getApplicationBean(String appName) throws Exception {
        if (this.state != State.STARTED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not started!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        if (appName == null) {
            return null;
        }
        ApplicationInstanceInformation appInfo = this.applications.get(appName);
        if (appInfo == null) {
            return null;
        }
        ApplicationBean application = new ApplicationBean(appInfo.getName());
        if (appInfo.getState() == ApplicationInstanceInformation.State.PRESENT) {
            application.setState("Present");
        } else {
            application.setState("Deployed");
        }
        if (appInfo.getVersion() != null) {
            application.setVersion(appInfo.getVersion());
            String policy = appInfo.getPolicy().toString();
            policy = policy.charAt(0) + policy.substring(1).toLowerCase();
            application.setPolicy(policy);
        }
        return application;
    }

    @Override
    public int getActiveSessions(String appName) throws Exception {
        if (this.state != State.STARTED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not started!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        ApplicationInstanceInformation appInfo = this.applications.get(appName);
        if (appInfo == null) {
            throw new IllegalArgumentException("No application for appName '" + appName + "'!");
        }
        if (appInfo.getState() == ApplicationInstanceInformation.State.DEPLOYED && this.state == State.STARTED) {
            return random.nextInt(MAX_SESSIONS);
        }
        return 0;
    }

    @Override
    public int getActiveSessions() throws Exception {
        if (this.state != State.STARTED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not started!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        if (this.state == State.STARTED) {
            return this.applications.size() * random.nextInt(MAX_SESSIONS);
        }
        return 0;
    }

    @Override
    public void start() throws Exception {
        this.appendToLog("Starting server '" + this.name + "'");
        if (this.state != State.STOPPED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not stopped!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is " + CRASH_PROBA_PERCENT);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        this.state = State.STARTED;
        this.appendToLog("Server '" + this.name + "' has been successfully started");
    }

    @Override
    public void stop() throws Exception {
        this.appendToLog("Stopping server '" + this.name + "'");
        if (this.state != State.STARTED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not started!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is " + CRASH_PROBA_PERCENT);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        this.state = State.STOPPED;
        this.appendToLog("Server '" + this.name + "' has been successfully stopped");
    }

    @Override
    public boolean isStarted() {
        boolean result = this.state == State.STARTED;
        return result;
    }

    @Override
    public boolean enableOrDisableApplications(boolean enable) throws Exception {
        this.appendToLog("Enabling or disabling all applications on server '" + this.name + "'");
        if (this.state != State.STARTED) {
            throw new IllegalArgumentException("Server '" + this.name + "' is not started!");
        }
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is " + CRASH_PROBA_PERCENT);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        this.appendToLog("All applications on server '" + this.name + "' have been enabled or disabled successfully");
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ApplicationInstanceInformation {
        private String name;
        private String version;
        private State state;
        private Policy policy;
        private List<String> mbeans = new ArrayList<String>();

        ApplicationInstanceInformation() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }

        public Policy getPolicy() {
            return this.policy;
        }

        public void setPolicy(Policy policy) {
            this.policy = policy;
        }

        public List<String> getMbeans() {
            return this.mbeans;
        }

        public void setMbeans(List<String> mbeans) {
            this.mbeans = mbeans;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Policy {
            DEFAULT,
            RESERVED,
            DISABLED,
            PRIVATE;

        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum State {
            PRESENT,
            DEPLOYED;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        STARTED,
        STOPPED;

    }
}

