/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.jadort.service.action.AbstractAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJMXAction
extends AbstractAction {
    public static final long JMX_CONNECT_TIMEOUT = -1L;
    public static final long JMX_CHECK_TIMEOUT = -1L;
    protected MBeanServerConnection mbscnx = null;
    protected JMXConnector connector = null;
    private static final ThreadFactory daemonThreadFactory = new DaemonThreadFactory();

    protected void establishJMXConnection(JMXServiceURL url, Map<String, Object> env) throws Exception {
        this.connector = null;
        this.mbscnx = null;
        this.connector = JMXConnectorFactory.connect(url);
        this.mbscnx = this.connector.getMBeanServerConnection();
    }

    private void checkJMXConnectivity() throws Exception {
        this.mbscnx.getMBeanCount();
    }

    public synchronized void checkJMXConnection() throws Exception {
        if (this.mbscnx != null) {
            try {
                this.checkJMXConnectivity();
            }
            catch (IOException e) {
                try {
                    JMXConnector connector = this.connector;
                    this.connector = null;
                    this.mbscnx = null;
                    connector.close();
                    System.gc();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.appendToLog("Connection dropped, reconnecting to JMX server");
            }
        }
        if (this.mbscnx == null) {
            this.connectViaJMX();
        }
    }

    protected abstract void connectViaJMX() throws Exception;

    public void disconnectJMX() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.connector = null;
            this.mbscnx = null;
            System.gc();
        }
    }

    private static <T extends Exception> T initCause(T wrapper, Exception wrapped) {
        wrapper.initCause(wrapped);
        return wrapper;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    }
}

