/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OperationPersistenceManager.java 5638 2009-11-24 17:24:39Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.service.implementation;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;

import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;

/**
 * Contains methods related to the management of the JaDOrT operation's state
 * bean.
 * 
 * @author Arda Aydin
 * @author Malek Chahine
 * @author S. Ali Tokmen
 */
public class OperationPersistenceManager {

    protected OperationStateBean operation;

    // keep this public for tests
    @PersistenceContext
    public EntityManager em;

    /**
     * This method refreshes {@link OperationPersistenceManager#operation} and
     * should be called when entering any method that uses datum that can be
     * modified in another thread than the stateful bean's. This is the case
     * when taking any serverProgress action: the {@link OperationStateBean}
     * gets updated by the {@link JMSReceiver} handler in an
     * asynchronous way.
     */
    protected void refreshOperation() {
        if (this.operation != null) {
            this.operation = this.em.find(OperationStateBean.class, this.operation.getId());
        }
    }

    /**
     * This method merges {@link OperationPersistenceManager#operation} onto the
     * DB.
     */
    protected void mergeOperation() {
        if (this.operation != null) {
            this.operation = this.em.merge(this.operation);
            this.em.flush();
        }
    }
}
