/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlassFishServerAction
extends ServerAction {
    private String name;
    private String url;
    private String username;
    private String password;
    private ObjectName j2eeServer;

    public GlassFishServerAction(ServerBean server) {
        this.name = server.getName();
        this.url = server.getServerConnector().getConnectorUrl();
        this.username = server.getServerConnector().getUsername();
        this.password = server.getServerConnector().getPassword();
        this.appendToLog("Created GlassFishAction for server '" + this.name + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectViaJMX() throws Exception {
        ClassLoader oldCtxCL = Thread.currentThread().getContextClassLoader();
        try {
            HashMap<String, Object> env = new HashMap<String, Object>();
            if (this.username != null && this.password != null) {
                String[] creds = new String[]{this.username, this.password};
                env.put("jmx.remote.credentials", creds);
            }
            this.establishJMXConnection(new JMXServiceURL(this.url), env);
            this.j2eeServer = this.mbscnx.queryNames(new ObjectName("*:j2eeType=J2EEServer,*"), null).iterator().next();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCtxCL);
        }
        this.appendToLog("JMX server connection OK for server '" + this.name + "', J2EEServer is '" + this.j2eeServer + "'");
    }

    @Override
    public boolean canDeployApplications() throws Exception {
        return false;
    }

    @Override
    public boolean canStartStopServer() throws Exception {
        return true;
    }

    @Override
    public void deploy(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public boolean enableOrDisableApplications(boolean enable) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Enabling or disabling all applications on this server");
        boolean failed = false;
        for (ObjectName app : this.mbscnx.queryNames(new ObjectName("*:type=Manager,*"), null)) {
            ObjectName filter;
            String host = app.getKeyProperty("host");
            if ("__asadmin".equals(host)) continue;
            String path = app.getKeyProperty("path");
            if (path == null || path.length() < 1) {
                path = "/";
            }
            try {
                filter = this.mbscnx.queryNames(new ObjectName("*:type=J2EEFilter,path=" + path), null).iterator().next();
            }
            catch (NoSuchElementException e) {
                this.appendToLog("\tApplication on path '" + path + "' doesn't have the OnlyAllowUsersWithSessionFilter filter! Please " + "import the filter JAR from the jadort-samples package and set it in the application's descriptor");
                failed = true;
                continue;
            }
            this.mbscnx.setAttribute(filter, new Attribute("active", !enable));
            this.appendToLog("\tFilter for application on path '" + path + "' has been set as " + (enable ? "in" : "") + "active, application is therefore " + (enable ? "enabled" : "disabled"));
        }
        if (failed) {
            this.appendToLog("At least one application on this server couldn't be " + (enable ? "enabled" : "disabled"));
            return false;
        }
        this.appendToLog("All applications on this server are now " + (enable ? "enabled" : "disabled"));
        return true;
    }

    @Override
    public void erase(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public int getActiveSessions(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public int getActiveSessions() throws Exception {
        int totalActiveSessions = 0;
        if (this.mbscnx != null) {
            this.checkJMXConnection();
            Set<ObjectName> managers = this.mbscnx.queryNames(new ObjectName("*:type=Manager,*"), null);
            for (ObjectName manager : managers) {
                totalActiveSessions += ((Integer)this.mbscnx.getAttribute(manager, "activeSessions")).intValue();
            }
        }
        return totalActiveSessions;
    }

    @Override
    public ApplicationBean getApplicationBean(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public boolean isStarted() {
        try {
            this.checkJMXConnection();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<ApplicationBean> listOfApplications() throws Exception {
        this.checkJMXConnection();
        ArrayList<ApplicationBean> applications = new ArrayList<ApplicationBean>();
        Set<ObjectName> managers = this.mbscnx.queryNames(new ObjectName("*:type=Manager,*"), null);
        for (ObjectName manager : managers) {
            String name;
            String host = manager.getKeyProperty("host");
            if ("__asadmin".equals(host) || (name = manager.getKeyProperty("path")) == null) continue;
            if ((name = name.substring(name.indexOf("/") + 1)).length() == 0) {
                name = "[ ROOT ]";
            }
            ApplicationBean applicationBean = new ApplicationBean(name, null);
            applicationBean.setState("Deployed");
            applications.add(applicationBean);
        }
        return applications;
    }

    @Override
    public String setDefault(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public void start() throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Starting server");
        this.mbscnx.invoke(this.j2eeServer, "start", null, null);
        this.appendToLog("Server is started");
    }

    @Override
    public void stop() throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Stopping server");
        this.mbscnx.invoke(this.j2eeServer, "stop", null, null);
        this.appendToLog("Server is stopped");
    }

    @Override
    public void undeploy(String appName) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }

    @Override
    public String upload(ApplicationBean application) throws Exception {
        throw new UnsupportedOperationException("Operation not implemented yet !");
    }
}

