/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.implementation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.Remote;
import javax.ejb.Stateful;
import javax.xml.bind.UnmarshalException;
import org.ow2.jasmine.jadort.api.IJadortService;
import org.ow2.jasmine.jadort.api.JadortServiceException;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressState;
import org.ow2.jasmine.jadort.api.entities.deployment.VMImageBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressBean;
import org.ow2.jasmine.jadort.api.entities.deployment.WorkerProgressState;
import org.ow2.jasmine.jadort.api.entities.topology.GroupBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.api.entities.topology.TopologyBean;
import org.ow2.jasmine.jadort.api.entities.topology.VMBean;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.api.topology.TopologyReader;
import org.ow2.jasmine.jadort.service.action.ServerAction;
import org.ow2.jasmine.jadort.service.action.VMMAction;
import org.ow2.jasmine.jadort.service.action.WorkerAction;
import org.ow2.jasmine.jadort.service.implementation.JMSSender;
import org.ow2.jasmine.jadort.service.implementation.StepManager;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.archive.impl.ArchiveManager;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployable.OSGiDeployable;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelper;
import org.ow2.util.ee.deploy.impl.helper.DeployableHelperException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Remote(value={IJadortService.class})
@Stateful(mappedName="ow2.jasmine.jadort.ServiceSFB")
public class JadortServiceStatefulBean
extends StepManager
implements IJadortService {
    private static final int BUFFER_SIZE = 16384;
    private Logger logger = Logger.getLogger(this.getClass().getName());

    @PostConstruct
    protected void initialize() {
        try {
            JMSSender.connect();
        }
        catch (Throwable t) {
            String message = "Failed initializing a JadortService stateful bean: " + t.getMessage();
            IllegalStateException exception = new IllegalStateException(message, t);
            this.logger.log(Level.SEVERE, message, t);
            throw exception;
        }
    }

    @PreDestroy
    protected void terminate() {
        try {
            JMSSender.disconnect();
        }
        catch (Throwable t) {
            String message = "Failed terminating a JadortService stateful bean: " + t.getMessage();
            IllegalStateException exception = new IllegalStateException(message, t);
            this.logger.log(Level.SEVERE, message, t);
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStateBean.Step getCurrentStep() {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            if (this.operation == null) {
                return OperationStateBean.Step.SELECT_OPERATION;
            }
            return this.operation.getCurrentStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<OperationStateBean> getOperationsList() throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            ArrayList<OperationStateBean> result = new ArrayList<OperationStateBean>();
            for (OperationStateBean operation : this.em.createQuery("select o from JaDOrT_OperationStateBean o order by o.date asc").getResultList()) {
                OperationStateBean temp = new OperationStateBean();
                temp.setAimedServerProgressState(operation.getAimedServerProgressState());
                temp.setAimedWorkerProgressState(operation.getAimedWorkerProgressState());
                temp.setCurrentStep(operation.getCurrentStep());
                temp.setDate(operation.getDate());
                temp.setId(operation.getId());
                temp.setName(operation.getName());
                temp.setType(operation.getType());
                result.add(temp);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteOperation(OperationStateBean selectedOperation) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            OperationStateBean toRemove = (OperationStateBean)this.em.find(OperationStateBean.class, (Object)selectedOperation.getId());
            if (toRemove.getIsDeletable()) {
                this.em.remove((Object)toRemove);
                this.em.flush();
                if (this.operation != null && selectedOperation.getId() == this.operation.getId()) {
                    this.operation = null;
                }
            } else {
                throw new JadortServiceException("Operation could not be deleted because it currently is in the " + toRemove.getCurrentStep() + " step.", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectOperation(OperationStateBean selectedOperation) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            this.operation = (OperationStateBean)this.em.find(OperationStateBean.class, (Object)selectedOperation.getId());
            if (this.operation == null) {
                throw new JadortServiceException("OperationStateBean \"" + selectedOperation + "\" not found", null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createNewOperation(String newOperationName) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION);
            String filteredOperationName = newOperationName.trim();
            if (filteredOperationName.length() < 1) {
                throw new JadortServiceException("Operation name cannot be empty!", null);
            }
            this.operation = new OperationStateBean();
            this.operation.setName(filteredOperationName);
            this.operation.setDate(new Date());
            this.em.persist((Object)this.operation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationStateBean getCurrentOperation() throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            TopologyBean topology;
            this.refreshOperation();
            if (this.operation == null) {
                return null;
            }
            OperationStateBean bean = new OperationStateBean();
            bean.setAimedServerProgressState(this.operation.getAimedServerProgressState());
            bean.setAimedWorkerProgressState(this.operation.getAimedWorkerProgressState());
            bean.setAimedProgressPercent(this.operation.getAimedProgressPercent());
            bean.setApplication(this.operation.getApplication());
            bean.setCurrentStep(this.operation.getCurrentStep());
            bean.setDate(this.operation.getDate());
            bean.setId(this.operation.getId());
            bean.setName(this.operation.getName());
            bean.setType(this.operation.getType());
            bean.setVmImage(this.operation.getVmImage());
            bean.setCanGoToNextStep(this.canGoToNextStep());
            bean.setCanGoToPreviousStep(this.canGoToPreviousStep());
            if (this.operation.getServerProgressList() != null) {
                bean.setServerProgressList(new ArrayList<ServerProgressBean>(this.operation.getServerProgressList()));
            }
            if (this.operation.getWorkerProgressList() != null) {
                bean.setWorkerProgressList(new ArrayList<WorkerProgressBean>(this.operation.getWorkerProgressList()));
            }
            if (this.operation.getSelectedGroup() != null) {
                GroupBean groupBean = new GroupBean();
                groupBean.setId(this.operation.getSelectedGroup().getId());
                groupBean.setWorkers(new ArrayList<WorkerBean>(this.operation.getSelectedGroup().getWorkers()));
                groupBean.setName(this.operation.getSelectedGroup().getName());
                groupBean.setServers(new ArrayList<ServerBean>(this.operation.getSelectedGroup().getServers()));
                groupBean.setClustered(this.operation.getSelectedGroup().getClustered());
                groupBean.setConnected(this.operation.getSelectedGroup().getConnected());
                bean.setSelectedGroup(groupBean);
            }
            if (this.operation.getCurrentStep().equals(OperationStateBean.Step.INITIALIZE_TOPOLOGY) && this.operation.getTopology() != null) {
                topology = new TopologyBean();
                topology.setGroups(this.fetchGroups(false));
                topology.setId(this.operation.getTopology().getId());
                bean.setTopology(topology);
            }
            if (this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_SERVERS) || this.operation.getCurrentStep().equals(OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER) || this.operation.getCurrentStep().equals(OperationStateBean.Step.UNDEPLOY_ERASE_OLD_VERSION)) {
                this.refreshActiveSessions();
            }
            if (this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_GROUP) && this.operation.getTopology() != null) {
                topology = new TopologyBean();
                topology.setGroups(this.fetchGroups(true));
                topology.setId(this.operation.getTopology().getId());
                bean.setTopology(topology);
            }
            if (bean.getSelectedGroup() != null) {
                if (this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_APPLICATION)) {
                    this.fillApplications(bean.getSelectedGroup());
                }
                if (this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_VM_IMAGE) || this.operation.getCurrentStep().equals(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER)) {
                    this.fillVMImages(bean.getSelectedGroup());
                }
            }
            return bean;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void next() throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            if (!this.canGoToNextStep()) {
                throw new JadortServiceException("You are not allowed to go to the next step!", null);
            }
            this.executeNextStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void previous() throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            if (!this.canGoToPreviousStep()) {
                throw new JadortServiceException("You are not allowed to go to the previous step!", null);
            }
            this.executePreviousStep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadTopology(String topology) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.INITIALIZE_TOPOLOGY);
            TopologyBean topologyBean = null;
            Exception jadortFormatException = null;
            Exception deployMEFormatException = null;
            try {
                topologyBean = TopologyReader.loadJadortSpecificTopology(topology);
            }
            catch (Exception e1) {
                jadortFormatException = e1;
                try {
                    topologyBean = TopologyReader.loadDeployMETopology(topology);
                }
                catch (Exception e2) {
                    deployMEFormatException = e2;
                }
            }
            if (topologyBean == null) {
                StringBuilder sb = new StringBuilder();
                if (jadortFormatException != null && jadortFormatException instanceof UnmarshalException && deployMEFormatException != null && deployMEFormatException instanceof UnmarshalException) {
                    UnmarshalException e2;
                    UnmarshalException e1 = (UnmarshalException)jadortFormatException;
                    if (e1.getLinkedException() != null) {
                        e1 = new UnmarshalException(e1.getLinkedException().getMessage(), (Throwable)e1);
                    }
                    if ((e2 = (UnmarshalException)deployMEFormatException).getLinkedException() != null) {
                        e2 = new UnmarshalException(e2.getLinkedException().getMessage(), (Throwable)e2);
                    }
                    sb.append("The given XML is not a valid JASMINe Deploy ME or JaDOrT topology file.");
                    sb.append("\n\nHere are some potentially helpful error messages:");
                    sb.append("\n\t(For the JaDOrT-specific format: ");
                    sb.append(e1.getMessage());
                    sb.append("\n\t(For the JASMINe DeployME format: ");
                    sb.append(e2.getMessage());
                    throw new JadortServiceException(sb.toString(), null);
                }
                if (deployMEFormatException != null && jadortFormatException != null && jadortFormatException instanceof UnmarshalException) {
                    sb.append("The given XML is not a valid JASMINe Deploy ME or JaDOrT topology file.\n\n");
                    sb.append(deployMEFormatException.getMessage());
                    throw new JadortServiceException(sb.toString(), deployMEFormatException);
                }
                if (jadortFormatException != null && deployMEFormatException != null && deployMEFormatException instanceof UnmarshalException) {
                    sb.append("The given XML is not a valid JaDOrT topology file.\n\n");
                    sb.append(jadortFormatException.getMessage());
                    throw new JadortServiceException(sb.toString(), jadortFormatException);
                }
                sb.append("Cannot load the XML content");
                if (jadortFormatException != null) {
                    throw new JadortServiceException(sb.toString(), jadortFormatException);
                }
                if (deployMEFormatException != null) {
                    throw new JadortServiceException(sb.toString(), deployMEFormatException);
                }
                throw new JadortServiceException(sb.toString(), null);
            }
            this.operation.setTopology(topologyBean);
            this.mergeOperation();
        }
    }

    @Override
    public void selectGroup(GroupBean selectedGroup) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_GROUP);
            for (GroupBean group : this.operation.getTopology().getGroups()) {
                if (!group.getId().equals(selectedGroup.getId())) continue;
                this.fillApplications(group);
                this.fillVMImages(group);
                if (group.getWorkers() != null) {
                    for (WorkerBean worker : group.getWorkers()) {
                        WorkerAction workerAction = WorkerAction.getWorkerAction(worker);
                        try {
                            workerAction.getState();
                        }
                        catch (Exception e) {
                            String message = e.getClass().getName() + ": " + e.getMessage();
                            throw new JadortServiceException("Failed getting the state of worker " + worker.getName() + ": " + message, e);
                        }
                    }
                }
                this.operation.setSelectedGroup(group);
                this.em.flush();
                return;
            }
            throw new JadortServiceException("GroupBean \"" + selectedGroup + "\" not found", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectOperationType(IJadortService.OperationType operationType) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            ServerAction action;
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_OPERATION_TYPE);
            if (IJadortService.OperationType.MAINTAIN.equals(operationType)) {
                for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
                    boolean canStartStopServer;
                    action = ServerAction.getServerAction(server);
                    try {
                        canStartStopServer = action.canStartStopServer();
                    }
                    catch (Exception e) {
                        throw new JadortServiceException("Cannot check if server '" + server + "' can be started/stopped by JaDOrT: " + e.getMessage(), e);
                    }
                    if (canStartStopServer) continue;
                    throw new JadortServiceException("This version of JaDOrT cannot start/stop the server '" + server.getName() + "'. Please use the \"Migration\" functions instead.", null);
                }
            } else if (IJadortService.OperationType.MIGRATE.equals(operationType)) {
                for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
                    boolean canDeployApplications;
                    action = ServerAction.getServerAction(server);
                    try {
                        canDeployApplications = action.canDeployApplications();
                    }
                    catch (JadortServiceException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new JadortServiceException("Cannot check if server '" + server + "' can deploy applications: " + e.getMessage(), e);
                    }
                    if (canDeployApplications) continue;
                    throw new JadortServiceException("This version of JaDOrT doesn't support the deployment of applications on the server '" + server.getName() + "'. Please use the \"Maintenance\" functions instead.", null);
                }
            } else {
                throw new IllegalStateException("Unknown operation type: " + operationType);
            }
            this.operation.setType(operationType);
            HashSet<ServerProgressBean> oldServerProgressList = new HashSet<ServerProgressBean>();
            HashSet<WorkerProgressBean> oldWorkerProgressList = new HashSet<WorkerProgressBean>();
            if (this.operation.getServerProgressList() != null) {
                oldServerProgressList.addAll(this.operation.getServerProgressList());
            }
            if (this.operation.getAllServerProgressList() != null) {
                oldServerProgressList.addAll(this.operation.getAllServerProgressList());
            }
            if (this.operation.getWorkerProgressList() != null) {
                oldWorkerProgressList.addAll(this.operation.getWorkerProgressList());
            }
            if (this.operation.getAllWorkerProgressList() != null) {
                oldWorkerProgressList.addAll(this.operation.getAllWorkerProgressList());
            }
            this.operation.setServerProgressList(null);
            this.operation.setWorkerProgressList(null);
            this.operation.setAllServerProgressList(null);
            this.operation.setAllWorkerProgressList(null);
            this.mergeOperation();
            for (ServerProgressBean serverProgressBean : oldServerProgressList) {
                this.em.remove((Object)serverProgressBean);
            }
            for (WorkerProgressBean workerProgressBean : oldWorkerProgressList) {
                this.em.remove((Object)workerProgressBean);
            }
            this.em.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectApplication(URL url) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            ApplicationBean newApplicationBean;
            File file;
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_APPLICATION);
            if (url.getProtocol().equals("file")) {
                try {
                    file = new File(url.toURI());
                }
                catch (URISyntaxException e) {
                    throw new JadortServiceException("Cannot create file for URL '" + url + "': " + e.getMessage(), e);
                }
            }
            try {
                int read;
                URLConnection connection = url.openConnection();
                InputStream reader = connection.getInputStream();
                String name = url.getPath();
                name = name.substring(name.lastIndexOf(47));
                file = new File(System.getProperty("java.io.tmpdir") + File.separatorChar + "jadort.temp." + System.currentTimeMillis());
                file.mkdirs();
                file = new File(file, name);
                FileOutputStream writer = new FileOutputStream(file);
                byte[] buffer = new byte[16384];
                while ((read = reader.read(buffer)) > 0) {
                    writer.write(buffer, 0, read);
                }
                writer.close();
                reader.close();
            }
            catch (IOException e) {
                throw new JadortServiceException("Cannot read from URL: '" + url + "'", null);
            }
            try {
                newApplicationBean = JadortServiceStatefulBean.createApplicationBeanFromFile(file);
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot create application URL '" + url + "': " + e.getMessage(), e);
            }
            ApplicationBean oldApplicationBean = this.operation.getApplication();
            this.operation.setApplication(newApplicationBean);
            this.mergeOperation();
            if (oldApplicationBean != null) {
                this.em.remove((Object)oldApplicationBean);
                this.em.flush();
            }
        }
    }

    @Override
    public void selectVMImage(VMImageBean selectedVMImage) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_VM_IMAGE);
            this.fillVMImages(this.operation.getSelectedGroup());
            for (VMImageBean vMImage : this.operation.getSelectedGroup().getVmImages()) {
                if (!vMImage.equals(selectedVMImage)) continue;
                VMImageBean oldVMImage = this.operation.getVmImage();
                this.operation.setVmImage(vMImage);
                this.mergeOperation();
                if (oldVMImage != null) {
                    this.em.remove((Object)oldVMImage);
                    this.em.flush();
                }
                return;
            }
            throw new JadortServiceException("VMImageBean \"" + selectedVMImage + "\" not found", null);
        }
    }

    @Override
    public void selectVMImage(VMImageBean selectedVMImage, ServerBean server) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_VM_IMAGE_FOR_SERVER);
            this.fillVMImages(this.operation.getSelectedGroup());
            ServerProgressBean serverProgress = this.getServerProgress(server);
            for (VMImageBean vMImage : this.operation.getSelectedGroup().getVmImages()) {
                if (!vMImage.equals(selectedVMImage)) continue;
                VMImageBean oldVMImage = serverProgress.getVmImage();
                serverProgress.setVmImage(vMImage);
                this.mergeOperation();
                if (oldVMImage != null) {
                    this.em.remove((Object)oldVMImage);
                    this.em.flush();
                }
                return;
            }
            throw new JadortServiceException("VMImageBean \"" + selectedVMImage + "\" not found", null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectServers(List<ServerBean> selectedServers) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.SELECT_SERVERS);
            ArrayList<ServerBean> selectedServersList = new ArrayList<ServerBean>();
            ArrayList<ServerProgressBean> serverProgressList = new ArrayList<ServerProgressBean>();
            block5: for (ServerBean selectedServer : selectedServers) {
                for (ServerBean server : this.operation.getSelectedGroup().getServers()) {
                    if (!server.equals(selectedServer)) continue;
                    if (selectedServersList.contains(server)) continue block5;
                    selectedServersList.add(server);
                    boolean hasProgress = false;
                    if (this.operation.getAllServerProgressList() != null) {
                        for (ServerProgressBean oldServerProgress : this.operation.getAllServerProgressList()) {
                            if (!oldServerProgress.getServer().equals(server)) continue;
                            hasProgress = true;
                            serverProgressList.add(oldServerProgress);
                            break;
                        }
                    }
                    if (hasProgress) continue block5;
                    serverProgressList.add(new ServerProgressBean(server));
                    continue block5;
                }
            }
            if (selectedServersList.size() == 0 || serverProgressList.size() == 0) {
                throw new JadortServiceException("You must select at least one server!", null);
            }
            for (ServerProgressBean serverProgress : serverProgressList) {
                if (!serverProgress.getServer().getProcessed()) continue;
                throw new JadortServiceException("The server '" + serverProgress.getServer().getName() + "' has already been processed!", null);
            }
            ArrayList<VMImageBean> oldVMImages = new ArrayList<VMImageBean>();
            for (ServerProgressBean serverProgress : serverProgressList) {
                String oldVMFullName;
                VMBean vm;
                if (serverProgress.getOldDeploymentItem() != null) {
                    throw new JadortServiceException("The VM for server '" + serverProgress.getServer().getName() + "' has already been processed!", null);
                }
                if (serverProgress.getVmImage() != null) {
                    oldVMImages.add(serverProgress.getVmImage());
                }
                if (this.operation.getVmImage() != null) {
                    VMImageBean image = new VMImageBean();
                    image.setName(this.operation.getVmImage().getName());
                    image.setUuid(this.operation.getVmImage().getUuid());
                    serverProgress.setVmImage(image);
                } else {
                    serverProgress.setVmImage(null);
                }
                if ((vm = serverProgress.getServer().getVm()) == null) continue;
                VMMAction vmmAction = VMMAction.getVMMAction(vm);
                try {
                    oldVMFullName = vmmAction.getFullVMName(vm.getName());
                }
                catch (Exception e) {
                    throw new JadortServiceException("Failed getting the full VM name for VM '" + vm.getName() + "': " + e.getMessage(), e);
                }
                serverProgress.setOldDeploymentItem(oldVMFullName);
            }
            this.operation.setServerProgressList(serverProgressList);
            this.operation.addAllServerProgressList(serverProgressList);
            if (this.operation.getType().equals(IJadortService.OperationType.MAINTAIN)) {
                this.fillWorkerProgressListBasedOnServerProgressList();
            }
            this.mergeOperation();
            for (VMImageBean oldVMImage : oldVMImages) {
                this.em.remove((Object)oldVMImage);
                this.em.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortServer(ServerBean server) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION, OperationStateBean.Step.UNDEPLOY_ERASE_OLD_VERSION, OperationStateBean.Step.EXECUTING_MIGRATION_OSGI, OperationStateBean.Step.ERASE_OLD_VERSIONS, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            ServerProgressBean serverProgress = this.getServerProgress(server);
            if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) {
                return;
            }
            serverProgress.appendToLog("Action has been aborted by the user");
            serverProgress.setProgress(this.operation.getAimedProgressPercent());
            serverProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            this.mergeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartServer(ServerBean server) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION, OperationStateBean.Step.UNDEPLOY_ERASE_OLD_VERSION, OperationStateBean.Step.EXECUTING_MIGRATION_OSGI, OperationStateBean.Step.ERASE_OLD_VERSIONS, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER, OperationStateBean.Step.DESTROY_OLD_VM_HOSTS);
            ServerProgressBean serverProgress = this.getServerProgress(server);
            if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Server state for server '" + server.getName() + "' is " + serverProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            serverProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            this.mergeOperation();
            this.reachAimedServerProgressState(this.getServerProgress(server));
        }
    }

    @Override
    public boolean checkServer(ServerBean server) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION, OperationStateBean.Step.UNDEPLOY_ERASE_OLD_VERSION, OperationStateBean.Step.EXECUTING_MIGRATION_OSGI, OperationStateBean.Step.ERASE_OLD_VERSIONS, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER, OperationStateBean.Step.DESTROY_OLD_VM_HOSTS);
            try {
                ServerProgressBean serverProgress = this.getServerProgress(server);
                ServerAction serverAction = ServerAction.getServerAction(serverProgress.getServer());
                List<ApplicationBean> applications = serverAction.listOfApplications();
                ServerProgressState serverProgressState = serverProgress.getProgressState();
                if (serverProgressState.equals(ServerProgressState.INITIAL)) {
                    IJadortService.OperationType type = this.operation.getType();
                    if (type.equals(IJadortService.OperationType.MAINTAIN)) {
                        return serverAction.isStarted();
                    }
                    if (type.equals(IJadortService.OperationType.MIGRATE)) {
                        for (ApplicationBean application : applications) {
                            if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, null, null)) {
                                return false;
                            }
                            if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, null, null)) {
                                return false;
                            }
                            if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, "Deployed", "Default")) continue;
                            return false;
                        }
                        return true;
                    }
                    throw new IllegalStateException("Unknown OperationType: " + type);
                }
                if (serverProgressState.equals(ServerProgressState.UPLOAD_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Present", null)) {
                            return false;
                        }
                        if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, "Present", null)) {
                            return false;
                        }
                        if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, "Deployed", "Default")) continue;
                        return false;
                    }
                    return true;
                }
                if (serverProgressState.equals(ServerProgressState.DEPLOY_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Reserved")) {
                            return false;
                        }
                        if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Reserved")) {
                            return false;
                        }
                        if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, "Deployed", "Default")) continue;
                        return false;
                    }
                    return true;
                }
                if (serverProgressState.equals(ServerProgressState.SET_DEFAULT_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, "Deployed", "Disabled")) continue;
                        return false;
                    }
                    return true;
                }
                if (serverProgressState.equals(ServerProgressState.UNDEPLOY_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, "Present", null)) continue;
                        return false;
                    }
                    return true;
                }
                if (serverProgressState.equals(ServerProgressState.ERASE_OK)) {
                    for (ApplicationBean application : applications) {
                        if (this.isSameApplication(this.operation.getApplication(), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (this.isSameApplication(serverAction.getApplicationBean(serverProgress.getNewDeploymentItem()), application) && !this.checkApplication(serverProgress, application, "Deployed", "Default")) {
                            return false;
                        }
                        if (!this.isSameApplication(serverAction.getApplicationBean(serverProgress.getOldDeploymentItem()), application) || this.checkApplication(serverProgress, application, null, null)) continue;
                        return false;
                    }
                    return true;
                }
                if (serverProgressState.equals(ServerProgressState.DISABLE_APPLICATIONS_OK) || serverProgressState.equals(ServerProgressState.START_OK)) {
                    return serverAction.isStarted();
                }
                if (serverProgressState.equals(ServerProgressState.STOP_OK) || serverProgressState.equals(ServerProgressState.MAINTAIN_OK)) {
                    return !serverAction.isStarted();
                }
                if (serverProgressState.equals(ServerProgressState.DESTROY_VM_HOSTS_OK)) {
                    return false;
                }
                throw new IllegalStateException("Unknown ServerProgressState: " + serverProgressState);
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot check server '" + server + "': " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignoreServer(ServerBean server) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MIGRATION, OperationStateBean.Step.UNDEPLOY_ERASE_OLD_VERSION, OperationStateBean.Step.EXECUTING_MIGRATION_OSGI, OperationStateBean.Step.ERASE_OLD_VERSIONS, OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            ServerProgressBean serverProgress = this.getServerProgress(server);
            if (ServerProgressState.INITIAL.equals(serverProgress.getProgressState()) && ServerProgressState.UPLOAD_OK.equals(this.operation.getAimedServerProgressState())) {
                throw new JadortServiceException("The application upload step is mandatory for JaDOrT to function properly. It cannot be ignored.", null);
            }
            if (ServerProgressState.STOP_OK.equals(serverProgress.getProgressState()) && ServerProgressState.MAINTAIN_OK.equals(this.operation.getAimedServerProgressState())) {
                throw new JadortServiceException("The server maintain step is mandatory for JaDOrT to function properly. It cannot be ignored.", null);
            }
            if (!serverProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Server state for server '" + server.getName() + "' is " + serverProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            serverProgress.appendToLog("Error on the server has been ignored by the user");
            serverProgress.setProgress(this.operation.getAimedProgressPercent());
            serverProgress.setActionState(OperationStateBean.ActionState.WAITING);
            serverProgress.setProgressState(this.operation.getAimedServerProgressState());
            this.mergeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abortWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.RUNNING)) {
                return;
            }
            workerProgress.appendToLog("Action has been aborted by the user");
            workerProgress.setProgress(this.operation.getAimedProgressPercent());
            workerProgress.setActionState(OperationStateBean.ActionState.FINISHED_ERROR);
            this.mergeOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restartWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Worker state for worker '" + worker.getName() + "' is " + workerProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            workerProgress.setActionState(OperationStateBean.ActionState.RUNNING);
            this.mergeOperation();
            this.reachAimedWorkerProgressState(this.getWorkerProgress(worker));
        }
    }

    @Override
    public boolean checkWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            try {
                WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
                WorkerAction workerAction = WorkerAction.getWorkerAction(workerProgress.getWorker());
                WorkerAction.State state = workerAction.getState();
                WorkerProgressState workerProgressState = workerProgress.getProgressState();
                if (workerProgressState.equals(WorkerProgressState.INITIAL) || workerProgressState.equals(WorkerProgressState.START_OK)) {
                    return state == WorkerAction.State.ACTIVE;
                }
                if (workerProgressState.equals(WorkerProgressState.STOP_OK)) {
                    return state == WorkerAction.State.STOPPED;
                }
                throw new IllegalStateException("Unknown WorkerProgressState: " + workerProgressState);
            }
            catch (Exception e) {
                throw new JadortServiceException("Cannot check worker '" + worker + "': " + e.getMessage(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ignoreWorker(WorkerBean worker) throws JadortServiceException {
        JadortServiceStatefulBean jadortServiceStatefulBean = this;
        synchronized (jadortServiceStatefulBean) {
            this.refreshOperation();
            this.checkStep(OperationStateBean.Step.EXECUTING_MAINTENANCE_CLUSTER, OperationStateBean.Step.EXECUTING_MAINTENANCE_NO_CLUSTER);
            WorkerProgressBean workerProgress = this.getWorkerProgress(worker);
            if (!workerProgress.getActionState().equals(OperationStateBean.ActionState.FINISHED_ERROR)) {
                throw new JadortServiceException("Worker state for worker '" + worker.getName() + "' is " + workerProgress.getActionState() + ", it should be " + OperationStateBean.ActionState.FINISHED_ERROR, null);
            }
            workerProgress.appendToLog("Error on the worker has been ignored by the user");
            workerProgress.setProgress(this.operation.getAimedProgressPercent());
            workerProgress.setActionState(OperationStateBean.ActionState.WAITING);
            workerProgress.setProgressState(this.operation.getAimedWorkerProgressState());
            this.mergeOperation();
        }
    }

    public static ApplicationBean createApplicationBeanFromFile(File file) throws FileNotFoundException, DeployableHelperException, ArchiveException {
        IDeployable deployable;
        IArchive archive;
        if (!file.exists()) {
            throw new FileNotFoundException("File '" + file + "' not found");
        }
        try {
            archive = ArchiveManager.getInstance().getArchive((Object)file);
            deployable = DeployableHelper.getDeployable((IArchive)archive);
            if (deployable == null) {
                throw new NullPointerException();
            }
        }
        catch (NullPointerException e) {
            throw new ArchiveException("File '" + file + "' not valid");
        }
        String name = deployable.getModuleName();
        String version = archive.getMetadata().get("Implementation-Version");
        ApplicationBean.ApplicationType applicationType = OSGiDeployable.class.isInstance(deployable) ? ApplicationBean.ApplicationType.OSGI : ApplicationBean.ApplicationType.JAVA_EE;
        if (version != null) {
            String mavenStyleVersion;
            String versioningStyleVersion = "-version" + version;
            if (name.endsWith(versioningStyleVersion)) {
                name = name.substring(0, name.length() - versioningStyleVersion.length());
            }
            if (name.endsWith(mavenStyleVersion = "-" + version)) {
                name = name.substring(0, name.length() - mavenStyleVersion.length());
            }
        }
        ApplicationBean result = new ApplicationBean(name, version);
        result.setFile(file);
        result.setApplicationType(applicationType);
        return result;
    }
}

