/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServerProgressState.java 3601 2009-04-30 13:58:52Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api.entities.deployment;

/**
 * Different possible progress states of a {@link ServerProgressBean}.
 */
public class ServerProgressState extends ProgressState {

    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = 120139640121212822L;

    public static final ServerProgressState INITIAL = new ServerProgressState("INITIAL");

    public static final ServerProgressState UPLOAD_OK = new ServerProgressState("UPLOAD_OK");

    public static final ServerProgressState DEPLOY_OK = new ServerProgressState("DEPLOY_OK");

    public static final ServerProgressState SET_DEFAULT_OK = new ServerProgressState("SET_DEFAULT_OK");

    public static final ServerProgressState UNDEPLOY_OK = new ServerProgressState("UNDEPLOY_OK");

    public static final ServerProgressState ERASE_OK = new ServerProgressState("ERASE_OK");

    public static final ServerProgressState DISABLE_APPLICATIONS_OK = new ServerProgressState("DISABLE_APPLICATIONS_OK");

    public static final ServerProgressState STOP_OK = new ServerProgressState("STOP_OK");

    public static final ServerProgressState MAINTAIN_OK = new ServerProgressState("MAINTAIN_OK");

    public static final ServerProgressState START_OK = new ServerProgressState("START_OK");

    public static final ServerProgressState DESTROY_VM_HOSTS_OK = new ServerProgressState("DESTROY_VM_HOSTS_OK");

    private static final ServerProgressState[] values = new ServerProgressState[] {ServerProgressState.INITIAL,
        ServerProgressState.UPLOAD_OK, ServerProgressState.DEPLOY_OK, ServerProgressState.SET_DEFAULT_OK,
        ServerProgressState.UNDEPLOY_OK, ServerProgressState.ERASE_OK, ServerProgressState.DISABLE_APPLICATIONS_OK,
        ServerProgressState.STOP_OK, ServerProgressState.MAINTAIN_OK, ServerProgressState.START_OK,
        ServerProgressState.DESTROY_VM_HOSTS_OK};

    private String serverProgressState;

    /**
     * @param serverProgressState ServerProgressState.
     */
    private ServerProgressState(final String serverProgressState) {
        this.serverProgressState = serverProgressState;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public boolean equals(final Object object) {
        if ((object != null) && (object instanceof ServerProgressState)) {
            ServerProgressState serverProgressState = (ServerProgressState) object;
            if (serverProgressState.serverProgressState.equals(this.serverProgressState)) {
                return true;
            }
        }

        return false;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public int hashCode() {
        return this.serverProgressState.hashCode();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.serverProgressState;
    }

    /**
     * @return All ServerProgressState values.
     */
    public static ServerProgressState[] values() {
        return ServerProgressState.values;
    }

    /**
     * Get the ServerProgressState for a string.
     * 
     * @param string ServerProgressState string.
     * @return ServerProgressState for that string.
     */
    public static ServerProgressState valueOf(final String string) {
        for (ServerProgressState serverProgressState : ServerProgressState.values) {
            if (serverProgressState.serverProgressState.equals(string)) {
                return serverProgressState;
            }
        }

        throw new IllegalArgumentException("Unknown value: " + string);
    }
}
