/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.util.Random;
import org.ow2.jasmine.jadort.api.entities.topology.WorkerBean;
import org.ow2.jasmine.jadort.service.action.WorkerAction;

public class DummyWorkerAction
extends WorkerAction {
    private String name;
    private WorkerAction.State state;
    public static int CRASH_PROBA_PERCENT = 0;
    public static int MIN_SLEEP = 0;
    public static int MAX_SLEEP = 250;
    private static Random random = new Random();

    protected DummyWorkerAction(WorkerBean worker) {
        this.name = worker.getName();
        this.state = WorkerAction.State.ACTIVE;
        this.appendToLog("Created DummyWorkerAction for worker '" + this.name + "'");
    }

    public void enable() throws Exception {
        this.appendToLog("Enabling worker '" + this.name + "'");
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is " + CRASH_PROBA_PERCENT);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        this.state = WorkerAction.State.ACTIVE;
        this.appendToLog("Worker '" + this.name + "' has been succesuffully enabled");
    }

    public void disable() throws Exception {
        this.appendToLog("Disabling worker '" + this.name + "'");
        long wait = random.nextInt(MAX_SLEEP - MIN_SLEEP) + MIN_SLEEP;
        int crash = random.nextInt(100);
        this.appendToLog("This should take " + wait + " milliseconds, crash is " + crash + ", CRASH_PROBA_PERCENT is " + CRASH_PROBA_PERCENT);
        Thread.sleep(wait);
        if (crash < CRASH_PROBA_PERCENT) {
            throw new Exception("This has crashed for no reason !");
        }
        this.state = WorkerAction.State.DISABLED;
        this.appendToLog("Worker '" + this.name + "' has  been succesuffully disabled");
    }

    public WorkerAction.State getState() throws Exception {
        return this.state;
    }
}

