/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.service.action.AbstractJMXAction;
import org.ow2.jasmine.jadort.service.action.DummyServerAction;
import org.ow2.jasmine.jadort.service.action.GlassFishServerAction;
import org.ow2.jasmine.jadort.service.action.JBossServerAction;
import org.ow2.jasmine.jadort.service.action.JonasServerAction;
import org.ow2.jasmine.jadort.service.action.OSGiServerAction;
import org.ow2.jasmine.jadort.service.action.WebLogicServerAction;
import org.ow2.jasmine.jadort.service.action.WebSphereServerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServerAction
extends AbstractJMXAction {
    private static final int FILE_READ_BUFFER_SIZE = 1024;
    public static final String STATE_PRESENT = "Present";
    public static final String STATE_DEPLOYED = "Deployed";
    private static Map<String, ServerAction> pool = new Hashtable<String, ServerAction>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServerAction getServerAction(ServerBean server) {
        Map<String, ServerAction> map = pool;
        synchronized (map) {
            String key = ServerAction.getKey(server);
            ServerAction serverAction = pool.get(key);
            if (serverAction == null) {
                serverAction = ServerAction.newInstance(server);
                pool.put(key, serverAction);
            }
            return serverAction;
        }
    }

    private static String getKey(ServerBean server) {
        StringBuilder sb = new StringBuilder();
        sb.append(server.getName());
        sb.append(server.getType());
        sb.append(server.getServerConnector().getConnectorUrl());
        if (server.getServerConnector().getUsername() != null && server.getServerConnector().getPassword() != null) {
            sb.append(server.getServerConnector().getUsername());
            sb.append(server.getServerConnector().getPassword());
        }
        return sb.toString();
    }

    protected static ServerAction newInstance(ServerBean server) {
        try {
            Constructor<? extends ServerAction> constructor;
            if (server.getType().equals(ServerBean.Type.DUMMY)) {
                constructor = ServerAction.getConstructor(DummyServerAction.class);
            } else if (server.getType().equals(ServerBean.Type.JONAS)) {
                constructor = ServerAction.getConstructor(JonasServerAction.class);
            } else if (server.getType().equals(ServerBean.Type.JBOSS)) {
                constructor = ServerAction.getConstructor(JBossServerAction.class);
            } else if (server.getType().equals(ServerBean.Type.GLASSFISH)) {
                constructor = ServerAction.getConstructor(GlassFishServerAction.class);
            } else if (server.getType().equals(ServerBean.Type.OSGI)) {
                constructor = ServerAction.getConstructor(OSGiServerAction.class);
            } else if (server.getType().equals(ServerBean.Type.WEBLOGIC)) {
                constructor = ServerAction.getConstructor(WebLogicServerAction.class);
            } else if (server.getType().equals(ServerBean.Type.WEBSPHERE)) {
                constructor = ServerAction.getConstructor(WebSphereServerAction.class);
            } else {
                throw new IllegalArgumentException("Unknown server type :" + server.getType());
            }
            return constructor.newInstance(server);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed creating the server action", e);
        }
    }

    protected static Constructor<? extends ServerAction> getConstructor(Class<? extends ServerAction> actionType) throws Exception {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = actionType.getDeclaredConstructors()) {
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length != 1 || params[0] != ServerBean.class) continue;
            return constructor;
        }
        return null;
    }

    public abstract List<ApplicationBean> listOfApplications() throws Exception;

    public abstract boolean canDeployApplications() throws Exception;

    public boolean canDeployApplicationsOfType(ApplicationBean.ApplicationType applicationType) throws Exception {
        return this.canDeployApplications();
    }

    public abstract boolean canStartStopServer() throws Exception;

    public abstract String upload(ApplicationBean var1) throws Exception;

    public abstract ApplicationBean getApplicationBean(String var1) throws Exception;

    public abstract void deploy(String var1) throws Exception;

    public abstract String setDefault(String var1) throws Exception;

    public abstract void undeploy(String var1) throws Exception;

    public abstract void erase(String var1) throws Exception;

    public abstract int getActiveSessions(String var1) throws Exception;

    public abstract int getActiveSessions() throws Exception;

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract boolean isStarted();

    public abstract boolean enableOrDisableApplications(boolean var1) throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] obtainByteData(File file) throws IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            byte[] byArray;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                int readBytes;
                byte[] bytes = new byte[1024];
                while ((readBytes = ((InputStream)inputStream).read(bytes)) > 0) {
                    outputStream.write(bytes, 0, readBytes);
                }
                byArray = outputStream.toByteArray();
            }
            catch (Throwable throwable) {
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return byArray;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }
}

