/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jasmine.jadort.service.action;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.ow2.jasmine.jadort.api.JadortServiceException;
import org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean;
import org.ow2.jasmine.jadort.api.entities.topology.ConnectorBean;
import org.ow2.jasmine.jadort.api.entities.topology.ServerBean;
import org.ow2.jasmine.jadort.service.action.ServerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JonasServerAction
extends ServerAction {
    private String name;
    private ConnectorBean serverConnector;
    private ConnectorBean managerConnector;
    private ObjectName j2eeServer;
    private ObjectName versioningService;
    private String serverVersion;
    private boolean canDeployApplications;
    private String stopMethod;
    private boolean hasState;

    protected JonasServerAction(ServerBean server) {
        this.name = server.getName();
        this.serverConnector = server.getServerConnector();
        this.managerConnector = server.getManagerConnector();
        this.appendToLog("Created JonasServerAction for server '" + this.name + "'");
    }

    @Override
    public synchronized void checkJMXConnection() throws Exception {
        ObjectName versioning;
        Set<ObjectName> versioningService;
        super.checkJMXConnection();
        if (this.versioningService == null && (versioningService = this.mbscnx.queryNames(new ObjectName("*:type=service,name=versioning"), null)) != null && !versioningService.isEmpty() && ((Boolean)this.mbscnx.getAttribute(versioning = versioningService.iterator().next(), "VersioningEnabled")).booleanValue()) {
            this.versioningService = versioning;
        }
    }

    @Override
    protected void connectViaJMX() throws Exception {
        String url = this.serverConnector.getConnectorUrl();
        String username = this.serverConnector.getUsername();
        String password = this.serverConnector.getPassword();
        HashMap<String, Object> env = new HashMap<String, Object>();
        if (username != null && password != null) {
            String[] creds = new String[]{username, password};
            env.put("jmx.remote.credentials", creds);
        }
        this.establishJMXConnection(new JMXServiceURL(url), env);
        this.j2eeServer = this.mbscnx.queryNames(new ObjectName("*:j2eeType=J2EEServer,*"), null).iterator().next();
        this.stopMethod = null;
        this.canDeployApplications = false;
        this.serverVersion = (String)this.mbscnx.getAttribute(this.j2eeServer, "serverVersion");
        for (MBeanOperationInfo mBeanOperationInfo : this.mbscnx.getMBeanInfo(this.j2eeServer).getOperations()) {
            if ("halt".equals(mBeanOperationInfo.getName())) {
                this.stopMethod = "halt";
                continue;
            }
            if (!"deploy".equals(mBeanOperationInfo.getName())) continue;
            this.canDeployApplications = true;
        }
        if (this.stopMethod == null) {
            this.stopMethod = "stop";
        }
        this.hasState = false;
        for (MBeanFeatureInfo mBeanFeatureInfo : this.mbscnx.getMBeanInfo(this.j2eeServer).getAttributes()) {
            if (!"state".equals(mBeanFeatureInfo.getName())) continue;
            this.hasState = true;
            break;
        }
        this.versioningService = null;
        this.appendToLog("JMX server connection OK for server '" + this.name + "', J2EEServer is '" + this.j2eeServer + "'");
    }

    @Override
    public boolean canDeployApplications() throws Exception {
        this.checkJMXConnection();
        if (this.serverVersion.startsWith("5.1.1")) {
            throw new JadortServiceException("The server '" + this.name + "' is running OW2 JOnAS version 5.1.1. " + "Due to the bug http://jira.ow2.org/browse/JONAS-96 application migration is not possible on that version. " + "Please upgrade your target JOnAS server's version using the \"Maintenance\" functions instead.", null);
        }
        return this.canDeployApplications;
    }

    @Override
    public boolean canDeployApplicationsOfType(ApplicationBean.ApplicationType applicationType) throws Exception {
        this.checkJMXConnection();
        if (ApplicationBean.ApplicationType.OSGI.equals(applicationType) && (this.serverVersion.compareTo("5.1.3") >= 0 && this.serverVersion.compareTo("5.1.6") <= 0 || this.serverVersion.startsWith("5.2.0-M3"))) {
            throw new JadortServiceException("The server '" + this.name + "' is running OW2 JOnAS version between 5.1.3 and " + "5.1.6 or version 5.2.0-M3. Due to the bug http://jira.ow2.org/browse/JONAS-292 OSGi migration is not " + "possible on any of these versions. Please upgrade your target JOnAS server's version using the " + "\"Maintenance\" functions instead.", null);
        }
        return super.canDeployApplicationsOfType(applicationType);
    }

    @Override
    public boolean canStartStopServer() throws Exception {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected Map<String, ApplicationInformation> getApplicationsList() throws Exception {
        String applicationName;
        HashMap<String, ApplicationInformation> applications = new HashMap<String, ApplicationInformation>();
        HashSet nonVersionedEjbsAndWars = new HashSet();
        List deployedJars = (List)this.mbscnx.getAttribute(this.j2eeServer, "deployedJars");
        Set<ObjectName> ears = this.mbscnx.queryNames(new ObjectName("*:j2eeType=J2EEApplication,*"), null);
        HashMap<ObjectName, ObjectName> versionedEjbsAndWars = new HashMap<ObjectName, ObjectName>();
        HashSet<ObjectName> realEjbMBeans = new HashSet<ObjectName>();
        HashSet<ObjectName> virtualEjbMBeans = new HashSet<ObjectName>();
        for (ObjectName objectName : this.mbscnx.queryNames(new ObjectName("*:j2eeType=EJBModule,*"), null)) {
            if ("true".equals(objectName.getKeyProperty("virtualContext"))) {
                virtualEjbMBeans.add(objectName);
                continue;
            }
            realEjbMBeans.add(objectName);
            deployedJars.remove(this.getPath(objectName));
        }
        for (ObjectName objectName : virtualEjbMBeans) {
            String baseName = objectName.getKeyProperty("name").substring("VirtualContainer-".length());
            for (ObjectName ejbMBean : realEjbMBeans) {
                if (ejbMBean.getKeyProperty("name").startsWith(baseName)) {
                    versionedEjbsAndWars.put(ejbMBean, objectName);
                    continue;
                }
                String appName = ejbMBean.getKeyProperty("J2EEApplication");
                if (appName == null || appName.equals("none") || !appName.startsWith(baseName)) continue;
                versionedEjbsAndWars.put(ejbMBean, objectName);
            }
        }
        HashSet<ObjectName> realWarMBeans = new HashSet<ObjectName>();
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>();
        for (ObjectName war : this.mbscnx.queryNames(new ObjectName("*:j2eeType=WebModule,*"), null)) {
            if ("true".equals(war.getKeyProperty("virtualContext"))) {
                hashSet.add(war);
                continue;
            }
            realWarMBeans.add(war);
        }
        for (ObjectName virtualWarMBean : hashSet) {
            Map contexts = (Map)this.mbscnx.getAttribute(virtualWarMBean, "Contexts");
            block7: for (Object contextKey : contexts.keySet()) {
                for (ObjectName warMBean : realWarMBeans) {
                    if (!warMBean.getKeyProperty("name").startsWith(virtualWarMBean.getKeyProperty("name")) || !warMBean.getKeyProperty("name").endsWith(contextKey.toString())) continue;
                    versionedEjbsAndWars.put(warMBean, virtualWarMBean);
                    continue block7;
                }
            }
        }
        realEjbMBeans.removeAll(versionedEjbsAndWars.keySet());
        realWarMBeans.removeAll(versionedEjbsAndWars.keySet());
        nonVersionedEjbsAndWars.addAll(realEjbMBeans);
        nonVersionedEjbsAndWars.addAll(realWarMBeans);
        for (Map.Entry versionedEjbOrWar : versionedEjbsAndWars.entrySet()) {
            for (Map.Entry entry : ((Map)this.mbscnx.getAttribute((ObjectName)versionedEjbOrWar.getValue(), "Contexts")).entrySet()) {
                String versionID;
                ObjectName j2eeApplication;
                String applicationName2 = ((ObjectName)versionedEjbOrWar.getKey()).getKeyProperty("J2EEApplication");
                if (applicationName2 == null || applicationName2.equals("none") || applicationName2.equals("null")) {
                    int nextSlash;
                    applicationName2 = ((ObjectName)versionedEjbOrWar.getKey()).getKeyProperty("name");
                    j2eeApplication = (ObjectName)versionedEjbOrWar.getKey();
                    int doubleSlash = applicationName2.indexOf("//");
                    if (doubleSlash >= 0 && (nextSlash = applicationName2.indexOf(47, doubleSlash + 2)) >= 0) {
                        applicationName2 = applicationName2.substring(nextSlash + 1);
                    }
                } else {
                    Set<ObjectName> j2eeApplications = this.mbscnx.queryNames(new ObjectName("*:j2eeType=J2EEApplication,name=" + applicationName2 + ",*"), null);
                    if (j2eeApplications.size() == 0) {
                        throw new IllegalStateException("The application " + applicationName2 + " is not deployed correctly!");
                    }
                    j2eeApplication = j2eeApplications.iterator().next();
                    ears.remove(j2eeApplication);
                }
                try {
                    URL j2eeApplicationURL = new URL("file:" + this.getPath(j2eeApplication));
                    Object[] opParams = new Object[]{j2eeApplicationURL};
                    String[] opSignature = new String[]{URL.class.getName()};
                    versionID = (String)this.mbscnx.invoke(this.versioningService, "getVersionID", opParams, opSignature);
                }
                catch (AttributeNotFoundException e) {
                    int versionIdStart = applicationName2.lastIndexOf("-version");
                    versionID = versionIdStart != -1 ? applicationName2.substring(versionIdStart) : null;
                }
                if (versionID == null) continue;
                String VERSION_ID = "-version";
                String versionNumber = versionID.startsWith("-version") ? versionID.substring(8) : versionID.substring(1);
                if (applicationName2.endsWith(versionID)) {
                    applicationName2 = applicationName2.substring(0, applicationName2.length() - versionID.length());
                }
                if (applicationName2.endsWith("-" + versionNumber)) {
                    applicationName2 = applicationName2.substring(0, applicationName2.length() - versionNumber.length() - 1);
                }
                if (applicationName2.length() == 0) {
                    applicationName2 = "[ ROOT ]";
                }
                String versionID_WAR_old = "-version" + versionNumber;
                String versionID_EJB_old = "version" + versionNumber + "/";
                String versionID_WAR = "-" + versionNumber;
                String versionID_EJB = versionNumber + "/";
                if (!((String)entry.getKey()).endsWith(versionID_WAR) && !((String)entry.getKey()).endsWith(versionID_EJB) && !((String)entry.getKey()).endsWith(versionID_WAR_old) && !((String)entry.getKey()).endsWith(versionID_EJB_old)) continue;
                ApplicationInformation applicationInformation = (ApplicationInformation)applications.get(applicationName2);
                if (applicationInformation == null) {
                    applicationInformation = new ApplicationInformation();
                    applications.put(applicationName2, applicationInformation);
                }
                applicationInformation.versions.put(versionNumber, new VersionInformation((String)entry.getValue(), j2eeApplication));
                applicationInformation.managers.add((ObjectName)versionedEjbOrWar.getValue());
            }
        }
        for (ObjectName ear : ears) {
            applicationName = ear.getKeyProperty("name");
            if (applications.containsKey(applicationName)) {
                throw new IllegalStateException("The application \"" + applicationName + "\" seems not be versioned but has versioned WARs or EJBs!");
            }
            applications.put(applicationName, null);
            for (String module : (String[])this.mbscnx.getAttribute(ear, "modules")) {
                nonVersionedEjbsAndWars.remove(new ObjectName(module));
            }
        }
        for (ObjectName nonVersionedEjbOrWar : nonVersionedEjbsAndWars) {
            int nextSlash;
            applicationName = nonVersionedEjbOrWar.getKeyProperty("name");
            int n = applicationName.indexOf("//");
            if (n >= 0 && (nextSlash = applicationName.indexOf(47, n + 2)) >= 0) {
                applicationName = applicationName.substring(nextSlash + 1);
            }
            if (applicationName.length() == 0) {
                applicationName = "[ ROOT ]";
            }
            if (applications.containsKey(applicationName)) continue;
            applications.put(applicationName, null);
        }
        for (String deployedJar : deployedJars) {
            void var9_20;
            String deployedJarName = deployedJar.substring(deployedJar.lastIndexOf(47) + 1, deployedJar.length() - 4);
            Object var9_18 = null;
            String versionID = null;
            if (this.versioningService != null) {
                URL j2eeApplicationURL = new URL("file:" + deployedJar);
                Object[] opParams = new Object[]{j2eeApplicationURL};
                String[] opSignature = new String[]{URL.class.getName()};
                versionID = (String)this.mbscnx.invoke(this.versioningService, "getVersionID", opParams, opSignature);
            }
            if (versionID != null && deployedJarName.endsWith(versionID)) {
                deployedJarName = deployedJarName.substring(0, deployedJarName.length() - versionID.length());
                if (versionID.startsWith("-")) {
                    versionID = versionID.substring(1);
                }
                ApplicationInformation applicationInformation = new ApplicationInformation();
                applicationInformation.versions.put(versionID, new VersionInformation("Default", deployedJar));
            }
            applications.put(deployedJarName, (ApplicationInformation)var9_20);
        }
        return applications;
    }

    @Override
    public List<ApplicationBean> listOfApplications() throws Exception {
        ApplicationBean applicationBean;
        File applicationFile;
        this.checkJMXConnection();
        ArrayList<ApplicationBean> applications = new ArrayList<ApplicationBean>();
        for (Map.Entry<String, ApplicationInformation> application : this.getApplicationsList().entrySet()) {
            if (application.getValue() == null) {
                ApplicationBean applicationBean2 = new ApplicationBean(application.getKey());
                applicationBean2.setState("Deployed");
                applications.add(applicationBean2);
                continue;
            }
            for (Map.Entry<String, VersionInformation> versionInformation : application.getValue().versions.entrySet()) {
                ApplicationBean applicationBean3 = new ApplicationBean((String)application.getKey(), versionInformation.getKey());
                applicationBean3.setState("Deployed");
                applicationBean3.setPolicy(versionInformation.getValue().policy);
                if (versionInformation.getValue().path != null) {
                    applicationBean3.setFile(new File(versionInformation.getValue().path));
                }
                applications.add(applicationBean3);
            }
        }
        try {
            for (Map.Entry<String, ApplicationInformation> application : (List)this.mbscnx.getAttribute(this.j2eeServer, "deployableEars")) {
                applicationFile = new File((String)((Object)application));
                applicationBean = new ApplicationBean(applicationFile.getName());
                applicationBean.setState("Present");
                applicationBean.setFile(applicationFile);
                applications.add(applicationBean);
            }
        }
        catch (AttributeNotFoundException ignored) {
            // empty catch block
        }
        try {
            for (Map.Entry<String, ApplicationInformation> application : (List)this.mbscnx.getAttribute(this.j2eeServer, "deployableJars")) {
                applicationFile = new File((String)((Object)application));
                applicationBean = new ApplicationBean(applicationFile.getName());
                applicationBean.setState("Present");
                applicationBean.setFile(applicationFile);
                applications.add(applicationBean);
            }
        }
        catch (AttributeNotFoundException ignored) {
            // empty catch block
        }
        try {
            for (Map.Entry<String, ApplicationInformation> application : (List)this.mbscnx.getAttribute(this.j2eeServer, "deployableWars")) {
                applicationFile = new File((String)((Object)application));
                applicationBean = new ApplicationBean(applicationFile.getName());
                applicationBean.setState("Present");
                applicationBean.setFile(applicationFile);
                applications.add(applicationBean);
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        return applications;
    }

    @Override
    public String upload(ApplicationBean application) throws Exception {
        this.checkJMXConnection();
        Set<ObjectName> depmonitor = this.mbscnx.queryNames(new ObjectName("*:type=service,name=depmonitor"), null);
        if (!depmonitor.isEmpty()) {
            boolean developmentMode;
            ObjectName depmonitorService = depmonitor.iterator().next();
            try {
                developmentMode = (Boolean)this.mbscnx.getAttribute(depmonitorService, "developmentMode");
            }
            catch (AttributeNotFoundException e) {
                developmentMode = (Boolean)this.mbscnx.getAttribute(depmonitorService, "development");
            }
            if (developmentMode) {
                throw new IllegalStateException("The JOnAS Deployment Monitor service's Development Mode is active on the target server. JaDOrT requires it to be disabled.");
            }
        }
        this.appendToLog("Uploading ApplicationBean '" + application.toString() + "'");
        byte[] bytesOfFile = ServerAction.obtainByteData(application.getFile());
        Object[] opParams = new Object[]{bytesOfFile, application.getFile().getName(), false};
        String[] opSignature = new String[]{"[B", "java.lang.String", "boolean"};
        String sendFile = (String)this.mbscnx.invoke(this.j2eeServer, "sendFile", opParams, opSignature);
        if (!sendFile.startsWith("/")) {
            sendFile = "/" + sendFile;
        }
        URL url = new URL("file:" + sendFile);
        this.appendToLog("Call to J2EEServer.sendFile successful, ApplicationBean saved as '" + url.toString() + "'");
        String result = url.getFile();
        return result;
    }

    @Override
    public void deploy(String appName) throws Exception {
        Object ddp;
        String defaultDeploymentPolicy;
        this.checkJMXConnection();
        if (this.versioningService != null && !"Reserved".equalsIgnoreCase(defaultDeploymentPolicy = (ddp = this.mbscnx.getAttribute(this.versioningService, "DefaultDeploymentPolicy")).toString())) {
            throw new IllegalStateException("The versioning service's default deployment policy is currently \"" + defaultDeploymentPolicy + "\". JaDOrT requires it to be \"Reserved\".");
        }
        Object[] opParams = new Object[]{appName};
        String[] opSignature = new String[]{"java.lang.String"};
        this.appendToLog("Deploying application '" + appName + "'");
        this.mbscnx.invoke(this.j2eeServer, "deploy", opParams, opSignature);
        this.appendToLog("Call to J2EEServer.deploy successful for application '" + appName + "'");
    }

    @Override
    public String setDefault(String appName) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Setting application '" + appName + "' as default");
        if (this.versioningService == null) {
            throw new IllegalStateException("The versioning service is not enabled. Please enable it and redeploy all versioned applications before setting any version as default.");
        }
        String newDefaultVersion = null;
        String oldDefaultVersionPath = null;
        ApplicationInformation applicationInformation = null;
        block2: for (ApplicationInformation ai : this.getApplicationsList().values()) {
            if (ai == null) continue;
            for (Map.Entry<String, VersionInformation> vi : ai.versions.entrySet()) {
                String path;
                if (vi.getValue().mbean == null) continue;
                try {
                    path = this.getPath(vi.getValue().mbean);
                }
                catch (AttributeNotFoundException ignored) {
                    continue;
                }
                if (!path.endsWith(appName)) continue;
                applicationInformation = ai;
                newDefaultVersion = vi.getKey();
                break;
            }
            if (applicationInformation == null) continue;
            for (Map.Entry<String, VersionInformation> vi : ai.versions.entrySet()) {
                if (!"Default".equals(vi.getValue().policy)) continue;
                oldDefaultVersionPath = this.getPath(vi.getValue().mbean);
                break block2;
            }
        }
        if (applicationInformation == null) {
            this.appendToLog("   The application does not have any version manager");
            this.appendToLog("   It therefore will always stay as \"Default\"");
            return null;
        }
        this.setPolicy(applicationInformation.managers, newDefaultVersion, "Default");
        if (oldDefaultVersionPath != null) {
            this.appendToLog("   Old default was '" + oldDefaultVersionPath + "'");
        } else {
            this.appendToLog("   There was no old default version");
        }
        return oldDefaultVersionPath;
    }

    protected String getPath(ObjectName mbean) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        String path;
        String j2eeType = mbean.getKeyProperty("j2eeType");
        if ("J2EEApplication".equals(j2eeType)) {
            path = this.mbscnx.getAttribute(mbean, "earUrl").toString();
        } else if ("EJBModule".equals(j2eeType)) {
            path = this.mbscnx.getAttribute(mbean, "url").toString();
        } else if ("WebModule".equals(j2eeType)) {
            path = this.mbscnx.getAttribute(mbean, "warURL").toString();
        } else {
            throw new IllegalArgumentException("Unknown j2eeType: \"" + j2eeType + "\"");
        }
        if (path.startsWith("file:")) {
            return path.substring(5);
        }
        return path;
    }

    protected void setPolicy(Set<ObjectName> managers, String version, String policy) throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, IOException {
        this.appendToLog("   Setting version '" + version + "' as " + policy);
        String versionID_WAR_old = "-version" + version;
        String versionID_EJB_old = "version" + version + "/";
        String versionID_WAR = "-" + version;
        String versionID_EJB = version + "/";
        block0: for (ObjectName manager : managers) {
            for (String context : ((Map)this.mbscnx.getAttribute(manager, "Contexts")).keySet()) {
                if (!context.contains(versionID_WAR) && !context.contains(versionID_EJB) && !context.contains(versionID_WAR_old) && !context.contains(versionID_EJB_old)) continue;
                Object[] opParams = new Object[]{context, policy};
                String[] opSignature = new String[]{"java.lang.String", "java.lang.String"};
                this.mbscnx.invoke(manager, "rebindContext", opParams, opSignature);
                continue block0;
            }
        }
    }

    @Override
    public void undeploy(String appName) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Undeploying application '" + appName + "'");
        Object[] opParams = new Object[]{appName};
        String[] opSignature = new String[]{"java.lang.String"};
        this.mbscnx.invoke(this.j2eeServer, "undeploy", opParams, opSignature);
        this.appendToLog("Call to J2EEServer.undeploy successful for application '" + appName + "'");
    }

    @Override
    public void erase(String appName) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Erasing application '" + appName + "'");
        Object[] opParams = new Object[]{appName};
        String[] opSignature = new String[]{"java.lang.String"};
        this.mbscnx.invoke(this.j2eeServer, "removeModuleFile", opParams, opSignature);
        this.appendToLog("Call to J2EEServer.removeModuleFile successful for application '" + appName + "'");
    }

    @Override
    public ApplicationBean getApplicationBean(String appName) throws Exception {
        ApplicationBean applicationBean;
        this.checkJMXConnection();
        URL url = new URL("file:" + appName);
        for (Map.Entry<String, ApplicationInformation> application : this.getApplicationsList().entrySet()) {
            if (application.getValue() == null) continue;
            for (Map.Entry<String, VersionInformation> version : application.getValue().versions.entrySet()) {
                String path;
                try {
                    path = this.getPath(version.getValue().mbean);
                }
                catch (AttributeNotFoundException ignored) {
                    continue;
                }
                if (!url.equals(new URL("file:" + path))) continue;
                ApplicationBean applicationBean2 = new ApplicationBean();
                applicationBean2.setName((String)application.getKey());
                applicationBean2.setPolicy(version.getValue().policy);
                applicationBean2.setState("Deployed");
                applicationBean2.setVersion(version.getKey());
                this.appendToLog("ApplicationBean for application '" + appName + "' is a deployed versioned application, returning '" + applicationBean2.toString() + "'");
                return applicationBean2;
            }
        }
        for (Map.Entry<String, ApplicationInformation> application : (List)this.mbscnx.getAttribute(this.j2eeServer, "deployedEars")) {
            if (!url.equals(new URL("file:" + (String)((Object)application)))) continue;
            applicationBean = new ApplicationBean(new File((String)((Object)application)).getName());
            applicationBean.setState("Deployed");
            this.appendToLog("ApplicationBean for application '" + appName + "' is a deployed non-versioned application, returning '" + applicationBean.toString() + "'");
            return applicationBean;
        }
        for (Map.Entry<String, ApplicationInformation> application : (List)this.mbscnx.getAttribute(this.j2eeServer, "deployedJars")) {
            if (!url.equals(new URL("file:" + (String)((Object)application)))) continue;
            applicationBean = new ApplicationBean(new File((String)((Object)application)).getName());
            applicationBean.setState("Deployed");
            this.appendToLog("ApplicationBean for application '" + appName + "' is a deployed non-versioned application, returning '" + applicationBean.toString() + "'");
            return applicationBean;
        }
        for (Map.Entry<String, ApplicationInformation> application : (List)this.mbscnx.getAttribute(this.j2eeServer, "deployedWars")) {
            if (!url.equals(new URL("file:" + (String)((Object)application)))) continue;
            applicationBean = new ApplicationBean(new File((String)((Object)application)).getName());
            applicationBean.setState("Deployed");
            this.appendToLog("ApplicationBean for application '" + appName + "' is a deployed non-versioned application, returning '" + applicationBean.toString() + "'");
            return applicationBean;
        }
        for (Map.Entry<String, ApplicationInformation> application : (List)this.mbscnx.getAttribute(this.j2eeServer, "deployableEars")) {
            if (!url.equals(new URL("file:" + (String)((Object)application)))) continue;
            applicationBean = new ApplicationBean(new File((String)((Object)application)).getName());
            applicationBean.setState("Present");
            this.appendToLog("ApplicationBean for application '" + appName + "' is a present application, returning '" + applicationBean.toString() + "'");
            return applicationBean;
        }
        for (Map.Entry<String, ApplicationInformation> application : (List)this.mbscnx.getAttribute(this.j2eeServer, "deployableJars")) {
            if (!url.equals(new URL("file:" + (String)((Object)application)))) continue;
            applicationBean = new ApplicationBean(new File((String)((Object)application)).getName());
            applicationBean.setState("Present");
            this.appendToLog("ApplicationBean for application '" + appName + "' is a present application, returning '" + applicationBean.toString() + "'");
            return applicationBean;
        }
        for (Map.Entry<String, ApplicationInformation> application : (List)this.mbscnx.getAttribute(this.j2eeServer, "deployableWars")) {
            if (!url.equals(new URL("file:" + (String)((Object)application)))) continue;
            applicationBean = new ApplicationBean(new File((String)((Object)application)).getName());
            applicationBean.setState("Present");
            this.appendToLog("ApplicationBean for application '" + appName + "' is a present application, returning '" + applicationBean.toString() + "'");
            return applicationBean;
        }
        this.appendToLog("Application '" + appName + "' not found");
        return null;
    }

    @Override
    public int getActiveSessions(String appName) throws Exception {
        this.checkJMXConnection();
        ArrayList<String> names = new ArrayList<String>();
        URL url = new URL("file:" + appName);
        if (names.size() == 0) {
            for (ObjectName ear : this.mbscnx.queryNames(new ObjectName("*:j2eeType=J2EEApplication,*"), null)) {
                String[] modules;
                if (!url.equals(this.mbscnx.getAttribute(ear, "earUrl"))) continue;
                for (String module : modules = (String[])this.mbscnx.getAttribute(ear, "modules")) {
                    ObjectName moduleON = new ObjectName(module);
                    if (!"WebModule".equals(moduleON.getKeyProperty("j2eeType"))) continue;
                    names.add(moduleON.getKeyProperty("name"));
                }
            }
        }
        if (names.size() == 0) {
            for (ObjectName war : this.mbscnx.queryNames(new ObjectName("*:j2eeType=WebModule,*"), null)) {
                if (!url.equals(this.mbscnx.getAttribute(war, "warURL"))) continue;
                names.add(war.getKeyProperty("name"));
            }
        }
        if (names.size() == 0) {
            throw new IllegalArgumentException("No application for appName '" + appName + "'");
        }
        int totalActiveSessions = 0;
        for (String fullPath : names) {
            while (fullPath.startsWith("/")) {
                fullPath = fullPath.substring(1);
            }
            int slash = fullPath.indexOf(47);
            String host = fullPath.substring(0, slash);
            String path = fullPath.substring(slash);
            for (ObjectName manager : this.mbscnx.queryNames(new ObjectName("*:type=Manager,path=" + path + ",host=" + host), null)) {
                totalActiveSessions += ((Integer)this.mbscnx.getAttribute(manager, "activeSessions")).intValue();
            }
        }
        return totalActiveSessions;
    }

    @Override
    public int getActiveSessions() throws Exception {
        int totalActiveSessions = 0;
        if (this.mbscnx != null) {
            this.checkJMXConnection();
            for (ObjectName manager : this.mbscnx.queryNames(new ObjectName("*:type=Manager,*"), null)) {
                totalActiveSessions += ((Integer)this.mbscnx.getAttribute(manager, "activeSessions")).intValue();
            }
        }
        return totalActiveSessions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        ObjectName cdObjectName = null;
        JMXConnector managerConnector = null;
        MBeanServerConnection managerMbscnx = null;
        try {
            this.checkJMXConnection();
        }
        catch (IOException e) {
            if (this.managerConnector != null) {
                String url = this.managerConnector.getConnectorUrl();
                String username = this.managerConnector.getUsername();
                String password = this.managerConnector.getPassword();
                this.appendToLog("Connection to server's JMX server failed.");
                this.appendToLog("Trying the associated Cluster Daemon's JMX server on URL '" + url + "'");
                HashMap<String, Object> env = new HashMap<String, Object>();
                if (username != null && password != null) {
                    String[] creds = new String[]{username, password};
                    env.put("jmx.remote.credentials", creds);
                }
                MBeanServerConnection oldMbscnx = this.mbscnx;
                JMXConnector oldConnector = this.connector;
                try {
                    this.establishJMXConnection(new JMXServiceURL(url), env);
                    managerConnector = this.connector;
                    managerMbscnx = this.mbscnx;
                }
                finally {
                    this.connector = oldConnector;
                    this.mbscnx = oldMbscnx;
                }
                cdObjectName = managerMbscnx.queryNames(new ObjectName("*:type=ClusterDaemon,*"), null).iterator().next();
                this.appendToLog("JMX server connection OK for Cluster Daemon for server '" + this.name + "', ClusterDaemon is '" + cdObjectName + "'");
            }
            throw e;
        }
        this.appendToLog("Starting server");
        if (managerMbscnx == null || cdObjectName == null) {
            if (this.hasState) {
                String state = this.mbscnx.getAttribute(this.j2eeServer, "state").toString();
                if (state.contains("stopped") && state.contains("failed")) {
                    this.mbscnx.invoke(this.j2eeServer, "start", null, null);
                }
            } else {
                this.mbscnx.invoke(this.j2eeServer, "start", null, null);
            }
        } else {
            try {
                Object[] opParams = new Object[]{this.name, null, null};
                String[] opSignature = new String[]{String.class.getName(), String.class.getName(), String.class.getName()};
                managerMbscnx.invoke(cdObjectName, "startJOnAS", opParams, opSignature);
            }
            finally {
                managerConnector.close();
                managerConnector = null;
                managerMbscnx = null;
                System.gc();
            }
        }
        this.appendToLog("Server started");
    }

    @Override
    public void stop() throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Calling the stop method " + this.stopMethod + " on server");
        this.mbscnx.invoke(this.j2eeServer, this.stopMethod, null, null);
        this.appendToLog("Server stopped");
    }

    @Override
    public boolean isStarted() {
        try {
            this.checkJMXConnection();
            if (this.hasState) {
                String state = this.mbscnx.getAttribute(this.j2eeServer, "state").toString();
                return state.contains("running");
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean enableOrDisableApplications(boolean enable) throws Exception {
        this.checkJMXConnection();
        this.appendToLog("Enabling or disabling all applications on this server");
        boolean failed = false;
        for (ObjectName war : this.mbscnx.queryNames(new ObjectName("*:j2eeType=WebModule,*"), null)) {
            ObjectName filter;
            String warURL;
            Object warURLArgument;
            if (war.getKeyProperty("virtualContext") != null) continue;
            String path = (String)this.mbscnx.getAttribute(war, "path");
            if (path == null || path.length() < 1) {
                path = "/";
            }
            if ((warURLArgument = this.mbscnx.getAttribute(war, "warURL")) != null && ((warURL = warURLArgument.toString()).endsWith("/jonasAdmin.war") || warURL.endsWith("jonas-ctxroot.war") || warURL.endsWith("jonas-doc-en.war"))) {
                this.appendToLog("\tApplication on path '" + path + "' is a JOnAS-specific non-third-user application. Skipping...");
                continue;
            }
            try {
                filter = this.mbscnx.queryNames(new ObjectName("*:type=J2EEFilter,path=" + path), null).iterator().next();
            }
            catch (NoSuchElementException e) {
                this.appendToLog("\tApplication on path '" + path + "' doesn't have the OnlyAllowUsersWithSessionFilter filter! Please " + "import the filter JAR from the jadort-samples package and set it in the application's descriptor");
                failed = true;
                continue;
            }
            this.mbscnx.setAttribute(filter, new Attribute("active", !enable));
            this.appendToLog("\tFilter for application on path '" + path + "' has been set as " + (enable ? "in" : "") + "active, application is therefore " + (enable ? "enabled" : "disabled"));
        }
        if (failed) {
            this.appendToLog("At least one application on this server couldn't be " + (enable ? "enabled" : "disabled"));
            return false;
        }
        this.appendToLog("All applications on this server are now " + (enable ? "enabled" : "disabled"));
        return true;
    }

    protected class ApplicationInformation {
        public Map<String, VersionInformation> versions = new HashMap<String, VersionInformation>();
        public Set<ObjectName> managers = new HashSet<ObjectName>();
    }

    protected class VersionInformation {
        public String policy;
        public ObjectName mbean;
        public String path;

        public VersionInformation(String policy, ObjectName mbean) {
            this.policy = policy;
            this.mbean = mbean;
        }

        public VersionInformation(String policy, String path) {
            this.policy = policy;
            this.path = path;
        }
    }
}

