/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.abc;

import flash.util.FileUtils;
import flex2.compiler.CompilationUnit;
import flex2.compiler.Context;
import flex2.compiler.Source;
import flex2.compiler.SymbolTable;
import flex2.compiler.abc.Class;
import flex2.compiler.as3.Compiler;
import flex2.compiler.as3.Configuration;
import flex2.compiler.as3.Extension;
import flex2.compiler.as3.SyntaxTreeEvaluator;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.css.StyleConflictException;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MultiNameSet;
import flex2.compiler.util.QName;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.abc.AbcParser;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.avmplus.GlobalBuilder;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.semantics.ConstantEvaluator;
import macromedia.asc.semantics.FlowAnalyzer;
import macromedia.asc.semantics.FlowGraphEmitter;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.TypeValue;

public class Compiler
implements flex2.compiler.Compiler {
    static final String AttrTypeTable;
    private String[] mimeTypes = new String[]{"application/x-actionscript-bytecode"};
    private List compilerExtensions = new ArrayList();
    private Configuration configuration;

    public Compiler(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean isSupported(String mimeType) {
        return this.mimeTypes[0].equals(mimeType);
    }

    public String[] getSupportedMimeTypes() {
        return this.mimeTypes;
    }

    public void addCompilerExtension(Extension ext) {
        this.compilerExtensions.add(ext);
    }

    public Source preprocess(Source source) {
        return source;
    }

    public CompilationUnit parse1(Source source, SymbolTable symbolTable) {
        CompilationUnit unit = source.getCompilationUnit();
        if (unit != null && unit.hasTypeInfo) {
            Compiler.copyBytecodes(source, unit);
            return unit;
        }
        if (unit != null && unit.getSyntaxTree() != null) {
            return unit;
        }
        final String path = source.getName();
        ProgramNode node = null;
        Context context = new Context();
        macromedia.asc.util.Context cx = new macromedia.asc.util.Context(symbolTable.perCompileData);
        cx.setScriptName(source.getName());
        cx.setPath(source.getParent());
        cx.setEmitter(symbolTable.emitter);
        cx.setHandler(new Compiler.CompilerHandler(){

            public void error2(String filename, int ln, int col, Object msg, String source) {
                filename = filename == null || filename.length() == 0 ? path : filename;
                ThreadLocalToolkit.log((CompilerMessage)msg, filename);
            }

            public void warning2(String filename, int ln, int col, Object msg, String source) {
                filename = filename == null || filename.length() == 0 ? path : filename;
                ThreadLocalToolkit.log((CompilerMessage)msg, filename);
            }

            public void error(String filename, int ln, int col, String msg, String source, int errorCode) {
                String string = filename = filename == null || filename.length() == 0 ? path : filename;
                if (errorCode != -1) {
                    ThreadLocalToolkit.logError(filename, msg, errorCode);
                } else {
                    ThreadLocalToolkit.logError(filename, msg);
                }
            }

            public void warning(String filename, int ln, int col, String msg, String source, int errorCode) {
                String string = filename = filename == null || filename.length() == 0 ? path : filename;
                if (errorCode != -1) {
                    ThreadLocalToolkit.logWarning(filename, msg, errorCode);
                } else {
                    ThreadLocalToolkit.logWarning(filename, msg);
                }
            }

            public void error(String filename, int ln, int col, String msg, String source) {
                filename = filename == null || filename.length() == 0 ? path : filename;
                ThreadLocalToolkit.logError(filename, msg);
            }

            public void warning(String filename, int ln, int col, String msg, String source) {
                filename = filename == null || filename.length() == 0 ? path : filename;
                ThreadLocalToolkit.logWarning(filename, msg);
            }

            public CompilerHandler.FileInclude findFileInclude(String parentPath, String filespec) {
                return null;
            }
        });
        symbolTable.perCompileData.handler = cx.getHandler();
        context.setAttribute("cx", cx);
        byte[] abc = null;
        try {
            abc = source.toByteArray();
            if (abc == null) {
                abc = FileUtils.toByteArray((InputStream)source.getInputStream());
            }
            if (abc == null || abc.length == 0) {
                ThreadLocalToolkit.log((CompilerMessage)new NoBytecodeIsAvailable(), source);
            } else {
                AbcParser parser = new AbcParser(cx, abc);
                node = parser.parseAbc();
                if (node == null && ThreadLocalToolkit.errorCount() == 0) {
                    ThreadLocalToolkit.log((CompilerMessage)new BytecodeDecodingFailed(), source);
                }
                flex2.compiler.as3.Compiler.cleanNodeFactory(cx.getNodeFactory());
            }
        }
        catch (IOException ex) {
            ThreadLocalToolkit.logError(source.getNameForReporting(), ex.getLocalizedMessage());
        }
        if (ThreadLocalToolkit.errorCount() > 0) {
            return null;
        }
        unit.setSyntaxTree(node);
        unit.getContext().setAttributes(context);
        unit.bytes.set(abc, abc.length);
        SyntaxTreeEvaluator treeEvaluator = new SyntaxTreeEvaluator(unit);
        treeEvaluator.setLocalizationManager(ThreadLocalToolkit.getLocalizationManager());
        node.evaluate(cx, treeEvaluator);
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            ((Extension)this.compilerExtensions.get(i)).parse1(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return null;
        }
        return unit;
    }

    public void parse2(CompilationUnit unit, SymbolTable symbolTable) {
        if (unit.hasTypeInfo) {
            return;
        }
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            ((Extension)this.compilerExtensions.get(i)).parse2(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
    }

    public void analyze1(CompilationUnit unit, SymbolTable symbolTable) {
        if (unit.hasTypeInfo) {
            return;
        }
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        if (node.state != 1) {
            return;
        }
        Context context = unit.getContext();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)context.getAttribute("cx");
        symbolTable.perCompileData.handler = cx.getHandler();
        ObjectValue global = new ObjectValue(cx, new GlobalBuilder(), null);
        cx.pushScope(global);
        FlowGraphEmitter flowem = new FlowGraphEmitter(cx, unit.getSource().getName(), false);
        FlowAnalyzer flower = new FlowAnalyzer(flowem);
        context.setAttribute("FlowAnalyzer", flower);
        node.evaluate(cx, flower);
        cx.popScope();
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        unit.typeInfo = node.frame;
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            ((Extension)this.compilerExtensions.get(i)).analyze1(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
    }

    public void analyze2(CompilationUnit unit, SymbolTable symbolTable) {
        if (unit.hasTypeInfo) {
            return;
        }
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        if (node.state != 2) {
            return;
        }
        Context context = unit.getContext();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)context.getAttribute("cx");
        symbolTable.perCompileData.handler = cx.getHandler();
        FlowAnalyzer flower = (FlowAnalyzer)context.getAttribute("FlowAnalyzer");
        context.setAttribute("processed", new HashSet(15));
        this.inheritSlots(unit, unit.inheritance, symbolTable);
        this.inheritSlots(unit, unit.namespaces, symbolTable);
        cx.pushScope(node.frame);
        node.evaluate(cx, flower);
        cx.popScope();
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            ((Extension)this.compilerExtensions.get(i)).analyze2(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
    }

    public void analyze3(CompilationUnit unit, SymbolTable symbolTable) {
        if (unit.hasTypeInfo) {
            return;
        }
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        Context context = unit.getContext();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)context.getAttribute("cx");
        symbolTable.perCompileData.handler = cx.getHandler();
        this.inheritSlots(unit, unit.types, symbolTable);
        this.inheritSlots(unit, unit.namespaces, symbolTable);
        cx.pushScope(node.frame);
        ConstantEvaluator analyzer = new ConstantEvaluator(cx);
        analyzer.PreprocessDefinitionTypeInfo(cx, node);
        cx.popScope();
        context.setAttribute("ConstantEvaluator", analyzer);
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            ((Extension)this.compilerExtensions.get(i)).analyze3(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
    }

    public void analyze4(CompilationUnit unit, SymbolTable symbolTable) {
        TypeTable typeTable = null;
        if (symbolTable != null && (typeTable = (TypeTable)symbolTable.getContext().getAttribute(AttrTypeTable)) == null) {
            typeTable = new TypeTable(symbolTable);
            symbolTable.getContext().setAttribute(AttrTypeTable, typeTable);
        }
        if (unit.hasTypeInfo) {
            Map classMap = unit.classTable;
            Iterator i = classMap.keySet().iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                Class c = (Class)classMap.get(className);
                c.setTypeTable(typeTable);
                symbolTable.registerClass(className, c);
            }
            try {
                symbolTable.registerStyles(unit.styles);
            }
            catch (StyleConflictException e) {
                ThreadLocalToolkit.logError(unit.getSource().getNameForReporting(), e.getLocalizedMessage());
            }
            flex2.compiler.as3.Compiler.evaluateLoaderClassBase(unit, typeTable);
            return;
        }
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        Context context = unit.getContext();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)context.getAttribute("cx");
        symbolTable.perCompileData.handler = cx.getHandler();
        cx.pushScope(node.frame);
        ConstantEvaluator analyzer = (ConstantEvaluator)context.removeAttribute("ConstantEvaluator");
        node.evaluate(cx, analyzer);
        cx.popScope();
        if (ThreadLocalToolkit.errorCount() > 0) {
            return;
        }
        if (symbolTable != null) {
            Map classMap = typeTable.createClasses(node.clsdefs, unit.topLevelDefinitions);
            Iterator i = classMap.keySet().iterator();
            while (i.hasNext()) {
                String className = (String)i.next();
                Class c = (Class)classMap.get(className);
                symbolTable.registerClass(className, c);
                unit.classTable.put(className, c);
            }
            try {
                symbolTable.registerStyles(unit.styles);
            }
            catch (StyleConflictException e) {
                ThreadLocalToolkit.logError(unit.getSource().getNameForReporting(), e.getLocalizedMessage());
            }
            flex2.compiler.as3.Compiler.evaluateLoaderClassBase(unit, typeTable);
        }
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            ((Extension)this.compilerExtensions.get(i)).analyze4(unit, typeTable);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
    }

    public void generate(CompilationUnit unit, SymbolTable symbolTable) {
        if (unit.hasTypeInfo) {
            return;
        }
        int length = this.compilerExtensions.size();
        for (int i = 0; i < length; ++i) {
            ((Extension)this.compilerExtensions.get(i)).generate(unit, null);
            if (ThreadLocalToolkit.errorCount() <= 0) continue;
            return;
        }
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)unit.getContext().removeAttribute("cx");
        flex2.compiler.as3.Compiler.cleanSlots((ObjectValue)unit.typeInfo, cx, unit.topLevelDefinitions);
        cx.setHandler(null);
    }

    public void postprocess(CompilationUnit unit, SymbolTable symbolTable) {
    }

    private void inheritSlots(CompilationUnit unit, MultiNameSet types, SymbolTable symbolTable) {
        Context context = unit.getContext();
        ProgramNode node = (ProgramNode)unit.getSyntaxTree();
        macromedia.asc.util.Context cx = (macromedia.asc.util.Context)context.getAttribute("cx");
        FlowAnalyzer flower = (FlowAnalyzer)context.getAttribute("FlowAnalyzer");
        Set processed = (Set)context.getAttribute("processed");
        Iterator i = types.iterator();
        while (i.hasNext()) {
            ObjectValue frame;
            QName qName;
            Source s;
            CompilationUnit u;
            Object name = i.next();
            if (!(name instanceof QName) || unit == (u = (s = symbolTable.findSourceByQName(qName = (QName)name)).getCompilationUnit()) || (frame = (ObjectValue)u.typeInfo) == null || processed.contains(s.getName())) continue;
            flower.inheritContextSlots(frame, node.frame, node.frame.builder, cx);
            processed.add(s.getName());
        }
    }

    public static void copyBytecodes(Source source, CompilationUnit unit) {
        try {
            byte[] abc = source.toByteArray();
            if (abc == null) {
                abc = FileUtils.toByteArray((InputStream)source.getInputStream());
            }
            if (abc == null || abc.length == 0) {
                ThreadLocalToolkit.log((CompilerMessage)new NoBytecodeIsAvailable(), source);
            } else {
                unit.bytes.set(abc, abc.length);
            }
        }
        catch (IOException ex) {
            ThreadLocalToolkit.logError(source.getNameForReporting(), ex.getLocalizedMessage());
        }
    }

    static {
        TypeValue.init();
        ObjectValue.init();
        AttrTypeTable = TypeTable.class.getName();
    }

    public static class BytecodeDecodingFailed
    extends CompilerMessage.CompilerError {
    }

    public static class NoBytecodeIsAvailable
    extends CompilerMessage.CompilerError {
    }
}

