<%

/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008 Bull S.A.S.
 * Copyright (C) 2008 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: store.jsp 2207 2008-09-05 09:39:58Z alitokmen $
 * --------------------------------------------------------------------------
 */

%>
<%@page import="java.util.*"%>
<%

Map<String, Integer> products = (Map<String, Integer>) request.getAttribute("products");
Map<String, Integer> cartItems = (Map<String, Integer>) request.getAttribute("cartItems");
Integer cartValue = (Integer) request.getAttribute("cartValue");

%>
<html>
<head>
<title>MyStore</title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<style>
BODY {
	background:#000000;
	font-family:tahoma,arial,helvetica;
}

A {
	font-weight:bold;
}

input, textarea{
	font-family:tahoma,arial,helvetica;
	font-size:13;
	color:#000000;
}

DIV#copy {
	font-size:11;
	color:#FFFFFF;
	padding:15px 0px 10px 0px;
}

TABLE#main {
	width:960px;
	height:600px;
	border:1px solid #666666;
}

TD {
	font-size:13px;
}

TD#menu {
	background:#000000;
	color:#ffffff;
	padding:10px 10px 10px 10px;
}

TD#menu A {
	color:#AAAAAA;
	text-decoration:none;
}

TD#menu A:hover {
	color:#FFFFFF;
	text-decoration:underline;
}

TD#contenu {
	background:#ffffff;
	color:#111111;
	font-size:13px;
	line-height:20px;
	padding:15px 15px 15px 15px;
}

TD#contenu A {
	color:#666666;
	text-decoration:none;
}

TD#contenu A:hover {
	color:#000000;
	text-decoration:underline;
}

TR#pair {
	background:#e0e0e0;
}

IMG {
	border:0;
}
</style>
</head>
<body>
<div style="position:absolute;top:5;left:0;padding-bottom:15px;width:100%" align="center">
<table id="main" cellpadding="0" cellspacing="0">
<tr valign="top" height="1"><td id="menu">
	<div align="center">[[ advertisement ]]</div>
	<div align="right"><a href=./?page=cart>Your cart has <b><%= cartValue %> &euro;</b> of products</a></div>
</td></tr>
<tr valign="top"><td id="contenu">
<div align="center">
<%

if("cart".equals(request.getParameter("page"))) {

%>
<b>Here are the contents of your cart :</b><br/>
<table cellpadding=5 cellspacing=5><tr>
<%

	int i=0;
	for(Map.Entry<String, Integer> cartItem : cartItems.entrySet()) {
		out.println("<td width=200 align=center><img src=\"./images/" + cartItem.getKey() + ".jpg\"><br/>You bought <b>" + cartItem.getValue() + "</b><br/>" + (products.get(cartItem.getKey()) * cartItem.getValue()) + " &euro;<br/><br/><a href=\"./?removeItem=" + cartItem.getKey() + "&page=cart\">Remove one from your cart</a></td>");
		if(i>0 && ((i%3) == 0)) {
			out.println("</tr></table>\n<table cellpadding=5 cellspacing=5><tr>");
		}
		i++;
	}

%>
</tr></table><br/><br/>
<a href="./">Return to the shop</a>
<%

} else {

%>
<b>Click on any item to add it to your shopping cart :</b><br/>
<table cellpadding=5 cellspacing=5><tr>
<%

	int i=0;
	for(Map.Entry<String, Integer> product : products.entrySet()) {
		out.println("<td width=200 align=center><img src=\"./images/" + product.getKey() + ".jpg\"><br/><b>" + product.getKey() + "</b><br/>" + product.getValue() + " &euro;<br/><br/><a href=\"./?buyItem=" + product.getKey() + "\">Add to your cart</a></td>");
		if(i>0 && ((i%3) == 0)) {
			out.println("</tr></table>\n<table cellpadding=5 cellspacing=5><tr>");
		}
		i++;
	}

%>
</tr></table>
<%

}

%>
</div>
</td></tr>
</table>
</body>
</html>