/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ApplicationVO.as 3399 2009-04-14 13:08:32Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.vo {

    import com.adobe.cairngorm.vo.IValueObject;

    [RemoteClass(alias = "org.ow2.jasmine.jadort.api.entities.deployment.ApplicationBean")]
    [Bindable]
     public class ApplicationVO implements IValueObject {

        private var ApplicationName : String;
        private var ApplicationVersion : String;
        private var ApplicationState : String;
        private var ApplicationPolicy : String;

        public function ApplicationVO() {
            super();
        }

        public function get name() : String {
            return ApplicationName;
        }

        public function get version() : String {
            return ApplicationVersion;
        }

        public function get state() : String {
            return ApplicationState;
        }

        public function get policy() : String {
            return ApplicationPolicy;
        }

        public function set name(ApplicationName : String) : void {
            this.ApplicationName = ApplicationName;
        }

        public function set version(ApplicationVersion : String) : void {
            this.ApplicationVersion = ApplicationVersion;
        }

        public function set state(ApplicationState : String) : void {
            this.ApplicationState = ApplicationState;
        }

        public function set policy(ApplicationPolicy : String) : void {
            this.ApplicationPolicy = ApplicationPolicy;
        }

        public function toString() : String {
            if (version != null && version != "")
                return name + " (version " + version + ")";
            else
                return name;
        }
    }

}