/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.rep;

import flex2.compiler.as3.binding.Watcher;
import flex2.compiler.mxml.lang.StandardDefs;
import flex2.compiler.mxml.reflect.Property;
import flex2.compiler.mxml.reflect.Style;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.rep.AnonymousObjectGraph;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.mxml.rep.XML;
import flex2.compiler.util.IntegerPool;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class BindingExpression {
    private String sourceExpression;
    private Model destination;
    private String destinationProperty;
    private String destinationStyle;
    private boolean arrayAccess = false;
    private String destinationLValue;
    private int id;
    private boolean isDestinationXMLAttribute;
    private boolean isDestinationXMLNode;
    private boolean isDestinationE4X;
    private boolean isDestinationObjectProxy;
    public int xmlLineNumber;
    private Watcher uiComponentWatcher;
    private boolean multipleUIComponentWatchers;
    private MxmlDocument mxmlDocument;
    private BindingExpression twoWayCounterpart;
    private Map namespaces;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BindingExpression(String bindingExpression, int xmlLineNumber, MxmlDocument mxmlDocument) {
        this.sourceExpression = bindingExpression;
        this.xmlLineNumber = xmlLineNumber;
        if (!$assertionsDisabled && mxmlDocument == null) {
            throw new AssertionError();
        }
        this.setMxmlDocument(mxmlDocument);
        this.multipleUIComponentWatchers = false;
    }

    public void setMxmlDocument(MxmlDocument mxmlDocument) {
        this.mxmlDocument = mxmlDocument;
        mxmlDocument.addBindingExpression(this);
    }

    public boolean isDestinationXMLAttribute() {
        return this.isDestinationXMLAttribute;
    }

    public boolean isDestinationXMLNode() {
        return this.isDestinationXMLNode;
    }

    public boolean isDestinationE4X() {
        return this.isDestinationE4X;
    }

    public boolean isDestinationObjectProxy() {
        return this.isDestinationObjectProxy;
    }

    private Stack generateDestinationStack() {
        Stack<Model> destinationStack = new Stack<Model>();
        for (Model model = this.destination; model != null; model = model.getParent()) {
            destinationStack.push(model);
            if (model.getId() != null && !model.getIsAnonymous()) break;
        }
        return destinationStack;
    }

    public String getDestinationPath(boolean doXML) {
        StringBuffer buffer = new StringBuffer();
        if (!doXML || !this.isDestinationXMLAttribute && !this.isDestinationXMLNode) {
            buffer.append(this.getDestinationPathRoot(false));
        }
        if (!(this.destination == null || this.destinationProperty == null && this.destinationStyle == null || this.isArrayAccess() || doXML && (this.isDestinationXMLAttribute || this.isDestinationXMLNode))) {
            buffer.append(".");
        }
        if (this.isArrayAccess()) {
            buffer.append("[");
        }
        if ((doXML || !this.isDestinationXMLAttribute && !this.isDestinationXMLNode) && this.destinationLValue != null) {
            buffer.append(this.destinationLValue);
        } else if (this.destinationProperty != null) {
            buffer.append(this.destinationProperty);
        } else if (this.destinationStyle != null) {
            buffer.append(this.destinationStyle);
        }
        if (doXML && this.isDestinationXMLNode && !this.isDestinationE4X) {
            buffer.append(".nodeValue");
        } else if (this.isArrayAccess()) {
            buffer.append("]");
        }
        return buffer.toString();
    }

    public String getDestinationPathRoot(boolean doRepeatable) {
        if (this.destination == null) {
            return "";
        }
        StringBuffer destinationRoot = new StringBuffer();
        Stack destinationStack = this.generateDestinationStack();
        Model model = (Model)destinationStack.peek();
        if (!(model instanceof XML || model instanceof AnonymousObjectGraph || model.equals(this.mxmlDocument.getRoot()) || model.getId() == null)) {
            this.mxmlDocument.ensureDeclaration(model);
        }
        boolean writeRepeaterIndices = doRepeatable;
        while (!destinationStack.isEmpty()) {
            Model child;
            model = (Model)destinationStack.pop();
            if (model.equals(this.mxmlDocument.getRoot())) {
                destinationRoot.append("this");
            } else {
                String parentIndex = model.getParentIndex();
                if (parentIndex != null && destinationRoot.length() > 0) {
                    destinationRoot.append("[");
                    destinationRoot.append(parentIndex);
                    destinationRoot.append("]");
                } else {
                    String id = model.getId();
                    if (id != null) {
                        if (!model.getIsAnonymous()) {
                            this.mxmlDocument.ensureDeclaration(model);
                        }
                        destinationRoot.append(id);
                    }
                }
            }
            if (writeRepeaterIndices && this.isRepeatable()) {
                for (int i = 0; i < model.getRepeaterLevel(); ++i) {
                    destinationRoot.append("[instanceIndices[");
                    destinationRoot.append(i);
                    destinationRoot.append("]]");
                }
                writeRepeaterIndices = false;
            }
            if (destinationStack.isEmpty() || (child = (Model)destinationStack.peek()).getParentIndex() != null) continue;
            destinationRoot.append(".");
        }
        return destinationRoot.toString();
    }

    public String getDestinationTypeName() {
        String result = "*";
        if (this.destination != null && !(this.destination instanceof AnonymousObjectGraph) && !(this.destination instanceof XML)) {
            if (this.destinationProperty != null) {
                Property property;
                Type type = this.destination.getType();
                if (!type.getName().equals(StandardDefs.CLASS_OBJECTPROXY) && (property = type.getProperty(this.destinationProperty)) != null) {
                    result = property.getType().getName();
                    result = result.replace(':', '.');
                }
            } else if (this.destinationStyle != null) {
                Type type = this.destination.getType();
                Style style = type.getStyle(this.destinationStyle);
                if (style != null) {
                    result = style.getType().getName();
                    result = result.replace(':', '.');
                }
            } else {
                result = this.destination.getType().getName();
            }
        }
        return result;
    }

    public int getId() {
        return this.id;
    }

    public String getRepeatableSourceExpression() {
        String repeatableSourceExpression = this.sourceExpression;
        List repeaterParents = this.destination.getRepeaterParents();
        Iterator iterator = repeaterParents.iterator();
        while (iterator.hasNext()) {
            int i;
            Model repeater = (Model)iterator.next();
            int repeaterLevel = repeater.getRepeaterLevel();
            StringBuffer buffer = new StringBuffer();
            for (i = 0; i < repeaterLevel; ++i) {
                buffer.append("[instanceIndices[");
                buffer.append(i);
                buffer.append("]]");
            }
            buffer.append(".mx_internal::getItemAt(repeaterIndices[");
            buffer.append(i);
            buffer.append("])");
            repeatableSourceExpression = repeatableSourceExpression.replaceAll(repeater.getId() + "\\.currentItem", repeater.getId() + buffer.toString());
            repeatableSourceExpression = repeatableSourceExpression.replaceAll(repeater.getId() + "\\.currentIndex", "repeaterIndices[" + i + "]");
        }
        return repeatableSourceExpression;
    }

    public String getSourceExpression() {
        return this.sourceExpression;
    }

    public void setDestinationProperty(String destinationProperty) {
        this.destinationProperty = destinationProperty;
    }

    public void setDestinationProperty(int destinationProperty) {
        this.destinationProperty = Integer.toString(destinationProperty);
        this.arrayAccess = true;
    }

    public void setDestinationStyle(String destinationStyle) {
        this.destinationStyle = destinationStyle;
    }

    public String getDestinationStyle() {
        return this.destinationStyle;
    }

    public boolean isStyle() {
        return this.destinationStyle != null;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setDestinationXMLAttribute(boolean isDestinationXMLAttribute) {
        this.isDestinationXMLAttribute = isDestinationXMLAttribute;
    }

    public void setDestinationXMLNode(boolean isDestinationXMLNode) {
        this.isDestinationXMLNode = isDestinationXMLNode;
    }

    public void setDestinationE4X(boolean isDestinationE4X) {
        this.isDestinationE4X = isDestinationE4X;
    }

    public void setDestinationObjectProxy(boolean isDestinationObjectProxy) {
        this.isDestinationObjectProxy = isDestinationObjectProxy;
    }

    public String getDestinationProperty() {
        return this.destinationProperty;
    }

    public boolean isArrayAccess() {
        return this.arrayAccess;
    }

    public String getDestinationLValue() {
        return this.destinationLValue;
    }

    public void setDestinationLValue(String lvalue) {
        this.destinationLValue = lvalue;
    }

    public Model getDestination() {
        return this.destination;
    }

    public void setDestination(Model destination) {
        this.destination = destination;
        if (this.xmlLineNumber == 0) {
            this.xmlLineNumber = destination.getXmlLineNumber();
        }
    }

    public boolean isRepeatable() {
        return this.destination != null && this.destination.getRepeaterLevel() > 0;
    }

    public int getRepeaterLevel(String var) {
        Model r;
        int repeaterLevel;
        if (var.indexOf("[repeaterIndices") > -1) {
            var = var.substring(0, var.indexOf("["));
        }
        List repeaters = this.destination.getRepeaterParents();
        for (repeaterLevel = repeaters.size() - 1; repeaterLevel >= 0 && !var.equals((r = (Model)repeaters.get(repeaterLevel)).getId()); --repeaterLevel) {
        }
        return repeaterLevel;
    }

    public BindingExpression getTwoWayCounterpart() {
        return this.twoWayCounterpart;
    }

    public void setTwoWayCounterpart(BindingExpression twoWayCounterpart) {
        this.twoWayCounterpart = twoWayCounterpart;
    }

    public int getXmlLineNumber() {
        return this.xmlLineNumber;
    }

    public void addNamespace(String nsUri, int i) {
        if (this.namespaces == null) {
            this.namespaces = new HashMap();
        }
        this.namespaces.put(nsUri, IntegerPool.getNumber(i));
    }

    public String getNamespaceDeclarations() {
        if (this.namespaces != null) {
            StringBuffer b = new StringBuffer();
            Iterator i = this.namespaces.keySet().iterator();
            while (i.hasNext()) {
                String uri = (String)i.next();
                int k = (Integer)this.namespaces.get(uri);
                b.append("var ns").append(k).append(":Namespace = new Namespace(\"").append(uri).append("\");");
            }
            return b.toString();
        }
        return "";
    }

    static {
        $assertionsDisabled = !BindingExpression.class.desiredAssertionStatus();
    }
}

