/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.parser;

import macromedia.asc.parser.AttributeListNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.IdentifierNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.semantics.QName;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;

public class NamespaceDefinitionNode
extends DefinitionNode {
    public IdentifierNode name;
    public Node value;
    public ReferenceValue ref;
    public String debug_name;
    public QName qualifiedname;
    public boolean needs_init;
    public BitSet gen_bits;

    public NamespaceDefinitionNode(PackageDefinitionNode packageDefinitionNode, AttributeListNode attributeListNode, IdentifierNode identifierNode, Node node) {
        super(packageDefinitionNode, attributeListNode, -1);
        this.name = identifierNode;
        this.value = node;
        this.ref = null;
        this.qualifiedname = null;
        this.gen_bits = null;
        this.needs_init = false;
    }

    public Value evaluate(Context context, Evaluator evaluator) {
        if (evaluator.checkFeature(context, this)) {
            return evaluator.evaluate(context, this);
        }
        return null;
    }

    public boolean isConst() {
        return true;
    }

    public ReferenceValue getRef(Context context) {
        return this.ref;
    }

    public Node initializerStatement(Context context) {
        this.needs_init = true;
        return this;
    }

    public BitSet getGenBits() {
        return this.gen_bits;
    }

    public BitSet getKillBits() {
        if (this.ref != null && this.ref.slot != null) {
            if (this.ref.slot.getDefBits() != null) {
                return BitSet.xor(this.ref.slot.getDefBits(), this.gen_bits);
            }
            return this.gen_bits;
        }
        return null;
    }

    public String toString() {
        return "NamespaceDefinition";
    }
}

