/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.granite.config.GraniteConfig;
import org.granite.config.ShutdownListener;
import org.granite.config.flex.ServicesConfig;
import org.granite.logging.Logger;

public class GraniteConfigListener
implements ServletContextListener {
    private static final String GRANITE_CONFIG_SHUTDOWN_KEY = String.valueOf(GraniteConfig.class.getName()) + "_SHUTDOWN";
    private static final Logger log = Logger.getLogger(GraniteConfigListener.class);

    public void contextInitialized(ServletContextEvent sce) {
        try {
            ServletContext context = sce.getServletContext();
            GraniteConfig.loadConfig(context);
            ServicesConfig.loadConfig(context);
            log.info("GraniteDS initialized", new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not initialize Granite environment", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        List listeners = (List)sce.getServletContext().getAttribute(GRANITE_CONFIG_SHUTDOWN_KEY);
        if (listeners != null) {
            try {
                for (ShutdownListener listener : listeners) {
                    listener.stop();
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Could not destroy Granite environment", e);
            }
        }
        log.info("GraniteDS stopped", new Object[0]);
    }

    public static synchronized void registerShutdownListener(ServletContext context, ShutdownListener listener) {
        ArrayList<ShutdownListener> listeners = (ArrayList<ShutdownListener>)context.getAttribute(GRANITE_CONFIG_SHUTDOWN_KEY);
        if (listeners == null) {
            listeners = new ArrayList<ShutdownListener>();
            context.setAttribute(GRANITE_CONFIG_SHUTDOWN_KEY, listeners);
        }
        listeners.add(listener);
    }
}

