/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util;

import flex.messaging.messages.Message;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import org.granite.config.flex.Destination;
import org.granite.messaging.amf.io.util.Converter;
import org.granite.messaging.service.ServiceInvocationContext;
import org.granite.util.ClassUtil;
import org.granite.util.CollectionUtil;
import org.granite.util.NumberUtil;
import org.granite.util.PrimitiveUtil;
import org.granite.util.StringUtil;

public class DefaultConverter
implements Converter {
    public Object convertForSerialization(Object value) {
        return value;
    }

    public Object convertForDeserialization(Object value, Type targetType) {
        Class<?> targetClass = ClassUtil.classOfType(targetType);
        if (value == null) {
            value = PrimitiveUtil.convertNull(targetClass);
        } else if (CollectionUtil.isCollectionType(targetClass)) {
            value = CollectionUtil.convert(targetType, value);
        } else if (value instanceof Number) {
            value = NumberUtil.convert(targetClass, value);
        } else if (!targetClass.isAssignableFrom(value.getClass())) {
            if (targetClass == Character.class && value.getClass() == String.class && ((String)value).length() == 1) {
                value = Character.valueOf(((String)value).charAt(0));
            } else if (value instanceof java.util.Date) {
                java.util.Date date = (java.util.Date)value;
                if (targetClass.isAssignableFrom(Calendar.class)) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(date);
                    value = cal;
                } else if (targetClass.isAssignableFrom(Timestamp.class)) {
                    value = new Timestamp(date.getTime());
                } else if (targetClass.isAssignableFrom(Date.class)) {
                    value = new Date(date.getTime());
                } else if (targetClass.isAssignableFrom(Time.class)) {
                    value = new Time(date.getTime());
                }
            }
        }
        return value;
    }

    protected Object[] convertForDeserialization(Object[] values, Type[] targetTypes) {
        if (values == null) {
            return values;
        }
        Object[] convertedArgs = new Object[values.length];
        int i = 0;
        while (i < convertedArgs.length) {
            convertedArgs[i] = this.convertForDeserialization(values[i], targetTypes[i]);
            ++i;
        }
        return convertedArgs;
    }

    public ServiceInvocationContext findServiceMethod(Message message, Destination destination, Object service, String methodName, Object[] params) throws NoSuchMethodException {
        Class<?> serviceClass = service.getClass();
        Method serviceMethod = null;
        if (params == null || params.length == 0) {
            serviceMethod = serviceClass.getMethod(methodName, null);
        } else {
            Method[] methodArray = serviceClass.getMethods();
            int n = methodArray.length;
            int n2 = 0;
            while (n2 < n) {
                Type[] paramTypes;
                Method method = methodArray[n2];
                if (methodName.equals(method.getName()) && (paramTypes = method.getGenericParameterTypes()).length == params.length && this.canConvertForMethodInvocation(params, paramTypes)) {
                    serviceMethod = method;
                    break;
                }
                ++n2;
            }
        }
        if (serviceMethod == null) {
            throw new NoSuchMethodException(String.valueOf(serviceClass.getName()) + '.' + methodName + StringUtil.toString(params));
        }
        params = this.convertForDeserialization(params, serviceMethod.getGenericParameterTypes());
        return new ServiceInvocationContext(message, destination, service, serviceMethod, params);
    }

    protected boolean canConvertForMethodInvocation(Object value, Type targetType) {
        if (value == null) {
            return true;
        }
        Class<?> valueClass = value.getClass();
        if (valueClass == targetType) {
            return true;
        }
        Class<?> targetClass = ClassUtil.classOfType(targetType);
        if (targetClass.isAssignableFrom(valueClass)) {
            return true;
        }
        if (targetClass.isPrimitive()) {
            if (valueClass == Integer.class && (targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Boolean.class && targetClass == Boolean.TYPE || valueClass == Long.class && (targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Float.class && (targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Byte.class && (targetClass == Byte.TYPE || targetClass == Short.TYPE || targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Short.class && (targetClass == Short.TYPE || targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE) || valueClass == Character.class && (targetClass == Character.TYPE || targetClass == Integer.TYPE || targetClass == Long.TYPE || targetClass == Float.TYPE || targetClass == Double.TYPE)) {
                return true;
            }
        } else if (Number.class.isAssignableFrom(targetClass)) {
            if (valueClass == Integer.class && (targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Long.class && (targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Float.class && (targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Byte.class && (targetClass == Short.class || targetClass == Integer.class || targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Short.class && (targetClass == Integer.class || targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class) || valueClass == Character.class && (targetClass == Integer.class || targetClass == Long.class || targetClass == Float.class || targetClass == Double.class || targetClass == BigDecimal.class || targetClass == BigInteger.class)) {
                return true;
            }
        } else if (valueClass.isArray() && List.class.isAssignableFrom(targetClass)) {
            Class<?> lct;
            Type[] lcts;
            if (targetType instanceof Class) {
                return true;
            }
            if (targetType instanceof ParameterizedType && (lcts = ((ParameterizedType)targetType).getActualTypeArguments()).length == 1 && (lct = ClassUtil.classOfType(lcts[0])).isAssignableFrom(valueClass.getComponentType())) {
                return true;
            }
        }
        return false;
    }

    protected boolean canConvertForMethodInvocation(Object[] values, Type[] targetTypes) {
        boolean canConvert = true;
        int i = 0;
        while (i < targetTypes.length && canConvert) {
            canConvert = this.canConvertForMethodInvocation(values[i], targetTypes[i]);
            ++i;
        }
        return canConvert;
    }
}

