/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.webapp;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.granite.logging.Logger;
import org.granite.util.JDOMUtil;
import org.granite.util.StreamGobbler;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MXMLCompilerServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MXMLCompilerServlet.class);
    private ServletConfig config = null;
    private File compilerHome = null;
    private Map<String, String> compilerOptions = null;

    public void init(ServletConfig config) throws ServletException {
        this.config = config;
        String compilerHomePath = config.getInitParameter("compilerHome");
        if (compilerHomePath == null) {
            log.error("Init parameter 'compilerHome' is missing (web.xml)", new Object[0]);
            throw new ServletException("Init parameter 'compilerHome' is missing (web.xml)");
        }
        this.compilerHome = new File(compilerHomePath);
        if (!this.compilerHome.exists() || !this.compilerHome.isDirectory()) {
            log.error("Invalid 'compilerHome' parameter in (web.xml): %s", this.compilerHome);
            throw new ServletException("Invalid 'compilerHome' parameter in (web.xml): " + this.compilerHome);
        }
        this.compilerOptions = new HashMap<String, String>();
        String compilerOptionsFile = config.getServletContext().getRealPath("/" + config.getInitParameter("compilerOptions"));
        if (compilerOptionsFile == null) {
            log.warn("Init parameter 'compilerClassName' is missing (web.xml). Using default.", new Object[0]);
        } else {
            String[] ignoredOptions;
            Properties props = new Properties();
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(compilerOptionsFile);
                    props.load(is);
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        this.compilerOptions.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                catch (Exception e) {
                    throw new ServletException("Could not load compiler options from file: " + compilerOptionsFile, (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception e) {
                        log.warn(e, "Could not close input stream: %s", compilerOptionsFile);
                    }
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception e) {
                    log.warn(e, "Could not close input stream: %s", compilerOptionsFile);
                }
            }
            String[] stringArray = ignoredOptions = new String[]{"-file-specs", "-o", "-output", "-context-root", "-compiler.context-root"};
            int n = ignoredOptions.length;
            int n2 = 0;
            while (n2 < n) {
                String ignoredOption = stringArray[n2];
                if (this.compilerOptions.containsKey(ignoredOption)) {
                    log.warn("Ignoring %s option in: %s", ignoredOption, compilerOptionsFile);
                    this.compilerOptions.remove(ignoredOption);
                }
                ++n2;
            }
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean compile;
        File mxml = new File(this.config.getServletContext().getRealPath(request.getRequestURI().substring(request.getContextPath().length())));
        String mxmlPath = mxml.getCanonicalPath();
        if (!mxml.exists() || !mxml.isFile()) {
            throw new ServletException("Invalid MXML file: " + mxmlPath);
        }
        File swf = new File(String.valueOf(mxmlPath.substring(0, mxmlPath.length() - 4)) + "swf");
        boolean bl = compile = !swf.exists() || swf.lastModified() < mxml.lastModified();
        if (!compile) {
            for (File dependency : this.findDependencies(this.config.getServletContext().getRealPath("/"), mxml)) {
                if (mxml.equals(dependency) || swf.lastModified() >= dependency.lastModified()) continue;
                compile = true;
                break;
            }
        }
        if (compile) {
            String FS = System.getProperty("file.separator");
            ArrayList<String> command = new ArrayList<String>();
            command.add("java");
            command.add("-Dapplication.home=" + this.compilerHome.getAbsolutePath());
            command.add("-Xmx384M");
            command.add("-jar");
            command.add(String.valueOf(this.compilerHome.getAbsolutePath()) + FS + "lib" + FS + "mxmlc.jar");
            for (Map.Entry<String, String> entry : this.compilerOptions.entrySet()) {
                command.add(entry.getKey());
                command.add(entry.getValue());
            }
            command.add("-file-specs");
            command.add(mxmlPath);
            command.add("-context-root");
            command.add(request.getContextPath());
            command.add("-output");
            command.add(swf.getCanonicalPath());
            log.info("Executing: %s", command);
            int status = 0;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(command);
                processBuilder.directory(new File(this.config.getServletContext().getRealPath("/")));
                processBuilder.redirectErrorStream(true);
                Process process = processBuilder.start();
                StreamGobbler gobbler = new StreamGobbler(new BufferedInputStream(process.getInputStream()), baos);
                gobbler.start();
                status = process.waitFor();
            }
            catch (Exception e) {
                log.error(e, "Could not call flex compiler: %s", command);
                throw new ServletException("Could not call flex compiler: " + command, (Throwable)e);
            }
            log.info(baos.toString(), new Object[0]);
            if (status != 0) {
                throw new ServletException("Error while compiling " + mxmlPath + ": " + baos.toString());
            }
            swf = new File(swf.getCanonicalPath());
        }
        response.setContentType("application/x-shockwave-flash");
        response.setContentLength((int)swf.length());
        response.setBufferSize((int)swf.length());
        response.setDateHeader("Expires", 0L);
        ServletOutputStream os = null;
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(swf));
            os = response.getOutputStream();
            int b = is.read();
            while (b != -1) {
                os.write(b);
                b = is.read();
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
        }
    }

    private Set<File> findDependencies(String contextPath, File compileUnit) {
        HashSet<File> dependencies = new HashSet<File>();
        try {
            this.findDependencies(contextPath, dependencies, compileUnit);
        }
        catch (Exception e) {
            log.warn(e, "Could not find dependencies for: %s", compileUnit);
        }
        return dependencies;
    }

    private void findDependencies(String contextPath, Set<File> dependencies, File compileUnit) throws IOException, JDOMException {
        dependencies.add(compileUnit);
        String path = compileUnit.getCanonicalPath();
        if (path.endsWith(".mxml")) {
            Document doc = JDOMUtil.readDocument(path);
            Iterator<Element> descendants = JDOMUtil.getDescendantElements(doc.getRootElement());
            while (descendants.hasNext()) {
                Element descendant = descendants.next();
                Namespace ns = descendant.getNamespace();
                if ("http://www.adobe.com/2006/mxml".equals(ns.getURI()) && "Script".equals(descendant.getName()) || ns.getURI().startsWith("http://") || !ns.getURI().endsWith("*")) continue;
                String dPath = String.valueOf(ns.getURI().substring(0, ns.getURI().length() - 1).replace('.', '/')) + descendant.getName();
                File dFile = new File(String.valueOf(contextPath) + dPath + ".mxml");
                if (!dFile.exists() || !dFile.isFile()) {
                    dFile = new File(String.valueOf(contextPath) + dPath + ".as");
                }
                if (!dFile.exists() || !dFile.isFile() || dependencies.contains(dFile)) continue;
                this.findDependencies(contextPath, dependencies, dFile);
            }
        } else {
            path.endsWith(".as");
        }
    }

    public void destroy() {
        this.config = null;
        this.compilerHome = null;
        this.compilerOptions = null;
    }
}

