/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDOMUtil {
    public static Document readDocument(String path) throws IOException, JDOMException {
        return JDOMUtil.readDocument(path, null);
    }

    public static Document readDocument(String path, EntityResolver resolver) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(true);
        if (resolver != null) {
            builder.setValidation(true);
            builder.setEntityResolver(resolver);
        }
        return builder.build(new File(path).toURI().toURL());
    }

    public static Document readDocument(InputStream in) throws IOException, JDOMException {
        return JDOMUtil.readDocument(in, null);
    }

    public static Document readDocument(InputStream in, EntityResolver resolver) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder();
        builder.setExpandEntities(true);
        if (resolver != null) {
            builder.setValidation(true);
            builder.setEntityResolver(resolver);
        }
        return builder.build(in);
    }

    public static List<Element> getChildren(Element element) {
        return element.getChildren();
    }

    public static List<Element> getChildren(Element element, String name) {
        return element.getChildren(name);
    }

    public static Iterator<Element> getDescendantElements(Element element) {
        return element.getDescendants((Filter)new ElementFilter());
    }

    public static void checkElement(Element element, String name, String ... attrs) {
        if (!element.getName().equals(name)) {
            throw new RuntimeException("Expected a '" + name + "' element");
        }
        if (attrs != null) {
            String[] stringArray = attrs;
            int n = attrs.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                if (element.getAttribute(attr) == null) {
                    throw new RuntimeException("Element '" + name + "' has no attribute '" + attr + "':\n" + JDOMUtil.toString(element));
                }
                ++n2;
            }
        }
    }

    public static String toString(Element element) {
        return new XMLOutputter(Format.getPrettyFormat()).outputString(element);
    }
}

