/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: JadortServiceException.java 3601 2009-04-30 13:58:52Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.api;

import org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean.Step;

/**
 * This class defines exceptions that are thrown by the JaDOrT service's
 * business methods. All other exceptions that are thrown are from the EJB
 * container or due to internal programming errors.
 * 
 * @author Malek Chahine
 * @author Remy Bresson
 * @author S. Ali Tokmen
 */
public class JadortServiceException extends Exception {

    /**
     * Auto-generated serial version ID.
     */
    private static final long serialVersionUID = -6071831412965984513L;

    private static String buildError(final Step currentStep, final Step... expectedSteps) {
        StringBuilder sb = new StringBuilder("That method should only be called when step is ");
        for (int i = 0; i < expectedSteps.length; i++) {
            if (i == expectedSteps.length - 1) {
                sb.append(" or ");
            } else if (i != 0) {
                sb.append(", ");
            }
            sb.append(expectedSteps[i]);
        }
        sb.append(". Currently, step is " + currentStep + ".");

        return sb.toString();
    }

    /**
     * Generic JaDOrT service exception.
     * 
     * @param message Exception message.
     * @param cause Exception's cause.
     */
    public JadortServiceException(final String message, final Exception cause) {
        super(message, cause);
    }

    /**
     * Exception thrown when the current operation is not in the expected step.
     * 
     * @param currentStep The current step.
     * @param expectedSteps The steps that are allowed.
     */
    public JadortServiceException(final Step currentStep, final Step... expectedSteps) {
        super(JadortServiceException.buildError(currentStep, expectedSteps));
    }

}
