/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: GetCurrentOperationCommand.as 3591 2009-04-28 08:33:26Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.command {

    import com.adobe.cairngorm.commands.*;
    import com.adobe.cairngorm.control.*;
    import mx.managers.CursorManager;
    import mx.rpc.IResponder;
    import mx.rpc.events.FaultEvent;
    import mx.rpc.events.ResultEvent;
    import org.ow2.jasmine.jadort.client.flex.business.*;
    import org.ow2.jasmine.jadort.client.flex.event.*;
    import org.ow2.jasmine.jadort.client.flex.model.*;
    import org.ow2.jasmine.jadort.client.flex.vo.*;

    /**
     * This class allows to select an Operation from the operation list
     * and load the needed objects to resume this operation
     */
    public class GetCurrentOperationCommand extends SequenceCommandWithErrorHandling implements IResponder {

        private var server : ServerVO;

        override public function execute(event : CairngormEvent) : void {
            // cast the cairngorm event so we can get the showBusyCursor
            var getCurrentOperationEvent : GetCurrentOperationEvent = event as GetCurrentOperationEvent;

            if (getCurrentOperationEvent.showBusyCursor) {
                CursorManager.setBusyCursor();
            }

            // delegate to the GetCurrentOperationDelegate to
            // call the getCurrentOperation() service
            var delegate : GetCurrentOperationDelegate = JadortModelLocator.getInstance().getCurrentOperationDelegate;
            delegate.responder = this;
            delegate.getCurrentOperation();
        }

        public function result(event : Object) : void {
            var resultEvent : ResultEvent = event as ResultEvent;
            var currentOperation : OperationStateVO = resultEvent.result as OperationStateVO;
            var model : JadortModelLocator = JadortModelLocator.getInstance();
            model.currentOperation = currentOperation;

            var getPageIndexEvent : GetPageIndexEvent = new GetPageIndexEvent();
            CairngormEventDispatcher.getInstance().dispatchEvent(getPageIndexEvent);
        }
    }
}
