/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CheckBoxHeaderRenderer.as 2965 2009-01-12 12:14:51Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.view {

    import flash.events.MouseEvent;
    import mx.collections.ArrayCollection;
    import mx.controls.CheckBox;
    import mx.controls.DataGrid;
    import mx.events.DataGridEvent;
    import org.ow2.jasmine.jadort.client.flex.model.JadortModelLocator;
    import org.ow2.jasmine.jadort.client.flex.vo.*;

    public class CheckBoxHeaderRenderer extends CheckBox {

        [Bindable]
        public var model : JadortModelLocator = JadortModelLocator.getInstance();

        private var _data : CheckBoxHeaderColumn;

        public function CheckBoxHeaderRenderer() {
            super();
        }

        override public function get data() : Object {
            return _data;
        }

        override public function set data(value : Object) : void {
            _data = value as CheckBoxHeaderColumn;
            DataGrid(listData.owner).addEventListener(DataGridEvent.HEADER_RELEASE, sortEventHandler);
            selected = _data.selected;
        }

        private function sortEventHandler(event : DataGridEvent) : void {
            if (event.itemRenderer == this) {
                event.preventDefault();
            }
        }

        override protected function clickHandler(event : MouseEvent) : void {
            var server : ServerVO;

            super.clickHandler(event);
            data.selected = selected;
            model.selectedServers = new ArrayCollection();
            for each(server in model.servers) {
                if (!server.maintained) {
                    if (selected) {
                        model.selectedServers.addItem(server);
                    }
                }
            }

            // For the mx:GridRow to refresh
            model.servers.refresh();

            model.nextButtonEnabled = model.selectedServers.length > 0;
            data.dispatchEvent(event);
        }
    }
}