/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: RowColorDataGrid.as 2965 2009-01-12 12:14:51Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.view {

    import flash.display.Sprite;
    import mx.controls.DataGrid;

    // RowColorDataGrid Class allow changing line color following the datagrid data
    public class RowColorDataGrid extends DataGrid {
        /**
         * @private
         * Storage for rowColorFunction property.
         */
        private var _rowColorFunction : Function;

        public function RowColorDataGrid() {
            super();
        }

        [Inspectable(category = "General")]
        /**
         * A user-defined function that determines the color of the row.
         *
         * <p>The method signature has the following form : </p>
         *
         * <pre>labelFunction(datagrid : DataGrid, rowIndex : int, color : uint) : uint</pre>
         *
         * <p>Where <code>datagrid</code> specify the datagrid,
         * <code>rowIndex</code> specifies the index of the item for the row in the dataprovider,
         * <code>color</code> specifies the suggested color for the row.
         * Return the color for the row.
         **/
        public function get rowColorFunction() : Function {
            return _rowColorFunction;
        }

        public function set rowColorFunction(value : Function) : void {
            _rowColorFunction = value;
            invalidateList();
        }


        override protected function drawRowBackground(s : Sprite, rowIndex : int,
                                                y : Number, height : Number, color : uint, dataIndex : int) : void {
            if (rowColorFunction != null) {
                if (dataIndex < dataProvider.length) {
                    color = rowColorFunction(this, dataIndex, color);
                }
            }
            super.drawRowBackground(s, rowIndex, y, height, color, dataIndex);
        }
    }

}