/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: OperationStateVO.as 3500 2009-04-22 13:57:09Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.vo {

    import com.adobe.cairngorm.vo.IValueObject;
    import mx.collections.ArrayCollection;

    [RemoteClass(alias = "org.ow2.jasmine.jadort.api.entities.deployment.OperationStateBean")]
    [Bindable]
    public class OperationStateVO implements IValueObject {

        private var operationId : Number;
        private var operationName : String;
        private var operationDate : Date;
        private var operationTopology : TopologyVO;
        private var operationApplication : ApplicationVO;
        private var operationGroup : GroupVO;
        private var operationVmImage : VMImageVO;
        private var operationCanGoToNextStep : Boolean;
        private var operationCanGoToPreviousStep : Boolean;

        [ArrayElementType(ServerVO)]
        private var operationSelectedServers : ArrayCollection;

        [ArrayElementType(ServerProgressVO)]
        private var operationServerProgressList : ArrayCollection;

        [ArrayElementType(WorkerProgressVO)]
        private var operationWorkerProgressList : ArrayCollection;

        public function OperationStateVO() {
            super();
        }

        public function get id() : Number {
            return operationId;
        }

        public function get name() : String {
            return operationName;
        }

        public function get date() : Date {
            return operationDate;
        }

        public function get topology() : TopologyVO {
            return operationTopology;
        }

        public function get serverProgressList() : ArrayCollection {
            return operationServerProgressList;
        }
        
        public function get workerProgressList() : ArrayCollection {
            return operationWorkerProgressList;
        }

        public function get selectedServers() : ArrayCollection {
            return operationSelectedServers;
        }

        public function get application() : ApplicationVO {
            return operationApplication;
        }

        public function get selectedGroup() : GroupVO {
            return operationGroup;
        }
        
        public function get vmImage() : VMImageVO {
            return operationVmImage;
        }
        
        public function get canGoToNextStep() : Boolean {
            return operationCanGoToNextStep;
        }
        
        public function get canGoToPreviousStep() : Boolean {
            return operationCanGoToPreviousStep;
        }

        public function set id(operationId : Number) : void {
            this.operationId = operationId;
        }

        public function set name(operationName : String) : void {
            this.operationName = operationName;
        }

        public function set date(operationDate : Date) : void {
            this.operationDate = operationDate;
        }

        public function set topology(operationTopology : TopologyVO) : void {
            this.operationTopology = operationTopology;
        }

        public function set application(operationApplication : ApplicationVO) : void {
            this.operationApplication = operationApplication;
        }

        public function set serverProgressList(operationServerProgressList : ArrayCollection) : void {
            this.operationServerProgressList = operationServerProgressList;
        }

        public function set workerProgressList(operationWorkerProgressList : ArrayCollection) : void {
            this.operationWorkerProgressList = operationWorkerProgressList;
        }

        public function set selectedServers(operationSelectedServers : ArrayCollection) : void {
            this.operationSelectedServers = operationSelectedServers;
        }

        public function set selectedGroup(operationGroup : GroupVO) : void {
            this.operationGroup = operationGroup;
        }

        public function set vmImage(operationVmImage : VMImageVO) : void {
            this.operationVmImage = operationVmImage;
        }

        public function set canGoToNextStep(operationCanGoToNextStep : Boolean) : void {
            this.operationCanGoToNextStep = operationCanGoToNextStep;
        }

        public function set canGoToPreviousStep(operationCanGoToPreviousStep : Boolean) : void {
            this.operationCanGoToPreviousStep = operationCanGoToPreviousStep;
        }
    }
}
