/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServerVO.as 3495 2009-04-21 16:04:19Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.vo {

    import com.adobe.cairngorm.vo.IValueObject;
    import mx.controls.*;

    [RemoteClass(alias = "org.ow2.jasmine.jadort.api.entities.topology.ServerBean")]
    [Bindable]
    public class ServerVO implements IValueObject {

        private var serverName : String;
        private var serverCapacity : Number;
        private var serverId : Number;
        private var serverActiveSessions : Number;
        private var serverMaintained : Boolean = false;
        private var serverVM : VmVO;

        public function ServerVO() {
            super();
        }

        public function get id() : Number {
            return serverId;
        }

        public function get name() : String {
            return serverName;
        }

        public function get capacity() : Number {
            return serverCapacity;
        }

        public function get maintained() : Boolean {
            return serverMaintained;
        }

        public function get status() : String {
            if (serverMaintained) {
                return "Maintained";
            } else {
                return "Not maintained";
            }
        }

        public function get activeSessions() : Number {
            return serverActiveSessions;
        }

        public function get vm() : VmVO {
            return serverVM;
        }

        public function set id(serverId : Number) : void {
            this.serverId = serverId;
        }

        public function set name(serverName : String) : void {
            this.serverName = serverName;
        }

        public function set capacity(serverCapacity : Number) : void {
            this.serverCapacity = serverCapacity;
        }

        public function set maintained(serverMaintained : Boolean) : void {
            this.serverMaintained = serverMaintained;
        }

        public function set activeSessions(serverActiveSessions : Number) : void {
            this.serverActiveSessions = serverActiveSessions;
        }

        public function set vm(serverVM : VmVO) : void {
            this.serverVM = serverVM;
        }
    }
}