/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import java.util.HashSet;
import java.util.LinkedList;
import macromedia.asc.embedding.avmplus.InstanceBuilder;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.ObjectValueWalker;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;

public final class InterfaceWalker
extends ObjectValueWalker {
    private LinkedList<TypeValue> queue = new LinkedList();
    private HashSet<TypeValue> set = new HashSet();
    private ObjectValue nextInterface = null;
    private boolean superInterfaces = false;

    public InterfaceWalker(ObjectValue objectValue) {
        this(objectValue, true);
    }

    public InterfaceWalker(ObjectValue objectValue, boolean bl) {
        this.superInterfaces = bl;
        this.queue.add(objectValue instanceof TypeValue ? (TypeValue)objectValue : objectValue.type.getTypeValue());
        this.processQueue();
        if (this.nextInterface == objectValue) {
            this.nextInterface = null;
        }
    }

    public boolean hasNext() {
        this.processQueue();
        return this.nextInterface != null;
    }

    public ObjectValue next() {
        ObjectValue objectValue = this.nextInterface;
        this.nextInterface = null;
        return objectValue;
    }

    public void clear() {
        this.set.clear();
        this.queue.clear();
        this.nextInterface = null;
    }

    private void processQueue() {
        while (this.nextInterface == null && !this.queue.isEmpty()) {
            TypeValue typeValue = this.queue.removeFirst();
            if (typeValue.baseclass != null && !typeValue.isInterface()) {
                this.queue.add(typeValue.baseclass);
            }
            InstanceBuilder instanceBuilder = (InstanceBuilder)typeValue.prototype.builder;
            if (instanceBuilder.interface_refs != null && (this.superInterfaces || !typeValue.isInterface())) {
                int n = instanceBuilder.interface_refs.size();
                for (int i = 0; i < n; ++i) {
                    ReferenceValue referenceValue = (ReferenceValue)instanceBuilder.interface_refs.get(i);
                    this.queue.add((TypeValue)referenceValue.slot.getObjectValue());
                }
            }
            if (!typeValue.isInterface() || this.set.contains(typeValue)) continue;
            this.nextInterface = typeValue.prototype;
            this.set.add(typeValue);
        }
    }
}

