/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.util.Boxing;
import macromedia.asc.util.Qualifiers;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Names {
    private String[] names;
    private ObjectValue[] namespaces;
    private int[] bindings;
    private int size;
    private Names delegate = EMPTY_NAMES;
    public static final int GET_NAMES = 0;
    public static final int SET_NAMES = 1;
    public static final int VAR_NAMES = 2;
    public static final int METHOD_NAMES = 3;
    public static final int LOCAL_METHOD_NAMES = 4;
    private static final int INITIAL_CAPACITY = 8;
    public static final Names EMPTY_NAMES;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setDelegate(Names names) {
        names.size();
        this.delegate = names;
    }

    private int hash(String string, int n) {
        if (!$assertionsDisabled && string.intern() != string) {
            throw new Error();
        }
        return string.hashCode() * (n + 1);
    }

    private int find(String string, int n, int n2) {
        String string2;
        int n3 = 7;
        int n4 = n2 - 1;
        int n5 = this.hash(string, n) & n4;
        while ((string2 = this.names[n5]) != null && (string2 != string || n != (this.bindings[n5] & 7))) {
            n5 = n5 + n3++ & n4;
        }
        return n5;
    }

    private int find(String string, ObjectValue objectValue, int n, int n2) {
        String string2;
        int n3 = 7;
        int n4 = n2 - 1;
        int n5 = this.hash(string, n) & n4;
        String string3 = objectValue.name;
        if (!$assertionsDisabled && string3 != string3.intern()) {
            throw new Error();
        }
        while ((string2 = this.names[n5]) != null && (string2 != string || n != (this.bindings[n5] & 7) || string3 != this.namespaces[n5].name || objectValue.getNamespaceKind() != this.namespaces[n5].getNamespaceKind())) {
            n5 = n5 + n3++ & n4;
        }
        return n5;
    }

    public int size() {
        if (this == EMPTY_NAMES) {
            return 0;
        }
        return this.size + this.delegate.size();
    }

    private boolean isFull() {
        return 5 * (this.size + 1) >= this.capacity() * 4;
    }

    private final int capacity() {
        return this.names != null ? this.names.length : 0;
    }

    private int put(String string, ObjectValue objectValue, int n) {
        int n2;
        if (this.names == null) {
            this.names = new String[8];
            this.namespaces = new ObjectValue[8];
            this.bindings = new int[8];
        }
        if (this.isFull()) {
            this.grow();
        }
        if (!string.equals(this.names[n2 = this.find(string, objectValue, n, this.capacity())])) {
            ++this.size;
            this.names[n2] = string;
            this.namespaces[n2] = objectValue;
        }
        return n2;
    }

    public void putMask(String string, ObjectValue objectValue, int n) {
        int n2 = this.put(string, objectValue, n);
        this.bindings[n2] = this.bindings[n2] | n;
    }

    public void put(String string, ObjectValue objectValue, int n, int n2) {
        int n3 = this.put(string, objectValue, n);
        this.bindings[n3] = n2 << 3 | n;
    }

    public boolean containsKey(String string, int n) {
        if (this == EMPTY_NAMES) {
            return false;
        }
        boolean bl = false;
        if (this.names != null) {
            int n2 = this.find(string, n, this.capacity());
            boolean bl2 = bl = this.names[n2] != null && this.names[n2] == string && (this.bindings[n2] & 7) == n && this.bindings[n2] >> 3 != -1;
        }
        if (!bl) {
            bl = this.delegate.containsKey(string, n);
        }
        return bl;
    }

    public int get(String string, ObjectValue objectValue, int n) {
        if (this == EMPTY_NAMES) {
            return -1;
        }
        int n2 = -1;
        if (this.names != null) {
            int n3 = this.find(string, objectValue, n, this.capacity());
            int n4 = n2 = this.names[n3] == string && (this.bindings[n3] & 7) == n ? this.bindings[n3] >> 3 : -1;
        }
        if (n2 == -1) {
            n2 = this.delegate.get(string, objectValue, n);
        }
        return n2;
    }

    public Set<Map.Entry<String, Qualifiers>> entrySet(int n) {
        TreeMap<String, Qualifiers> treeMap = new TreeMap<String, Qualifiers>();
        int n2 = this.capacity();
        for (int i = 0; i < n2; ++i) {
            if (this.names[i] == null || (this.bindings[i] & 7) != n) continue;
            Qualifiers qualifiers = (Qualifiers)treeMap.get(this.names[i]);
            if (qualifiers == null) {
                qualifiers = new Qualifiers();
                treeMap.put(this.names[i], qualifiers);
            }
            qualifiers.put(this.namespaces[i], Boxing.valueOf(this.bindings[i] >> 3));
        }
        return treeMap.entrySet();
    }

    public Qualifiers get(String string, int n) {
        String string2;
        if (this == EMPTY_NAMES) {
            return null;
        }
        Qualifiers qualifiers = null;
        int n2 = this.capacity();
        int n3 = 7;
        int n4 = n2 - 1;
        int n5 = this.hash(string, n) & n4;
        while ((string2 = this.names[n5]) != null) {
            if (string2 == string && (this.bindings[n5] & 7) == n) {
                if (qualifiers == null) {
                    qualifiers = new Qualifiers();
                }
                qualifiers.put(this.namespaces[n5], Boxing.valueOf(this.bindings[n5] >> 3));
            }
            n5 = n5 + n3++ & n4;
        }
        if (qualifiers != null) {
            Qualifiers qualifiers2 = this.delegate.get(string, n);
            if (qualifiers2 != null) {
                qualifiers.putAll(qualifiers2);
            }
        } else {
            qualifiers = this.delegate.get(string, n);
        }
        return qualifiers;
    }

    public void putAll(Names names) {
        int n;
        if (names == null) {
            n = names.capacity();
            this.names = new String[n];
            this.namespaces = new ObjectValue[n];
            this.bindings = new int[n];
        }
        int n2 = names.capacity();
        for (n = 0; n < n2; ++n) {
            if (names.names[n] == null) continue;
            this.put(names.names[n], names.namespaces[n], names.bindings[n] & 7, names.bindings[n] >> 3);
        }
    }

    public void putAll(Names names, int n) {
        int n2;
        if (names == null) {
            n2 = names.capacity();
            this.names = new String[n2];
            this.namespaces = new ObjectValue[n2];
            this.bindings = new int[n2];
        }
        int n3 = names.capacity();
        for (n2 = 0; n2 < n3; ++n2) {
            if (names.names[n2] == null || (names.bindings[n2] & 7) != n) continue;
            this.put(names.names[n2], names.namespaces[n2], names.bindings[n2] & 7, names.bindings[n2] >> 3);
        }
    }

    public boolean containsKey(String string, ObjectValue objectValue, int n) {
        if (this == EMPTY_NAMES) {
            return false;
        }
        boolean bl = false;
        if (this.names != null) {
            int n2 = this.find(string, objectValue, n, this.capacity());
            boolean bl2 = bl = this.names[n2] == string && this.bindings[n2] >> 3 != -1;
        }
        if (!bl) {
            bl = this.delegate.containsKey(string, objectValue, n);
        }
        return bl;
    }

    private void grow() {
        int n = this.capacity() * 2;
        String[] stringArray = this.names;
        ObjectValue[] objectValueArray = this.namespaces;
        int[] nArray = this.bindings;
        this.names = new String[n];
        this.namespaces = new ObjectValue[n];
        this.bindings = new int[n];
        int n2 = stringArray.length;
        for (int i = 0; i < n2; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            int n3 = this.find(string, objectValueArray[i], nArray[i] & 7, n);
            this.names[n3] = string;
            this.namespaces[n3] = objectValueArray[i];
            this.bindings[n3] = nArray[i];
        }
    }

    public static int getTypeFromKind(int n) {
        switch (n) {
            case -78: {
                return 0;
            }
            case -98: {
                return 1;
            }
            case -111: {
                return 2;
            }
        }
        return 3;
    }

    public String getName(int n) {
        return this.names[n];
    }

    public ObjectValue getNamespace(int n) {
        return this.namespaces[n];
    }

    public int getSlot(int n) {
        return this.bindings[n] >> 3;
    }

    public int getType(int n) {
        return this.bindings[n] & 7;
    }

    public int hasNext(int n) {
        int n2 = this.capacity();
        while (n < n2) {
            if (this.names[n] != null) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    static {
        $assertionsDisabled = true;
        EMPTY_NAMES = new Names();
    }
}

