/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.flex;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.granite.messaging.service.SimpleServiceFactory;
import org.granite.util.ClassUtil;
import org.granite.util.JDOMUtil;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Factory {
    public static final Factory DEFAULT_FACTORY = new Factory(null, SimpleServiceFactory.class.getName(), ClassUtil.emptyMap(String.class, Object.class));
    private final String id;
    private final String className;
    private final Map<String, Object> properties;

    public Factory(String id, String className, Map<String, Object> properties) {
        this.id = id;
        this.className = className;
        this.properties = Collections.unmodifiableMap(properties);
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public static Factory forElement(Element element) {
        JDOMUtil.checkElement(element, "factory", "id", "class");
        String id = element.getAttributeValue("id");
        String className = element.getAttributeValue("class");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        Element propertiesElt = element.getChild("properties");
        if (propertiesElt != null) {
            for (Element property : JDOMUtil.getChildren(propertiesElt)) {
                properties.put(property.getName(), property.getText());
            }
        }
        return new Factory(id, className, properties);
    }
}

