/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.amf.io.util.externalizer;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.granite.collections.BasicMap;
import org.granite.context.GraniteContext;
import org.granite.messaging.amf.io.util.Converter;
import org.granite.messaging.amf.io.util.externalizer.DefaultConstructorFactory;
import org.granite.messaging.amf.io.util.externalizer.Externalizer;
import org.granite.messaging.amf.io.util.externalizer.NoDefaultConstructorFactory;
import org.granite.messaging.amf.io.util.externalizer.SunDefaultConstructorFactory;
import org.granite.messaging.amf.io.util.instanciator.AbstractInstanciator;
import org.granite.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExternalizer
implements Externalizer {
    private static final Object[] ZERO_ARGS = new Object[0];
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentHashMap<Class<?>, List<Field>> orderedFields = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Constructor<?>> constructors = new ConcurrentHashMap();

    @Override
    public Object newInstance(String type, ObjectInput in) throws IOException, ClassNotFoundException, InstantiationException, InvocationTargetException, IllegalAccessException {
        Class<?> clazz;
        Constructor<?> previousConstructor;
        Constructor<?> constructor = this.constructors.get(type);
        if (constructor == null && (previousConstructor = this.constructors.putIfAbsent(type, constructor = this.findDefaultConstructor(clazz = ClassUtil.forName(type)))) != null) {
            constructor = previousConstructor;
        }
        return constructor.newInstance(ZERO_ARGS);
    }

    @Override
    public void readExternal(Object o, ObjectInput in) throws IOException, ClassNotFoundException, IllegalAccessException {
        if (o instanceof AbstractInstanciator) {
            AbstractInstanciator instanciator = (AbstractInstanciator)o;
            for (String fieldName : instanciator.getOrderedFieldNames()) {
                instanciator.put(fieldName, in.readObject());
            }
        } else {
            Converter converter = GraniteContext.getCurrentInstance().getGraniteConfig().getConverter();
            List<Field> fields = this.findOrderedFields(o.getClass());
            for (Field field : fields) {
                field.setAccessible(true);
                Object value = converter.convertForDeserialization(in.readObject(), field.getType());
                field.set(o, value);
            }
        }
    }

    @Override
    public void writeExternal(Object o, ObjectOutput out) throws IOException, IllegalAccessException {
        GraniteContext context = GraniteContext.getCurrentInstance();
        String instanciatorType = context.getGraniteConfig().getInstanciator(o.getClass().getName());
        if (instanciatorType != null) {
            try {
                AbstractInstanciator instanciator = (AbstractInstanciator)ClassUtil.newInstance(instanciatorType);
                for (String fieldName : instanciator.getOrderedFieldNames()) {
                    Field field = o.getClass().getDeclaredField(fieldName);
                    field.setAccessible(true);
                    out.writeObject(field.get(o));
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error with instanciatorType: " + instanciatorType, e);
            }
        } else {
            List<Field> fields = this.findOrderedFields(o.getClass());
            for (Field field : fields) {
                field.setAccessible(true);
                BasicMap<?, ?> value = field.get(o);
                if (value instanceof Map) {
                    value = BasicMap.newInstance((Map)value);
                }
                out.writeObject(value);
            }
        }
    }

    @Override
    public List<Field> findOrderedFields(Class<?> clazz) {
        List<Field> fields = this.orderedFields.get(clazz);
        if (fields == null) {
            fields = new ArrayList<Field>();
            HashSet<String> allFieldNames = new HashSet<String>();
            Class<?> c = clazz;
            while (c != null) {
                ArrayList<Field> newFields = new ArrayList<Field>();
                Field[] fieldArray = c.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    if (!(allFieldNames.contains(field.getName()) || Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()))) {
                        newFields.add(field);
                    }
                    allFieldNames.add(field.getName());
                    ++n2;
                }
                Collections.sort(newFields, new Comparator<Field>(){

                    @Override
                    public int compare(Field o1, Field o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                fields.addAll(0, newFields);
                c = c.getSuperclass();
            }
            List<Field> previousFields = this.orderedFields.putIfAbsent(clazz, fields);
            if (previousFields != null) {
                fields = previousFields;
            }
        }
        return fields;
    }

    protected <T> Constructor<T> findDefaultConstructor(Class<T> clazz) {
        Constructor<T> constructor = null;
        GraniteContext context = GraniteContext.getCurrentInstance();
        String instanciator = context.getGraniteConfig().getInstanciator(clazz.getName());
        if (instanciator != null) {
            try {
                Class<T> instanciatorClass = ClassUtil.forName(instanciator, clazz);
                constructor = instanciatorClass.getConstructor(new Class[0]);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not load instanciator class: " + instanciator + " for: " + clazz.getName(), e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Could not find default constructor in instanciator class: " + instanciator, e);
            }
        }
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (constructor == null) {
            String key = DefaultConstructorFactory.class.getName();
            DefaultConstructorFactory factory = this.getDefaultConstructorFactory(context, key);
            constructor = factory.findDefaultConstructor(clazz);
        }
        return constructor;
    }

    private DefaultConstructorFactory getDefaultConstructorFactory(GraniteContext context, String key) {
        this.lock.lock();
        try {
            DefaultConstructorFactory factory = (DefaultConstructorFactory)context.getApplicationMap().get(key);
            if (factory == null) {
                try {
                    factory = new SunDefaultConstructorFactory();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (factory == null) {
                    factory = new NoDefaultConstructorFactory();
                }
                context.getApplicationMap().put(key, factory);
            }
            DefaultConstructorFactory defaultConstructorFactory = factory;
            return defaultConstructorFactory;
        }
        finally {
            this.lock.unlock();
        }
    }
}

