/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServerWorkerErrorRendererClass.as 2965 2009-01-12 12:14:51Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.view {

    import flash.events.*;
    import mx.collections.ArrayCollection;
    import mx.containers.HBox;
    import mx.controls.*;
    import mx.controls.dataGridClasses.DataGridListData;
    import mx.controls.listClasses.BaseListData;
    import mx.events.*;
    import mx.managers.*;
    import org.ow2.jasmine.jadort.client.flex.model.JadortModelLocator;
    import org.ow2.jasmine.jadort.client.flex.vo.*;
    import org.ow2.jasmine.jadort.client.flex.event.*;
    import com.adobe.cairngorm.control.CairngormEventDispatcher;

    import mx.containers.TitleWindow;

    public class ServerWorkerErrorRendererClass extends HBox {

        public var ViewLogButton : Button;
        public var AbortButton : Button;
        public var RestartButton : Button;
        public var IgnoreButton : Button;

        private var _listData : DataGridListData;

        [Bindable]
        private var LogErrorMessage : String;
        private var logErrorWindow : TitleWindow;

        [Bindable]
        public var model : JadortModelLocator = JadortModelLocator.getInstance();

        private function onClose(e : CloseEvent) : void {
            PopUpManager.removePopUp(logErrorWindow);
        }

        public function set listData(value : BaseListData) : void {
            _listData = DataGridListData(value);
        }

        public function get listData() : BaseListData {
            return _listData;
        }

        override public function set data(value : Object) : void {
            super.data = value;
            if (super.data != null) {
                this.LogErrorMessage = super.data.log;

                // update UI
                if (super.data.state == "Error !") {
                    RestartButton.visible = true;
                    IgnoreButton.visible = true;
                    AbortButton.visible = false;
                } else {
                    RestartButton.visible = false;
                    IgnoreButton.visible = false;
                    AbortButton.visible =(super.data.state == "Running");
                }
            }
        }

        override public function get data() : Object {
            return super.data;
        }

        public function clickViewLogButton(event : Event) : void {
            // display log
            logErrorWindow = TitleWindow(PopUpManager.createPopUp(this,ErrorLogPopUp,true));
            (logErrorWindow as ErrorLogPopUp).messageError.text = this.LogErrorMessage;
            logErrorWindow.addEventListener(CloseEvent.CLOSE,onClose);
            logErrorWindow.showCloseButton = true;
            PopUpManager.centerPopUp(logErrorWindow);
        }

        public function clickAbortButton(event : Event, type : String) : void {
            RestartButton.visible = false;
            IgnoreButton.visible = false;
            AbortButton.visible = false;

            if (type == "SERVER") {
                // dispatch AbortServerEvent to abort server
                var abortServerEvent : AbortServerEvent = new AbortServerEvent(super.data.server);
                CairngormEventDispatcher.getInstance().dispatchEvent(abortServerEvent);
            } else if (type == "WORKER") {
                // dispatch AbortWorkerEvent to abort worker
                var abortWorkerEvent : AbortWorkerEvent = new AbortWorkerEvent(super.data.worker);
                CairngormEventDispatcher.getInstance().dispatchEvent(abortWorkerEvent);
            }
        }

        public function clickRestartButton(event : Event, type : String) : void {
            // update UI
            RestartButton.visible = false;
            IgnoreButton.visible = false;
            AbortButton.visible = true;

            if (type == "SERVER") {
                // dispatch restartServerEvent to restart server
                var restartServerEvent : RestartServerEvent = new RestartServerEvent(super.data.server);
                CairngormEventDispatcher.getInstance().dispatchEvent(restartServerEvent);
            } else if (type == "WORKER") {
                // dispatch restartWorkerEvent to restart worker
                var restartWorkerEvent : RestartWorkerEvent = new RestartWorkerEvent(super.data.worker);
                CairngormEventDispatcher.getInstance().dispatchEvent(restartWorkerEvent);
            }
        }

        public function clickIgnoreButton(event : Event, type : String) : void {
            // update UI
            RestartButton.visible = false;
            IgnoreButton.visible = false;
            AbortButton.visible = false;

            if (type == "SERVER") {
                // dispatch CheckServerEvent to check server
                var checkServerEvent : CheckServerEvent = new CheckServerEvent(super.data.server);
                CairngormEventDispatcher.getInstance().dispatchEvent(checkServerEvent);
            } else if (type == "WORKER") {
                // dispatch CheckWorkerEvent to check worker
                var checkWorkerEvent : CheckWorkerEvent = new CheckWorkerEvent(super.data.worker);
                CairngormEventDispatcher.getInstance().dispatchEvent(checkWorkerEvent);
            }
        }
    }
}
