/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.iterators.ArrayIterator;
import org.apache.commons.collections.iterators.ArrayListIterator;
import org.apache.commons.collections.iterators.CollatingIterator;
import org.apache.commons.collections.iterators.EnumerationIterator;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.FilterListIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.commons.collections.iterators.IteratorEnumeration;
import org.apache.commons.collections.iterators.ListIteratorWrapper;
import org.apache.commons.collections.iterators.LoopingIterator;
import org.apache.commons.collections.iterators.ObjectArrayIterator;
import org.apache.commons.collections.iterators.ObjectArrayListIterator;
import org.apache.commons.collections.iterators.ResetableIterator;
import org.apache.commons.collections.iterators.ResetableListIterator;
import org.apache.commons.collections.iterators.SingletonIterator;
import org.apache.commons.collections.iterators.SingletonListIterator;
import org.apache.commons.collections.iterators.TransformIterator;

public class IteratorUtils {
    public static final Iterator EMPTY_ITERATOR = new EmptyIterator();
    public static final ListIterator EMPTY_LIST_ITERATOR = new EmptyListIterator();
    static /* synthetic */ Class class$java$util$Iterator;

    private IteratorUtils() {
    }

    public static ResetableIterator emptyIterator() {
        return (ResetableIterator)EMPTY_ITERATOR;
    }

    public static ResetableListIterator emptyListIterator() {
        return (ResetableListIterator)EMPTY_LIST_ITERATOR;
    }

    public static ResetableIterator singletonIterator(Object object) {
        return new SingletonIterator(object);
    }

    public static ResetableListIterator singletonListIterator(Object object) {
        return new SingletonListIterator(object);
    }

    public static ResetableIterator arrayIterator(Object[] array) {
        return new ObjectArrayIterator(array);
    }

    public static ResetableIterator arrayIterator(Object array) {
        return new ArrayIterator(array);
    }

    public static ResetableIterator arrayIterator(Object[] array, int start) {
        return new ObjectArrayIterator(array, start);
    }

    public static ResetableIterator arrayIterator(Object array, int start) {
        return new ArrayIterator(array, start);
    }

    public static ResetableIterator arrayIterator(Object[] array, int start, int end) {
        return new ObjectArrayIterator(array, start, end);
    }

    public static ResetableIterator arrayIterator(Object array, int start, int end) {
        return new ArrayIterator(array, start, end);
    }

    public static ResetableListIterator arrayListIterator(Object[] array) {
        return new ObjectArrayListIterator(array);
    }

    public static ResetableListIterator arrayListIterator(Object array) {
        return new ArrayListIterator(array);
    }

    public static ResetableListIterator arrayListIterator(Object[] array, int start) {
        return new ObjectArrayListIterator(array, start);
    }

    public static ResetableListIterator arrayListIterator(Object array, int start) {
        return new ArrayListIterator(array, start);
    }

    public static ResetableListIterator arrayListIterator(Object[] array, int start, int end) {
        return new ObjectArrayListIterator(array, start, end);
    }

    public static ResetableListIterator arrayListIterator(Object array, int start, int end) {
        return new ArrayListIterator(array, start, end);
    }

    public static Iterator unmodifiableIterator(Iterator iterator) {
        if (iterator instanceof ResetableIterator) {
            return new ResetableUnmodifiableIterator((ResetableIterator)iterator);
        }
        return new UnmodifiableIterator(iterator);
    }

    public static ListIterator unmodifiableListIterator(ListIterator listIterator) {
        if (listIterator instanceof ResetableListIterator) {
            return new ResetableUnmodifiableListIterator((ResetableListIterator)listIterator);
        }
        return new UnmodifiableListIterator(listIterator);
    }

    public static Iterator chainedIterator(Iterator iterator1, Iterator iterator2) {
        return new IteratorChain(iterator1, iterator2);
    }

    public static Iterator chainedIterator(Iterator[] iterators) {
        return new IteratorChain(iterators);
    }

    public static Iterator chainedIterator(Collection iterators) {
        return new IteratorChain(iterators);
    }

    public static Iterator collatedIterator(Comparator comparator, Iterator iterator1, Iterator iterator2) {
        return new CollatingIterator(comparator, iterator1, iterator2);
    }

    public static Iterator collatedIterator(Comparator comparator, Iterator[] iterators) {
        return new CollatingIterator(comparator, iterators);
    }

    public static Iterator collatedIterator(Comparator comparator, Collection iterators) {
        return new CollatingIterator(comparator, iterators);
    }

    public static Iterator transformedIterator(Iterator iterator, Transformer transform) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (transform == null) {
            throw new NullPointerException("Transformer must not be null");
        }
        return new TransformIterator(iterator, transform);
    }

    public static Iterator filteredIterator(Iterator iterator, Predicate predicate) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null");
        }
        return new FilterIterator(iterator, predicate);
    }

    public static ListIterator filteredListIterator(ListIterator listIterator, Predicate predicate) {
        if (listIterator == null) {
            throw new NullPointerException("ListIterator must not be null");
        }
        if (predicate == null) {
            throw new NullPointerException("Predicate must not be null");
        }
        return new FilterListIterator(listIterator, predicate);
    }

    public static ResetableIterator loopingIterator(Collection coll) {
        if (coll == null) {
            throw new NullPointerException("Collection must not be null");
        }
        return new LoopingIterator(coll);
    }

    public static Iterator asIterator(Enumeration enumeration) {
        if (enumeration == null) {
            throw new NullPointerException("Enumeration must not be null");
        }
        return new EnumerationIterator(enumeration);
    }

    public static Iterator asIterator(Enumeration enumeration, Collection removeCollection) {
        if (enumeration == null) {
            throw new NullPointerException("Enumeration must not be null");
        }
        if (removeCollection == null) {
            throw new NullPointerException("Collection must not be null");
        }
        return new EnumerationIterator(enumeration, removeCollection);
    }

    public static Enumeration asEnumeration(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        return new IteratorEnumeration(iterator);
    }

    public static ListIterator toListIterator(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        return new ListIteratorWrapper(iterator);
    }

    public static Object[] toArray(Iterator iterator) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        List list = IteratorUtils.toList(iterator, 100);
        return list.toArray();
    }

    public static Object[] toArray(Iterator iterator, Class arrayClass) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (arrayClass == null) {
            throw new NullPointerException("Array class must not be null");
        }
        List list = IteratorUtils.toList(iterator, 100);
        return list.toArray((Object[])Array.newInstance(arrayClass, list.size()));
    }

    public static List toList(Iterator iterator) {
        return IteratorUtils.toList(iterator, 10);
    }

    public static List toList(Iterator iterator, int estimatedSize) {
        if (iterator == null) {
            throw new NullPointerException("Iterator must not be null");
        }
        if (estimatedSize < 1) {
            throw new IllegalArgumentException("Estimated size must be greater than 0");
        }
        ArrayList list = new ArrayList(estimatedSize);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    public static Iterator getIterator(Object obj) {
        if (obj == null) {
            return IteratorUtils.emptyIterator();
        }
        if (obj instanceof Iterator) {
            return (Iterator)obj;
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj instanceof Object[]) {
            return new ObjectArrayIterator((Object[])obj);
        }
        if (obj instanceof Enumeration) {
            return new EnumerationIterator((Enumeration)obj);
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().iterator();
        }
        if (obj instanceof Dictionary) {
            return new EnumerationIterator(((Dictionary)obj).elements());
        }
        if (obj != null && obj.getClass().isArray()) {
            return new ArrayIterator(obj);
        }
        try {
            Iterator it;
            Method method = obj.getClass().getMethod("iterator", null);
            if ((class$java$util$Iterator == null ? (class$java$util$Iterator = IteratorUtils.class$("java.util.Iterator")) : class$java$util$Iterator).isAssignableFrom(method.getReturnType()) && (it = (Iterator)method.invoke(obj, null)) != null) {
                return it;
            }
        }
        catch (Exception ex) {}
        return IteratorUtils.singletonIterator(obj);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class ResetableUnmodifiableListIterator
    extends UnmodifiableListIterator
    implements ResetableListIterator {
        public ResetableUnmodifiableListIterator(ResetableListIterator delegate) {
            super(delegate);
        }

        public void reset() {
            ((ResetableListIterator)this.delegate).reset();
        }
    }

    static class UnmodifiableListIterator
    implements ListIterator,
    Serializable {
        protected ListIterator delegate;

        public UnmodifiableListIterator(ListIterator delegate) {
            this.delegate = delegate;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            return this.delegate.next();
        }

        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        public Object previous() {
            return this.delegate.previous();
        }

        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        public void remove() {
            throw new UnsupportedOperationException("This iterator is immutable");
        }

        public void set(Object o) {
            throw new UnsupportedOperationException("This iterator is immutable");
        }

        public void add(Object o) {
            throw new UnsupportedOperationException("This iterator is immutable");
        }
    }

    static class ResetableUnmodifiableIterator
    extends UnmodifiableIterator
    implements ResetableIterator {
        public ResetableUnmodifiableIterator(ResetableIterator delegate) {
            super(delegate);
        }

        public void reset() {
            ((ResetableIterator)this.delegate).reset();
        }
    }

    static class UnmodifiableIterator
    implements Iterator,
    Serializable {
        protected Iterator delegate;

        public UnmodifiableIterator(Iterator delegate) {
            this.delegate = delegate;
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public Object next() {
            return this.delegate.next();
        }

        public void remove() {
            throw new UnsupportedOperationException("This iterator is immutable");
        }
    }

    static class EmptyListIterator
    extends EmptyIterator
    implements ResetableListIterator {
        EmptyListIterator() {
        }

        public boolean hasPrevious() {
            return false;
        }

        public Object previous() {
            throw new NoSuchElementException();
        }

        public int nextIndex() {
            return 0;
        }

        public int previousIndex() {
            return -1;
        }

        public void add(Object o) {
            throw new UnsupportedOperationException("add() not supported for empty Iterator");
        }

        public void set(Object o) {
            throw new UnsupportedOperationException("set() not supported for empty Iterator");
        }
    }

    static class EmptyIterator
    implements ResetableIterator {
        EmptyIterator() {
        }

        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        public void remove() {
            throw new UnsupportedOperationException("remove() not supported for empty Iterator");
        }

        public void reset() {
        }
    }
}

