/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.embedding.avmplus;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import macromedia.asc.util.ByteList;
import macromedia.asc.util.IntList;
import macromedia.asc.util.IntegerPool;
import macromedia.asc.util.ObjectList;
import macromedia.asc.util.StringPrintWriter;

/*
 * This class specifies class file version 47.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ByteCodeFactory {
    private static boolean debug = false;
    public StringPrintWriter cpool_out = new StringPrintWriter();
    public StringPrintWriter defns_out = new StringPrintWriter();
    public boolean show_bytecode;
    private Map<String, ByteList> utfConstants = new HashMap<String, ByteList>();
    private Map<Integer, ByteList> nsConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> nsPackageConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> nsPrivateConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> nsInternalConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> nsProtectedConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> nsStaticProtectedConstants = new HashMap<Integer, ByteList>();
    private Map<Integer, ByteList> intConstants = new HashMap<Integer, ByteList>();
    private ByteList FALSE = new ByteList(1);
    private ByteList TRUE;
    private ByteList NULL;

    public ByteCodeFactory() {
        ByteCodeFactory.Byte(this.FALSE, 10);
        this.TRUE = new ByteList(1);
        ByteCodeFactory.Byte(this.TRUE, 11);
        this.NULL = new ByteList(1);
        ByteCodeFactory.Byte(this.NULL, 12);
    }

    public void clear() {
        this.utfConstants.clear();
        this.nsConstants.clear();
        this.nsPackageConstants.clear();
        this.nsPrivateConstants.clear();
        this.nsInternalConstants.clear();
        this.nsProtectedConstants.clear();
        this.nsStaticProtectedConstants.clear();
        this.intConstants.clear();
    }

    public static ByteList allocBytes() {
        return new ByteList();
    }

    public static ByteList allocBytes(int n) {
        return new ByteList(n);
    }

    public ByteList ConstantValue(byte by) {
        if (this.show_bytecode) {
            switch (by) {
                case 10: {
                    this.cpool_out.write("\n      ConstantFalse");
                    break;
                }
                case 11: {
                    this.cpool_out.write("\n      ConstantTrue");
                    break;
                }
                case 12: {
                    this.cpool_out.write("\n      ConstantNull");
                }
            }
        }
        switch (by) {
            case 10: {
                return this.FALSE;
            }
            case 11: {
                return this.TRUE;
            }
            case 12: {
                return this.NULL;
            }
        }
        ByteList byteList = ByteCodeFactory.allocBytes(1);
        ByteCodeFactory.Byte(byteList, by);
        return byteList;
    }

    public ByteList ConstantNamespace(int n) {
        Integer n2;
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantNamespace ").append(n).toString());
        }
        if (this.nsConstants.containsKey(n2 = IntegerPool.getNumber(n))) {
            return this.nsConstants.get(n2);
        }
        ByteList byteList = ByteCodeFactory.allocBytes(3);
        byteList = ByteCodeFactory.Byte(byteList, 8);
        byteList = ByteCodeFactory.Int(byteList, n);
        this.nsConstants.put(n2, byteList);
        return byteList;
    }

    public ByteList ConstantPrivateNamespace(int n) {
        Integer n2;
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantPrivateNamespace ").append(n).toString());
        }
        if (this.nsPrivateConstants.containsKey(n2 = IntegerPool.getNumber(n))) {
            return this.nsPrivateConstants.get(n2);
        }
        ByteList byteList = ByteCodeFactory.allocBytes(3);
        byteList = ByteCodeFactory.Byte(byteList, 5);
        byteList = ByteCodeFactory.Int(byteList, n);
        this.nsPrivateConstants.put(n2, byteList);
        return byteList;
    }

    public ByteList ConstantPackageNamespace(int n) {
        Integer n2;
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantPackageNamespace ").append(n).toString());
        }
        if (this.nsPackageConstants.containsKey(n2 = IntegerPool.getNumber(n))) {
            return this.nsPackageConstants.get(n2);
        }
        ByteList byteList = ByteCodeFactory.allocBytes(3);
        byteList = ByteCodeFactory.Byte(byteList, 22);
        byteList = ByteCodeFactory.Int(byteList, n);
        this.nsPackageConstants.put(n2, byteList);
        return byteList;
    }

    public ByteList ConstantInternalNamespace(int n) {
        Integer n2;
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantInternalNamespace ").append(n).toString());
        }
        if (this.nsInternalConstants.containsKey(n2 = IntegerPool.getNumber(n))) {
            return this.nsInternalConstants.get(n2);
        }
        ByteList byteList = ByteCodeFactory.allocBytes(3);
        byteList = ByteCodeFactory.Byte(byteList, 23);
        byteList = ByteCodeFactory.Int(byteList, n);
        this.nsInternalConstants.put(n2, byteList);
        return byteList;
    }

    public ByteList ConstantProtectedNamespace(int n) {
        Integer n2;
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantProtectedNamespace ").append(n).toString());
        }
        if (this.nsProtectedConstants.containsKey(n2 = IntegerPool.getNumber(n))) {
            return this.nsProtectedConstants.get(n2);
        }
        ByteList byteList = ByteCodeFactory.allocBytes(3);
        byteList = ByteCodeFactory.Byte(byteList, 24);
        byteList = ByteCodeFactory.Int(byteList, n);
        this.nsProtectedConstants.put(n2, byteList);
        return byteList;
    }

    public ByteList ConstantStaticProtectedNamespace(int n) {
        Integer n2;
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantStaticProtectedNamespace ").append(n).toString());
        }
        if (this.nsStaticProtectedConstants.containsKey(n2 = IntegerPool.getNumber(n))) {
            return this.nsStaticProtectedConstants.get(n2);
        }
        ByteList byteList = ByteCodeFactory.allocBytes(3);
        byteList = ByteCodeFactory.Byte(byteList, 26);
        byteList = ByteCodeFactory.Int(byteList, n);
        this.nsStaticProtectedConstants.put(n2, byteList);
        return byteList;
    }

    public ByteList ConstantNamespaceSet(Set<Integer> set) {
        ByteList byteList = ByteCodeFactory.allocBytes(5 + set.size() * 2);
        return this.ConstantNamespaceSet(byteList, set);
    }

    public ByteList ConstantNamespaceSet(ByteList byteList, Set<Integer> set) {
        if (this.show_bytecode) {
            int n;
            this.cpool_out.write(new StringBuffer().append("\n      ConstantNamespaceSet ").append(set.size()).append(" {").toString());
            Iterator<Integer> iterator = set.iterator();
            while (iterator.hasNext() && (n = iterator.next().intValue()) != 0) {
                this.cpool_out.write(new StringBuffer().append(" ").append(n).toString());
            }
            this.cpool_out.write(" }");
        }
        byteList = ByteCodeFactory.Int(byteList, set.size());
        for (int n : set) {
            byteList = ByteCodeFactory.Int(byteList, n);
        }
        return byteList;
    }

    public ByteList ConstantMultiname(ByteList byteList, int n, int n2, boolean bl) {
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantMultiname ").append(bl ? "@" : "").append(n).append(" ").append(n2).toString());
        }
        byteList = ByteCodeFactory.Byte(byteList, bl ? 14 : 9);
        byteList = ByteCodeFactory.Int(byteList, n);
        byteList = ByteCodeFactory.Int(byteList, n2);
        return byteList;
    }

    public ByteList ConstantMultiname(int n, int n2, boolean bl) {
        return this.ConstantMultiname(ByteCodeFactory.allocBytes(5), n, n2, bl);
    }

    public ByteList ConstantMultinameLate(ByteList byteList, int n, boolean bl) {
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantMultinameLate ").append(bl ? "@" : "").append(n).toString());
        }
        byteList = ByteCodeFactory.Byte(byteList, bl ? 28 : 27);
        byteList = ByteCodeFactory.Int(byteList, n);
        return byteList;
    }

    public ByteList ConstantMultinameLate(int n, boolean bl) {
        return this.ConstantMultinameLate(ByteCodeFactory.allocBytes(5), n, bl);
    }

    public ByteList ConstantUtf8Info(String string) {
        byte[] byArray;
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantUtf8Info ").append(string).toString());
        }
        if (this.utfConstants.containsKey(string)) {
            return this.utfConstants.get(string);
        }
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            byArray = new byte[string.length()];
        }
        int n = byArray.length;
        ByteList byteList = ByteCodeFactory.allocBytes(n + 3);
        byteList = ByteCodeFactory.Int(byteList, n);
        byteList.addAll(byArray);
        this.utfConstants.put(string, byteList);
        return byteList;
    }

    public ByteList ConstantIntegerInfo(int n) {
        Integer n2;
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantIntegerInfo ").append(n).toString());
        }
        if (this.intConstants.containsKey(n2 = IntegerPool.getNumber(n))) {
            return this.intConstants.get(n2);
        }
        ByteList byteList = ByteCodeFactory.allocBytes(5);
        byteList = ByteCodeFactory.Int(byteList, n);
        this.intConstants.put(n2, byteList);
        return byteList;
    }

    public ByteList ConstantDoubleInfo(ByteList byteList, double d) {
        if (this.show_bytecode) {
            StringBuffer stringBuffer = new StringBuffer();
            ByteCodeFactory.IL_FormatDoubleAsString(d, stringBuffer);
            this.cpool_out.write(new StringBuffer().append("\n      ConstantDoubleInfo ").append(stringBuffer.toString()).toString());
        }
        byteList = ByteCodeFactory.Double(byteList, d);
        return byteList;
    }

    public ByteList ConstantDoubleInfo(double d) {
        return this.ConstantDoubleInfo(ByteCodeFactory.allocBytes(9), d);
    }

    public ByteList ConstantQualifiedName(ByteList byteList, int n, int n2, boolean bl) {
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantQualifiedName ").append(bl ? "@" : "").append(n).append(" ").append(n2).toString());
        }
        byteList = ByteCodeFactory.Byte(byteList, bl ? 13 : 7);
        byteList = ByteCodeFactory.Int(byteList, n2);
        byteList = ByteCodeFactory.Int(byteList, n);
        return byteList;
    }

    public ByteList ConstantQualifiedName(int n, int n2, boolean bl) {
        return this.ConstantQualifiedName(ByteCodeFactory.allocBytes(5), n, n2, bl);
    }

    public ByteList ConstantRuntimeQualifiedName(ByteList byteList, int n, boolean bl) {
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantRuntimeQualifiedName ").append(bl ? "@" : "").append(n).toString());
        }
        byteList = ByteCodeFactory.Byte(byteList, bl ? 16 : 15);
        byteList = ByteCodeFactory.Int(byteList, n);
        return byteList;
    }

    public ByteList ConstantRuntimeQualifiedName(int n, boolean bl) {
        return this.ConstantRuntimeQualifiedName(ByteCodeFactory.allocBytes(3), n, bl);
    }

    public ByteList ConstantRuntimeQualifiedLate(ByteList byteList, boolean bl) {
        if (this.show_bytecode) {
            this.cpool_out.write(new StringBuffer().append("\n      ConstantRuntimeQualifiedLate ").append(bl ? "@" : "").toString());
        }
        byteList = ByteCodeFactory.Byte(byteList, bl ? 18 : 17);
        return byteList;
    }

    public ByteList ConstantRuntimeQualifiedLate(boolean bl) {
        return this.ConstantRuntimeQualifiedLate(ByteCodeFactory.allocBytes(1), bl);
    }

    public static ByteList ConstantPool(ByteList byteList, ObjectList<ByteList> objectList) {
        for (ByteList byteList2 : objectList) {
            byteList.addAll(byteList2);
        }
        return byteList;
    }

    public static ByteList Namespaces(ByteList byteList, IntList intList) {
        for (int i = 0; i < intList.size(); ++i) {
            byteList = ByteCodeFactory.Int(byteList, intList.get(i));
        }
        return byteList;
    }

    public static ByteList Interfaces(ByteList byteList, IntList intList) {
        int n = intList.size();
        for (int i = 0; i < n; ++i) {
            byteList = ByteCodeFactory.Int(byteList, intList.get(i));
        }
        return byteList;
    }

    public ByteList TraitInfo(ByteList byteList, int n, int n2, int n3, int n4, int n5, byte by, IntList intList) {
        if (this.show_bytecode) {
            switch (n2) {
                case 0: {
                    this.defns_out.write(new StringBuffer().append("\n      *Trait name_index=").append(n).append(" tag=var").append(" slot_id=").append(n3).append(" type_index=").append(n4).append(" value=").append(n5).append(" value_kind=").append(by).toString());
                    break;
                }
                case 6: {
                    this.defns_out.write(new StringBuffer().append("\n      *Trait name_index=").append(n).append(" tag=const").append(" slot_id=").append(n3).append(" type_index=").append(n4).append(" value=").append(n5).append(" value_kind=").append(by).toString());
                    break;
                }
                case 1: {
                    this.defns_out.write(new StringBuffer().append("\n      *Trait name_index=").append(n).append(" tag=method").append(" disp_id=").append(n3).append(" method_info=").append(n4).append((n5 & 1) != 0 ? " final" : " virtual").append((n5 & 2) != 0 ? " override" : " new").toString());
                    break;
                }
                case 2: {
                    this.defns_out.write(new StringBuffer().append("\n      *Trait name_index=").append(n).append(" tag=getter").append(" disp_id=").append(n3).append(" method_info=").append(n4).append((n5 & 1) != 0 ? " final" : " virtual").append((n5 & 2) != 0 ? " override" : " new").toString());
                    break;
                }
                case 3: {
                    this.defns_out.write(new StringBuffer().append("\n      *Trait name_index=").append(n).append(" tag=setter").append(" disp_id=").append(n3).append(" method_info=").append(n4).append((n5 & 1) != 0 ? " final" : " virtual").append((n5 & 2) != 0 ? " override" : " new").toString());
                    break;
                }
                case 5: {
                    this.defns_out.write(new StringBuffer().append("\n      *Trait name_index=").append(n).append(" tag=function").append(" slot_id=").append(n3).append(" method_info=").append(n4).toString());
                    break;
                }
                case 4: {
                    this.defns_out.write(new StringBuffer().append("\n      *Trait name_index=").append(n).append(" tag=class").append(" slot_id=").append(n3).append(" class_info=").append(n4).toString());
                }
            }
        }
        int n6 = n2;
        if (intList != null) {
            n6 |= 0x40;
        }
        if (n2 == 1 || n2 == 2 || n2 == 3) {
            n6 |= n5 << 4;
        }
        byteList = ByteCodeFactory.Int(byteList, n);
        byteList = ByteCodeFactory.Byte(byteList, n6);
        switch (n2) {
            case 0: 
            case 6: {
                byteList = ByteCodeFactory.Int(byteList, n3);
                byteList = ByteCodeFactory.Int(byteList, n4);
                byteList = ByteCodeFactory.Int(byteList, n5);
                if (n5 == 0) break;
                byteList = ByteCodeFactory.Byte(byteList, by);
                break;
            }
            case 4: 
            case 5: {
                byteList = ByteCodeFactory.Int(byteList, n3);
                byteList = ByteCodeFactory.Int(byteList, n4);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                byteList = ByteCodeFactory.Int(byteList, n3);
                byteList = ByteCodeFactory.Int(byteList, n4);
                break;
            }
        }
        if (intList != null) {
            int n7 = intList.size();
            byteList = ByteCodeFactory.Int(byteList, n7);
            for (int i = 0; i < n7; ++i) {
                byteList = ByteCodeFactory.Int(byteList, intList.get(i));
            }
        }
        return byteList;
    }

    public static ByteList Traits(ByteList byteList, ObjectList<ByteList> objectList) {
        for (ByteList byteList2 : objectList) {
            byteList.addAll(byteList2);
        }
        return byteList;
    }

    public ByteList VarInfo(ByteList byteList, int n, int n2, int n3, int n4) {
        if (this.show_bytecode) {
            this.defns_out.write(new StringBuffer().append("\n      VarInfo type_index=").append(n).append(" value_index=").append(n2).append(" slot_index=").append(n3).append(" -> ").append(n4).toString());
        }
        byteList = ByteCodeFactory.Int(byteList, n3);
        byteList = ByteCodeFactory.Int(byteList, n);
        byteList = ByteCodeFactory.Int(byteList, n2);
        return byteList;
    }

    public static ByteList Vars(ByteList byteList, ObjectList<ByteList> objectList) {
        for (ByteList byteList2 : objectList) {
            byteList.addAll(byteList2);
        }
        return byteList;
    }

    public static ByteList Methods(ByteList byteList, ObjectList<ByteList> objectList) {
        for (ByteList byteList2 : objectList) {
            byteList.addAll(byteList2);
        }
        return byteList;
    }

    public static ByteList Metadata(ByteList byteList, ObjectList<ByteList> objectList) {
        for (ByteList byteList2 : objectList) {
            byteList.addAll(byteList2);
        }
        return byteList;
    }

    public static ByteList Bodies(ByteList byteList, ObjectList<ByteList> objectList) {
        for (ByteList byteList2 : objectList) {
            byteList.addAll(byteList2);
        }
        return byteList;
    }

    public ByteList InstanceInfo(ByteList byteList, int n, int n2, int n3, int n4, int n5, IntList intList, int n6, ObjectList<ByteList> objectList, int n7) {
        if (this.show_bytecode) {
            this.defns_out.write(new StringBuffer().append("\n      InstanceInfo name_index=").append(n).append(" base_index=").append(n2).append(" interfaces_count=").append(n5).append(" interfaces={").toString());
            for (int i = 0; i < intList.size(); ++i) {
                this.defns_out.write(new StringBuffer().append(" ").append(intList.get(i)).toString());
            }
            this.defns_out.write(new StringBuffer().append("} flags=").append(n3).append(" iinit_index=").append(n6).append(" itraits_count=").append(objectList.size()).append(" -> ").append(n7).toString());
        }
        byteList = ByteCodeFactory.Int(byteList, n);
        byteList = ByteCodeFactory.Int(byteList, n2);
        byteList = ByteCodeFactory.Byte(byteList, n3);
        if (n4 != 0) {
            byteList = ByteCodeFactory.Int(byteList, n4);
        }
        byteList = ByteCodeFactory.Int(byteList, n5);
        byteList = ByteCodeFactory.Interfaces(byteList, intList);
        byteList = ByteCodeFactory.Int(byteList, n6);
        byteList = ByteCodeFactory.Int(byteList, objectList.size());
        byteList = ByteCodeFactory.Traits(byteList, objectList);
        return byteList;
    }

    public ByteList ClassInfo(ByteList byteList, int n, ObjectList<ByteList> objectList, int n2) {
        if (this.show_bytecode) {
            this.defns_out.write(new StringBuffer().append("\n      ClassInfo  cinit_index=").append(n).append(" ctraits_count=").append(objectList.size()).append(" -> ").append(n2).toString());
        }
        byteList = ByteCodeFactory.Int(byteList, n);
        byteList = ByteCodeFactory.Int(byteList, objectList.size());
        byteList = ByteCodeFactory.Traits(byteList, objectList);
        return byteList;
    }

    public ByteList ScriptInfo(ByteList byteList, int n, ObjectList<ByteList> objectList, int n2) {
        if (this.show_bytecode) {
            this.defns_out.write(new StringBuffer().append("\n      ScriptInfo init_index=").append(n).append(" traits_count=").append(objectList.size()).append(" -> ").append(n2).toString());
        }
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Int(byteList, objectList.size());
        ByteCodeFactory.Traits(byteList, objectList);
        return byteList;
    }

    public static ByteList Classes(ByteList byteList, ObjectList<ByteList> objectList) {
        for (ByteList byteList2 : objectList) {
            byteList.addAll(byteList2);
        }
        return byteList;
    }

    public static ByteList Instances(ByteList byteList, ObjectList<ByteList> objectList) {
        for (ByteList byteList2 : objectList) {
            byteList.addAll(byteList2);
        }
        return byteList;
    }

    public static ByteList Packages(ByteList byteList, ObjectList<ByteList> objectList) {
        for (ByteList byteList2 : objectList) {
            byteList.addAll(byteList2);
        }
        return byteList;
    }

    public static ByteList Attributes(ByteList byteList, ObjectList<ByteList> objectList) {
        for (ByteList byteList2 : objectList) {
            byteList.addAll(byteList2);
        }
        return byteList;
    }

    public ByteList MethodInfo(ByteList byteList, int n, int n2, IntList intList, IntList intList2, ByteList byteList2, IntList intList3, int n3, int n4, int n5) {
        int n6;
        int n7;
        if (this.show_bytecode) {
            this.defns_out.write("\n      MethodInfo ");
            this.defns_out.write(new StringBuffer().append(" param_count=").append(n).toString());
            this.defns_out.write(new StringBuffer().append(" return_type=").append(n2).append(" param_types={ ").toString());
            int n8 = n7 = intList == null ? 0 : intList.size();
            for (n6 = 0; n6 < n7; ++n6) {
                this.defns_out.write(new StringBuffer().append(intList.get(n6)).append(" ").toString());
            }
            this.defns_out.write(new StringBuffer().append("} debug_name_index=").append(n3).append(" needs_arguments=").append((n4 & 1) != 0 ? "true" : "false").append(" need_rest=").append((n4 & 4) != 0 ? "true" : "false").append(" needs_activation=").append((n4 & 2) != 0 ? "true" : "false").append(" has_optional=").append((n4 & 8) != 0 ? "true" : "false").append(" ignore_rest=").append((n4 & 0x10) != 0 ? "true" : "false").append(" native=").append((n4 & 0x20) != 0 ? "true" : "false").append(" has_param_names =").append((n4 & 0x80) != 0 ? "true" : "false").toString());
            if ((n4 & 8) != 0) {
                this.defns_out.write(new StringBuffer().append(" optional_count=").append(intList2.size()).toString());
                this.defns_out.write(" optional_indexes={ ");
                int n9 = n7 = intList2 == null ? 0 : intList2.size();
                for (n6 = 0; n6 < n7; ++n6) {
                    this.defns_out.write(new StringBuffer().append(" ").append(intList2.get(n6)).toString());
                }
                this.defns_out.write(" }");
                this.defns_out.write(" optional_kinds={ ");
                int n10 = n7 = intList2 == null ? 0 : intList2.size();
                for (n6 = 0; n6 < n7; ++n6) {
                    this.defns_out.write(new StringBuffer().append(" ").append(byteList2.get(n6)).toString());
                }
                this.defns_out.write(" }");
            }
            if ((n4 & 0x80) != 0) {
                this.defns_out.write(" param_names={ ");
                int n11 = n7 = intList3 == null ? 0 : intList3.size();
                for (n6 = 0; n6 < n7; ++n6) {
                    this.defns_out.write(new StringBuffer().append(" ").append(intList3.get(n6)).toString());
                }
                this.defns_out.write(" }");
            }
            this.defns_out.write(new StringBuffer().append(" -> ").append(n5).toString());
        }
        if (debug) {
            System.out.print(new StringBuffer().append("\n      bytes.size() = ").append(byteList.size()).toString());
        }
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Int(byteList, n2);
        for (n6 = 0; n6 < n; ++n6) {
            ByteCodeFactory.Int(byteList, intList.get(n6));
        }
        ByteCodeFactory.Int(byteList, n3);
        ByteCodeFactory.Byte(byteList, n4);
        if ((n4 & 8) != 0) {
            ByteCodeFactory.Int(byteList, intList2.size());
            n7 = intList2.size();
            for (n6 = 0; n6 < n7; ++n6) {
                ByteCodeFactory.Int(byteList, intList2.get(n6));
                byteList.add(byteList2.get(n6));
            }
        }
        if ((n4 & 0x80) != 0) {
            for (n6 = 0; n6 < n; ++n6) {
                ByteCodeFactory.Int(byteList, intList3.get(n6));
            }
        }
        return byteList;
    }

    public ByteList MethodBody(ByteList byteList, int n, int n2, int n3, int n4, int n5, ByteList byteList2, int n6, ByteList byteList3, ObjectList<ByteList> objectList, int n7) {
        if (this.show_bytecode) {
            this.defns_out.write(new StringBuffer().append("\n      MethodBody max_stack=").append(n).toString());
            this.defns_out.write(new StringBuffer().append(" max_locals=").append(n2).toString());
            this.defns_out.write(new StringBuffer().append(" scope_depth=").append(n3).append(" max_scope=").append(n4).toString());
            this.defns_out.write(new StringBuffer().append(" code_length=").append(n5).append(" traits_count=").append(objectList.size()).append(" -> ").append(n7).toString());
        }
        if (debug) {
            System.out.print(new StringBuffer().append("\n      bytes.size() = ").append(byteList.size()).append(", code.size() = ").append(byteList2.size()).toString());
        }
        ByteCodeFactory.Int(byteList, n7);
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Int(byteList, n2);
        ByteCodeFactory.Int(byteList, n3);
        ByteCodeFactory.Int(byteList, n4);
        ByteCodeFactory.Int(byteList, n5);
        if (n5 != 0) {
            byteList.addAll(byteList2);
        }
        ByteCodeFactory.Int(byteList, n6);
        if (n6 != 0) {
            byteList.addAll(byteList3);
        }
        ByteCodeFactory.Int(byteList, objectList.size());
        ByteCodeFactory.Traits(byteList, objectList);
        return byteList;
    }

    public ByteList MetadataInfo(ByteList byteList, int n, int n2, IntList intList, IntList intList2, int n3) {
        int n4;
        if (this.show_bytecode) {
            this.defns_out.write("\n      MetadataInfo ");
            this.defns_out.write(new StringBuffer().append(" nameIndex=").append(n).toString());
            this.defns_out.write(new StringBuffer().append(" valuesCount=").append(n2).append(" keys={ ").toString());
            int n5 = intList.size();
            for (n4 = 0; n4 < n5; ++n4) {
                this.defns_out.write(new StringBuffer().append(intList.get(n4)).append(" ").toString());
            }
            this.defns_out.write("} values={");
            n5 = intList2.size();
            for (n4 = 0; n4 < n5; ++n4) {
                this.defns_out.write(new StringBuffer().append(intList2.get(n4)).append(" ").toString());
            }
            this.defns_out.write(" }");
            this.defns_out.write(new StringBuffer().append(" -> ").append(n3).toString());
        }
        if (debug) {
            System.out.print(new StringBuffer().append("\n      bytes.size() = ").append(byteList.size()).toString());
        }
        ByteCodeFactory.Int(byteList, n);
        ByteCodeFactory.Int(byteList, n2);
        for (n4 = 0; n4 < n2; ++n4) {
            ByteCodeFactory.Int(byteList, intList.get(n4));
        }
        for (n4 = 0; n4 < n2; ++n4) {
            ByteCodeFactory.Int(byteList, intList2.get(n4));
        }
        return byteList;
    }

    public ByteList ActionBlock(ByteList byteList, int n, int n2, int n3, ObjectList<ByteList> objectList, int n4, ObjectList<ByteList> objectList2, int n5, ObjectList<ByteList> objectList3, int n6, ObjectList<ByteList> objectList4, int n7, ObjectList<ByteList> objectList5, int n8, ObjectList<ByteList> objectList6, int n9, ObjectList<ByteList> objectList7, int n10, ObjectList<ByteList> objectList8, int n11, ObjectList<ByteList> objectList9, int n12, ObjectList<ByteList> objectList10, ObjectList<ByteList> objectList11, int n13, ObjectList<ByteList> objectList12, int n14, ObjectList<ByteList> objectList13) {
        if (this.show_bytecode) {
            this.defns_out.write(new StringBuffer().append("\n      ActionBlock major_version=").append(n2).append(" minor_version=").append(n).append(" constant_int_count= ").append(n3).append(" constant_uint_count=: ").append(n4).append(" constant_double_count= ").append(n5).append(" constant_utf8_count=").append(n6).append(" constant_namespace_count=").append(n9).append(" constant_namespaceset_count=").append(n8).append(" constant_multiname_count=").append(n7).append(" methods_count=").append(n10).append(" metadata_count=").append(n11).append(" classes_count=").append(n12).append(" scripts_count=").append(n13).append(" bodies_count=").append(n14).toString());
        }
        ByteCodeFactory.RealShort(byteList, n);
        ByteCodeFactory.RealShort(byteList, n2);
        ByteCodeFactory.Int(byteList, n3);
        if (n3 != 0) {
            byteList = ByteCodeFactory.ConstantPool(byteList, objectList);
        }
        ByteCodeFactory.Int(byteList, n4);
        if (n4 != 0) {
            byteList = ByteCodeFactory.ConstantPool(byteList, objectList2);
        }
        ByteCodeFactory.Int(byteList, n5);
        if (n5 != 0) {
            byteList = ByteCodeFactory.ConstantPool(byteList, objectList3);
        }
        ByteCodeFactory.Int(byteList, n6);
        if (n6 != 0) {
            byteList = ByteCodeFactory.ConstantPool(byteList, objectList4);
        }
        ByteCodeFactory.Int(byteList, n9);
        if (n9 != 0) {
            byteList = ByteCodeFactory.ConstantPool(byteList, objectList7);
        }
        ByteCodeFactory.Int(byteList, n8);
        if (n8 != 0) {
            byteList = ByteCodeFactory.ConstantPool(byteList, objectList6);
        }
        ByteCodeFactory.Int(byteList, n7);
        if (n7 != 0) {
            byteList = ByteCodeFactory.ConstantPool(byteList, objectList5);
        }
        ByteCodeFactory.Int(byteList, n10);
        if (n10 != 0) {
            byteList = ByteCodeFactory.Methods(byteList, objectList8);
        }
        ByteCodeFactory.Int(byteList, n11);
        if (n11 != 0) {
            byteList = ByteCodeFactory.Metadata(byteList, objectList9);
        }
        ByteCodeFactory.Int(byteList, n12);
        if (n12 != 0) {
            byteList = ByteCodeFactory.Instances(byteList, objectList10);
            byteList = ByteCodeFactory.Classes(byteList, objectList11);
        }
        ByteCodeFactory.Int(byteList, n13);
        if (n13 != 0) {
            byteList = ByteCodeFactory.Packages(byteList, objectList12);
        }
        ByteCodeFactory.Int(byteList, n14);
        if (n14 != 0) {
            byteList = ByteCodeFactory.Bodies(byteList, objectList13);
        }
        return byteList;
    }

    public static ByteList Byte(ByteList byteList, int n) {
        byteList.add((byte)n);
        return byteList;
    }

    public static ByteList RealShort(ByteList byteList, int n) {
        byteList.add((byte)n);
        byteList.add((byte)(n >> 8));
        return byteList;
    }

    public static ByteList Int24(ByteList byteList, int n) {
        byte by = (byte)n;
        byte by2 = (byte)(n >> 8);
        byte by3 = (byte)(n >> 16);
        byteList.add(by);
        byteList.add(by2);
        byteList.add(by3);
        return byteList;
    }

    public static ByteList Int(ByteList byteList, long l) {
        if (l < 128L && l > -1L) {
            byteList.add((byte)l);
        } else if (l < 16384L && l > -1L) {
            byteList.add((byte)(l & 0x7FL | 0x80L));
            byteList.add((byte)(l >> 7 & 0x7FL));
        } else if (l < 0x200000L && l > -1L) {
            byteList.add((byte)(l & 0x7FL | 0x80L));
            byteList.add((byte)(l >> 7 | 0x80L));
            byteList.add((byte)(l >> 14 & 0x7FL));
        } else if (l < 0x10000000L && l > -1L) {
            byteList.add((byte)(l & 0x7FL | 0x80L));
            byteList.add((byte)(l >> 7 | 0x80L));
            byteList.add((byte)(l >> 14 | 0x80L));
            byteList.add((byte)(l >> 21 & 0x7FL));
        } else {
            byteList.add((byte)(l & 0x7FL | 0x80L));
            byteList.add((byte)(l >> 7 | 0x80L));
            byteList.add((byte)(l >> 14 | 0x80L));
            byteList.add((byte)(l >> 21 | 0x80L));
            byteList.add((byte)(l >> 28 & 0xFL));
        }
        return byteList;
    }

    public static ByteList Double(ByteList byteList, double d) {
        long l = Double.doubleToLongBits(d);
        byteList.add((byte)l);
        byteList.add((byte)(l >> 8));
        byteList.add((byte)(l >> 16));
        byteList.add((byte)(l >> 24));
        byteList.add((byte)(l >> 32));
        byteList.add((byte)(l >> 40));
        byteList.add((byte)(l >> 48));
        byteList.add((byte)(l >> 56));
        return byteList;
    }

    public static StringBuffer IL_FormatDoubleAsString(double d, StringBuffer stringBuffer) {
        if (d == 0.0) {
            return stringBuffer.append("0.0");
        }
        if (d == Double.POSITIVE_INFINITY) {
            return stringBuffer.append("Infinity");
        }
        if (d == Double.NEGATIVE_INFINITY) {
            return stringBuffer.append("-Infinity");
        }
        if (Double.isNaN(d)) {
            return stringBuffer.append("NaN");
        }
        if (d == (double)((int)d)) {
            return stringBuffer.append((int)d);
        }
        boolean bl = false;
        if (d < 0.0) {
            d = 0.0 - d;
            bl = true;
        }
        int n = 0;
        if (d >= 1.0) {
            while (d > 10.0) {
                d /= 10.0;
                ++n;
            }
            int n2 = (int)d;
            stringBuffer.append(bl ? "-" : "+").append(n2).append(".");
            for (int i = 0; i < 5; ++i) {
                d -= (double)n2;
                n2 = (int)(d *= 10.0);
                stringBuffer.append(n2);
            }
            if (n > 0) {
                stringBuffer.append("e").append(n);
            }
            return stringBuffer;
        }
        while (d < 1.0) {
            d *= 10.0;
            ++n;
        }
        int n3 = (int)d;
        stringBuffer.append(bl ? "-" : "+").append(n3).append(".");
        for (int i = 0; i < 5; ++i) {
            d -= (double)n3;
            n3 = (int)(d *= 10.0);
            stringBuffer.append(n3);
        }
        return stringBuffer.append("e-").append(n);
    }
}

