/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.semantics;

import macromedia.asc.embedding.ErrorConstants;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.Slot;
import macromedia.asc.semantics.TypeInfo;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.BitSet;
import macromedia.asc.util.Context;
import macromedia.asc.util.Namespaces;
import macromedia.asc.util.ObjectList;

public final class ReferenceValue
extends Value
implements ErrorConstants {
    private ObjectValue base;
    private int get_slot_index;
    private int set_method_slot_index;
    private BitSet ud_bits;
    private TypeInfo type;
    private int src_position;
    public Slot slot;
    public String name;
    public Namespaces namespaces;
    public boolean is_nullable = true;
    public boolean has_nullable_anno = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void setPosition(int n) {
        this.src_position = n - 1;
    }

    public int getPosition() {
        return this.src_position;
    }

    public ReferenceValue(Context context, ObjectValue objectValue, String string, ObjectValue objectValue2) {
        this(context, objectValue, string, objectValue2, -78);
    }

    public ReferenceValue(Context context, ObjectValue objectValue, String string, ObjectValue objectValue2, int n) {
        this.setKind(n);
        this.base = objectValue;
        if (!$assertionsDisabled && string.intern() != string) {
            throw new Error();
        }
        this.name = string;
        this.setQualified(objectValue2 != null);
        this.setGetSlotIndex(-1);
        this.setSetSlotIndex(-1);
        this.setScopeIndex(-1);
        this.namespaces = context.statics.internNamespaces.intern(objectValue2);
    }

    public ReferenceValue(Context context, ObjectValue objectValue, String string, Namespaces namespaces) {
        this(context, objectValue, string, namespaces, -78);
    }

    public ReferenceValue(Context context, ObjectValue objectValue, String string, Namespaces namespaces, int n) {
        this.setKind(n);
        this.base = objectValue;
        if (!$assertionsDisabled && string.intern() != string) {
            throw new Error();
        }
        this.name = string;
        this.namespaces = context.statics.internNamespaces.intern(namespaces);
        this.slot = null;
        this.setGetSlotIndex(-1);
        this.setSetSlotIndex(-1);
        this.setScopeIndex(-1);
        this.ud_bits = null;
        this.type = null;
    }

    public void setIsAttributeIdentifier(boolean bl) {
        this.flags = bl ? this.flags | 0x10 : this.flags & 0xFFFFFFEF;
    }

    public boolean isAttributeIdentifier() {
        return (this.flags & 0x10) != 0;
    }

    public Value getValue(Context context) {
        Slot slot = this.getSlot(context, this.getKind());
        if (slot != null && slot.getMethodID() < 0) {
            return slot.getValue();
        }
        return null;
    }

    public TypeInfo getType(Context context) {
        return this.getType(context, this.getKind());
    }

    public TypeInfo getType(Context context, int n) {
        if (this.type == null) {
            TypeInfo typeInfo = null;
            TypeInfo typeInfo2 = context.getDefType(this.ud_bits);
            Slot slot = this.getSlot(context, n);
            if (slot != null) {
                typeInfo = slot.getType();
            }
            if (typeInfo == null) {
                typeInfo = context.noType().getDefaultTypeInfo();
            }
            this.type = typeInfo.getTypeValue().includes(context, typeInfo2 != null ? typeInfo2.getTypeValue() : null) ? (typeInfo.getTypeValue() == context.numberType() || typeInfo.getTypeValue() == context.noType() ? typeInfo : typeInfo2) : typeInfo;
            if (this.type == null) {
                this.type = context.noType().getDefaultTypeInfo();
            }
        }
        return this.type;
    }

    public Slot getSlot(Context context) {
        return this.getSlot(context, -78);
    }

    public Slot getSlot(Context context, int n) {
        if (this.slot == null) {
            if (this.isAttributeIdentifier()) {
                return null;
            }
            this.setKind(n == -98 ? -98 : -78);
            if (this.lookup(context, this.flags)) {
                if (n == this.getKind()) {
                    return this.slot;
                }
            } else if (n != -78) {
                return null;
            }
        }
        Slot slot = this.slot;
        if (this.getKind() != n) {
            ObjectValue objectValue;
            if (this.base != null) {
                objectValue = this.base;
            } else if (this.getScopeIndex() >= 0) {
                objectValue = (ObjectValue)context.getScopes().get(this.getScopeIndex());
            } else {
                return null;
            }
            switch (n) {
                case -98: {
                    this.slot = slot = objectValue.getSlot(context, this.getSetSlotIndex());
                    this.setKind(-98);
                    break;
                }
                case -78: {
                    this.slot = slot = objectValue.getSlot(context, this.getGetSlotIndex());
                    this.setKind(-78);
                    break;
                }
                default: {
                    this.slot = slot = objectValue.getSlot(context, this.getGetSlotIndex());
                    this.setKind(-78);
                    if (slot == null) break;
                    int n2 = slot.implies(context, n);
                    slot = objectValue.getSlot(context, n2);
                }
            }
        }
        return slot;
    }

    public boolean lookup(Context context, int n) {
        boolean bl = false;
        if (this.base == null) {
            ObjectList<ObjectValue> objectList = context.getScopes();
            int n2 = this.isTypeAnnotation() ? 0 : context.statics.withDepth + 1;
            for (int i = objectList.size() - 1; i >= n2; --i) {
                this.base = objectList.at(i);
                bl = this.lookupWithBase(context, n);
                if (!bl) continue;
                this.setScopeIndex(i);
                break;
            }
            this.base = null;
        } else {
            bl = this.lookupWithBase(context, n);
        }
        return bl;
    }

    public boolean lookupWithBase(Context context, int n) {
        if (!this.isQualified()) {
            return this.findUnqualified(context, n);
        }
        return this.findQualified(context, n);
    }

    public boolean findQualified(Context context, int n) {
        int n2 = this.namespaces.size();
        for (int i = 0; i < n2; ++i) {
            ObjectValue objectValue = (ObjectValue)this.namespaces.get(i);
            for (ObjectValue objectValue2 = this.base; objectValue2 != null; objectValue2 = objectValue2.proto()) {
                if (!objectValue2.hasName(context, this.getKind(), this.name, objectValue)) continue;
                this.bindToSlot(context, objectValue2, objectValue);
                return true;
            }
        }
        return false;
    }

    public boolean findUnqualified(Context context, int n) {
        Namespaces namespaces = null;
        for (ObjectValue objectValue = this.base; objectValue != null; objectValue = objectValue.proto()) {
            int n2;
            int n3;
            Namespaces namespaces2;
            namespaces = objectValue.hasNames(context, this.getKind(), this.name, this.namespaces);
            if (namespaces == null) continue;
            ObjectValue objectValue2 = null;
            boolean bl = false;
            if ((this.getKind() == -98 || this.getKind() == -78) && (namespaces2 = objectValue.hasNames(context, n3 = this.getKind() == -98 ? -78 : -98, this.name, this.namespaces)) != null) {
                objectValue2 = null;
                for (n2 = 0; n2 < namespaces2.size(); ++n2) {
                    objectValue2 = (ObjectValue)namespaces2.at(n2);
                    if (bl || namespaces.contains(objectValue2)) continue;
                    context.error(this.src_position, 1000, this.name);
                    bl = true;
                    break;
                }
            }
            n3 = 0;
            for (int i = 0; i < namespaces.size(); ++i) {
                objectValue2 = (ObjectValue)namespaces.at(i);
                n2 = objectValue.getSlotIndex(context, this.getKind(), this.name, objectValue2);
                Slot slot = objectValue.getSlot(context, n2);
                if (slot == null || slot.getBaseNode() != null) continue;
                if (n3 != 0 && n2 != n3 && !bl) {
                    context.error(this.src_position, 1000, this.name);
                    bl = true;
                }
                n3 = n2;
            }
            this.bindToSlot(context, objectValue, objectValue2);
            namespaces.clear();
            return true;
        }
        return false;
    }

    private void bindToSlot(Context context, ObjectValue objectValue, ObjectValue objectValue2) {
        boolean bl;
        int n = objectValue.getSlotIndex(context, -98, this.name, objectValue2);
        int n2 = objectValue.getSlotIndex(context, -78, this.name, objectValue2);
        int n3 = objectValue.getSlotIndex(context, -132, this.name, objectValue2);
        this.setGetSlotIndex(n2);
        if (n3 != -1) {
            this.setMethodSlotIndex(n3);
        } else {
            this.setSetSlotIndex(n);
        }
        this.slot = objectValue.getSlot(context, objectValue.getSlotIndex(context, this.getKind(), this.name, objectValue2));
        boolean bl2 = bl = this.slot != null && this.slot.declaredBy != null && this.slot.declaredBy.type != null && (this.slot.declaredBy.type.getTypeValue() == context.xmlType() || this.slot.declaredBy.type.getTypeValue() == context.xmlListType());
        if (context.useStaticSemantics() && !bl) {
            this.setQualifier(context, objectValue2);
        }
    }

    public void calcUseDefinitions(Context context, BitSet bitSet) {
        Slot slot;
        this.getSlot(context, -78);
        if (this.getGetSlotIndex() < 0) {
            return;
        }
        if (this.base != null && this.base.getType(context).getTypeValue() == context.noType() && this.getGetSlotIndex() >= 0) {
            slot = this.base.getSlot(context, this.getGetSlotIndex());
        } else if (this.getScopeIndex() == 0 && this.getGetSlotIndex() >= 0) {
            slot = context.globalScope().getSlot(context, this.getGetSlotIndex());
        } else if (this.getScopeIndex() == context.getScopes().size() - 1) {
            slot = context.scope().getSlot(context, this.getGetSlotIndex());
        } else {
            return;
        }
        if (slot != null) {
            this.ud_bits = BitSet.and(bitSet, slot.getDefBits());
        }
    }

    public boolean usedBeforeInitialized() {
        return BitSet.isEmpty(this.ud_bits);
    }

    public int getSlotIndex(int n) {
        if (n == -78) {
            return this.getGetSlotIndex();
        }
        if (n == -98) {
            return this.getSetSlotIndex();
        }
        if (n == -132) {
            return this.getMethodSlotIndex();
        }
        if (!$assertionsDisabled) {
            throw new Error();
        }
        return -1;
    }

    public int getScopeIndex(int n) {
        return this.getScopeIndex();
    }

    public ReferenceValue setBase(ObjectValue objectValue) {
        this.base = objectValue;
        return this;
    }

    public ObjectValue getBase() {
        return this.base;
    }

    public boolean isReference() {
        return true;
    }

    public void setQualifier(Context context, ObjectValue objectValue) {
        this.setQualified(objectValue != null);
        this.namespaces = context.statics.internNamespaces.intern(objectValue);
    }

    public String toMultiName() {
        return this.namespaces.toString() + "::" + this.name;
    }

    public boolean isQualified() {
        return (this.flags & 4) != 0;
    }

    private void setQualified(boolean bl) {
        this.flags = bl ? this.flags | 4 : this.flags & 0xFFFFFFFB;
    }

    public String toString() {
        return super.toString();
    }

    public void setImmutableNamespaces(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    public Namespaces getImmutableNamespaces() {
        return this.namespaces;
    }

    public void setScopeIndex(int n) {
        this.flags &= 0xFFFF;
        this.flags |= n << 16 & 0xFFFF0000;
    }

    public int getScopeIndex() {
        short s = (short)((this.flags & 0xFFFF0000) >> 16);
        return s;
    }

    public void setKind(int n) {
        this.flags &= 0xFFFF00FF;
        this.flags |= n << 8 & 0xFF00;
    }

    public int getKind() {
        byte by = (byte)((this.flags & 0xFF00) >> 8);
        return by;
    }

    private void setGetSlotIndex(int n) {
        this.get_slot_index = n;
    }

    private int getGetSlotIndex() {
        return this.get_slot_index;
    }

    private void setMethodSlotIndex(int n) {
        this.flags |= 2;
        this.set_method_slot_index = n;
    }

    private int getMethodSlotIndex() {
        return (this.flags & 2) != 0 ? this.set_method_slot_index : -1;
    }

    private void setSetSlotIndex(int n) {
        this.flags &= 0xFFFFFFFD;
        this.set_method_slot_index = n;
    }

    private int getSetSlotIndex() {
        return (this.flags & 2) != 0 ? -1 : this.set_method_slot_index;
    }

    public void setTypeAnnotation(boolean bl) {
        this.flags = bl ? this.flags | 0x20 : this.flags & 0xFFFFFFDF;
    }

    public boolean isTypeAnnotation() {
        return (this.flags & 0x20) != 0;
    }

    public void setNullableAnnotation(boolean bl, boolean bl2) {
        this.has_nullable_anno = bl;
        this.is_nullable = bl2;
    }

    public boolean isConfigRef() {
        return this.getImmutableNamespaces() != null && this.getImmutableNamespaces().size() == 1 && ((ObjectValue)this.getImmutableNamespaces().at(0)).isConfigNS();
    }

    static {
        $assertionsDisabled = true;
    }
}

