/*
 * Decompiled with CFR 0.152.
 */
package org.granite.messaging.service;

import org.granite.config.flex.Destination;
import org.granite.messaging.service.ServiceException;
import org.granite.messaging.service.ServiceExceptionHandler;
import org.granite.messaging.service.ServiceInvocationContext;

public abstract class AbstractServiceExceptionHandler
implements ServiceExceptionHandler {
    protected ServiceException getServiceException(ServiceInvocationContext context, Throwable e) {
        String method = context.getMethod() != null ? context.getMethod().toString() : "null";
        return this.getServiceException(context.getDestination(), method, e);
    }

    protected ServiceException getServiceException(Destination destination, String method, Throwable e) {
        if (e instanceof ServiceException) {
            return (ServiceException)e;
        }
        String detail = "\n- destination: " + (destination != null ? destination.getId() : "") + "\n" + "- method: " + method + "\n" + "- exception: " + e.toString() + "\n";
        return new ServiceException(String.valueOf(this.getClass().getSimpleName()) + ".Call.Failed", e.getMessage(), detail, e);
    }
}

