/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: CheckBoxItemRenderer.as 3560 2009-04-24 09:23:44Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.view {

    import flash.events.MouseEvent;
    import mx.controls.CheckBox;
    import mx.controls.DataGrid;
    import org.ow2.jasmine.jadort.client.flex.model.JadortModelLocator;
    import org.ow2.jasmine.jadort.client.flex.vo.*;

    public class CheckBoxItemRenderer extends CheckBox {

        [Bindable]
        public var model : JadortModelLocator = JadortModelLocator.getInstance();

        public function CheckBoxItemRenderer() {
            super();
            selected = false;
        }

        override public function get data() : Object {
            return super.data;
        }

        override public function set data(value : Object) : void {
            super.data = value;
            if (super.data.maintained) {
                selected = false;
                enabled = false;
            } else {
                if (model != null && model.selectedServers != null) {
                    selected = model.selectedServers.contains(data);
                } else {
                    selected = false;
                }
                enabled = true;
            }
        }

        private function columnHeaderClickHandler(event : MouseEvent) : void {
            if (super.data.maintained) {
                selected = false;
            } else {
                selected = event.target.selected;
            }
        }

        override protected function clickHandler(event : MouseEvent) : void {
            if (model != null && model.selectedServers != null) {
                super.clickHandler(event);
                if (selected) {
                    if (!model.selectedServers.contains(data)) {
                        model.selectedServers.addItem(data);
                    }
                } else {
                    if (model.selectedServers.contains(data)) {
                        model.selectedServers.removeItemAt(model.selectedServers.getItemIndex(data));
                    }
                }
                model.nextButtonEnabled = model.selectedServers.length > 0;
            }
        }
    }
}
