/**
 * JaDOrT: JASMINe Deployment Orchestration Tool
 * Copyright (C) 2008-2009 Bull S.A.S.
 * Copyright (C) 2008-2009 France Telecom R&D
 * Contact: jasmine@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 * USA
 *
 * --------------------------------------------------------------------------
 * $Id: ServerProgressVO.as 3495 2009-04-21 16:04:19Z alitokmen $
 * --------------------------------------------------------------------------
 */
package org.ow2.jasmine.jadort.client.flex.vo {

    import com.adobe.cairngorm.vo.IValueObject;

    [RemoteClass(alias = "org.ow2.jasmine.jadort.api.entities.deployment.ServerProgressBean")]
    [Bindable]
    public class ServerProgressVO implements IValueObject {

        private var serverProgressServer : ServerVO;
        private var serverProgressState : String;
        private var serverProgressLog : String;
        private var serverProgressProgress : Number;
        private var serverProgressVmImage : VMImageVO;

        public function ServerProgressVO() {
            super();
        }

        public function get server() : ServerVO {
            return serverProgressServer;
        }

        public function get name() : String {
            return serverProgressServer.name;
        }

        public function get state() : String {
            return serverProgressState;
        }

        public function get log() : String {
            return serverProgressLog;
        }

        public function get progress() : Number {
            return serverProgressProgress;
        }

        public function get activeSessions() : Number {
            return serverProgressServer.activeSessions;
        }

        public function get vmImage() : VMImageVO {
            return serverProgressVmImage;
        }

        public function set server(serverProgressServer : ServerVO) : void {
            this.serverProgressServer = serverProgressServer;
        }

        public function set state(serverProgressState : String) : void {
            this.serverProgressState = serverProgressState;
        }

        public function set log(serverProgressLog : String) : void {
            this.serverProgressLog = serverProgressLog;
        }

        public function set progress(serverProgressProgress : Number) : void {
            this.serverProgressProgress = serverProgressProgress;
        }

        public function set vmImage(serverProgressVmImage : VMImageVO) : void {
            this.serverProgressVmImage = serverProgressVmImage;
        }
    }
}
