/*
 * Decompiled with CFR 0.152.
 */
package org.granite.config.flex;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.granite.util.JDOMUtil;
import org.jdom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Adapter {
    private final String id;
    private final String className;
    private final Map<String, Serializable> properties;

    public Adapter(String id, String className, Map<String, Serializable> properties) {
        this.id = id;
        this.className = className;
        this.properties = Collections.unmodifiableMap(properties);
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    public static Adapter forElement(Element element) {
        JDOMUtil.checkElement(element, "adapter-definition", "id", "class");
        String id = element.getAttributeValue("id");
        String className = element.getAttributeValue("class");
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        Element propertiesElt = element.getChild("properties");
        if (propertiesElt != null) {
            for (Element property : JDOMUtil.getChildren(propertiesElt)) {
                properties.put(property.getName(), (Serializable)((Object)property.getText()));
            }
        }
        return new Adapter(id, className, properties);
    }
}

