/*
 * Decompiled with CFR 0.152.
 */
package org.granite.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.granite.util.AtomicConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NumberUtil {
    public static final AtomicConverter<Long> LONG_CONVERTER = new AtomicConverter<Long>(){

        @Override
        public Long convert(Object number) {
            return number instanceof Number ? Long.valueOf(((Number)number).longValue()) : null;
        }
    };
    public static final AtomicConverter<Integer> INTEGER_CONVERTER = new AtomicConverter<Integer>(){

        @Override
        public Integer convert(Object number) {
            return number instanceof Number ? Integer.valueOf(((Number)number).intValue()) : null;
        }
    };
    public static final AtomicConverter<Double> DOUBLE_CONVERTER = new AtomicConverter<Double>(){

        @Override
        public Double convert(Object number) {
            return number instanceof Number ? Double.valueOf(((Number)number).doubleValue()) : null;
        }
    };
    public static final AtomicConverter<Float> FLOAT_CONVERTER = new AtomicConverter<Float>(){

        @Override
        public Float convert(Object number) {
            return number instanceof Number ? Float.valueOf(((Number)number).floatValue()) : null;
        }
    };
    public static final AtomicConverter<Short> SHORT_CONVERTER = new AtomicConverter<Short>(){

        @Override
        public Short convert(Object number) {
            return number instanceof Number ? Short.valueOf(((Number)number).shortValue()) : null;
        }
    };
    public static final AtomicConverter<Byte> BYTE_CONVERTER = new AtomicConverter<Byte>(){

        @Override
        public Byte convert(Object number) {
            return number instanceof Number ? Byte.valueOf(((Number)number).byteValue()) : null;
        }
    };
    public static final AtomicConverter<BigDecimal> BIGDECIMAL_CONVERTER = new AtomicConverter<BigDecimal>(){

        @Override
        public BigDecimal convert(Object number) {
            return number instanceof Number ? BigDecimal.valueOf(((Number)number).doubleValue()) : null;
        }
    };
    public static final AtomicConverter<BigInteger> BIGINTEGER_CONVERTER = new AtomicConverter<BigInteger>(){

        @Override
        public BigInteger convert(Object number) {
            return number instanceof Number ? BigInteger.valueOf(((Number)number).longValue()) : null;
        }
    };

    public static boolean isNumericType(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz) || clazz == Integer.TYPE || clazz == Double.TYPE || clazz == Long.TYPE || clazz == Byte.TYPE || clazz == Float.TYPE || clazz == Short.TYPE;
    }

    public static AtomicConverter<?> getNumberConverter(Class<?> targetClass) {
        if (targetClass == Long.class || targetClass == Long.TYPE) {
            return LONG_CONVERTER;
        }
        if (targetClass == Integer.class || targetClass == Integer.TYPE) {
            return INTEGER_CONVERTER;
        }
        if (targetClass == Double.class || targetClass == Double.TYPE) {
            return DOUBLE_CONVERTER;
        }
        if (targetClass == Float.class || targetClass == Float.TYPE) {
            return FLOAT_CONVERTER;
        }
        if (targetClass == Short.class || targetClass == Short.TYPE) {
            return SHORT_CONVERTER;
        }
        if (targetClass == Byte.class || targetClass == Byte.TYPE) {
            return BYTE_CONVERTER;
        }
        if (targetClass == BigDecimal.class) {
            return BIGDECIMAL_CONVERTER;
        }
        if (targetClass == BigInteger.class) {
            return BIGINTEGER_CONVERTER;
        }
        return null;
    }

    public static Object convert(Class<?> targetClass, Object value) {
        AtomicConverter<?> converter = NumberUtil.getNumberConverter(targetClass);
        if (converter != null) {
            value = converter.convert(value);
        }
        return value;
    }
}

