/*
 * Decompiled with CFR 0.152.
 */
package macromedia.abc;

import java.io.FileOutputStream;
import java.io.IOException;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.ConstantPool;
import macromedia.abc.Decoder;
import macromedia.abc.Encoder;
import macromedia.asc.util.ByteList;

public class Optimizer {
    public static void main(String[] stringArray) {
        BytecodeBuffer[] bytecodeBufferArray = new BytecodeBuffer[stringArray.length];
        String string = "merged.abc";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-o")) {
                string = stringArray[++i];
                continue;
            }
            try {
                BytecodeBuffer bytecodeBuffer;
                bytecodeBufferArray[i] = bytecodeBuffer = new BytecodeBuffer(stringArray[i]);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        byte[] byArray = Optimizer.optimize(bytecodeBufferArray);
        try {
            if (byArray != null) {
                new FileOutputStream(string).write(byArray);
            } else {
                System.err.println("Error occurred when merging abc files.");
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static ByteList optimize(ByteList byteList) {
        BytecodeBuffer[] bytecodeBufferArray = new BytecodeBuffer[]{new BytecodeBuffer(byteList.toByteArray())};
        byte[] byArray = Optimizer.optimize(bytecodeBufferArray);
        ByteList byteList2 = new ByteList(byArray.length);
        byteList2.addAll(byArray);
        return byteList2;
    }

    public static byte[] optimize(BytecodeBuffer[] bytecodeBufferArray) {
        int n;
        Object object;
        int n2;
        int n3 = bytecodeBufferArray.length;
        Decoder[] decoderArray = new Decoder[n3];
        ConstantPool[] constantPoolArray = new ConstantPool[n3];
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        for (int i = 0; i < n3; ++i) {
            try {
                decoderArray[i] = new Decoder(bytecodeBufferArray[i]);
                n4 = decoderArray[i].majorVersion;
                n5 = decoderArray[i].minorVersion;
                constantPoolArray[i] = decoderArray[i].constantPool;
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                bl = true;
                break;
            }
        }
        Encoder encoder = new Encoder(n4, n5);
        encoder.enablePeepHole();
        Decoder decoder = null;
        try {
            encoder.addConstantPools(constantPoolArray);
            encoder.disableDebugging();
            encoder.removeMetadata();
            encoder.configure(decoderArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            decoder = decoderArray[n2];
            encoder.useConstantPool(n2);
            object = decoder.methodInfo;
            try {
                n = ((Decoder.MethodInfo)object).size();
                for (int i = 0; i < n; ++i) {
                    ((Decoder.MethodInfo)object).decode(i, encoder);
                }
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                bl = true;
                break;
            }
        }
        if (bl) {
            return null;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            decoder = decoderArray[n2];
            encoder.useConstantPool(n2);
            object = decoder.metadataInfo;
            try {
                n = ((Decoder.MetaDataInfo)object).size();
                for (int i = 0; i < n; ++i) {
                    ((Decoder.MetaDataInfo)object).decode(i, encoder);
                }
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                bl = true;
                break;
            }
        }
        if (bl) {
            return null;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            decoder = decoderArray[n2];
            encoder.useConstantPool(n2);
            object = decoder.classInfo;
            try {
                n = ((Decoder.ClassInfo)object).size();
                for (int i = 0; i < n; ++i) {
                    ((Decoder.ClassInfo)object).decodeInstance(i, encoder);
                }
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                bl = true;
                break;
            }
        }
        if (bl) {
            return null;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            decoder = decoderArray[n2];
            encoder.useConstantPool(n2);
            object = decoder.classInfo;
            try {
                n = ((Decoder.ClassInfo)object).size();
                for (int i = 0; i < n; ++i) {
                    ((Decoder.ClassInfo)object).decodeClass(i, 0, encoder);
                }
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                bl = true;
                break;
            }
        }
        if (bl) {
            return null;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            decoder = decoderArray[n2];
            encoder.useConstantPool(n2);
            object = decoder.scriptInfo;
            try {
                n = ((Decoder.ScriptInfo)object).size();
                for (int i = 0; i < n; ++i) {
                    ((Decoder.ScriptInfo)object).decode(i, encoder);
                }
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                bl = true;
                break;
            }
        }
        if (bl) {
            return null;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            decoder = decoderArray[n2];
            encoder.useConstantPool(n2);
            object = decoder.methodBodies;
            try {
                n = ((Decoder.MethodBodies)object).size();
                for (int i = 0; i < n; ++i) {
                    ((Decoder.MethodBodies)object).decode(i, 2, encoder);
                }
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                bl = true;
                break;
            }
        }
        if (bl) {
            return null;
        }
        byte[] byArray = encoder.toABC();
        return byArray;
    }
}

