/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.swf.tools.as3.EvaluatorAdapter;
import flash.util.Trace;
import flex2.compiler.CompilationUnit;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.css.StyleConflictException;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.NameFormatter;
import macromedia.asc.parser.MetaDataNode;
import macromedia.asc.semantics.Value;
import macromedia.asc.util.Context;

class StyleEvaluator
extends EvaluatorAdapter {
    private CompilationUnit unit;

    StyleEvaluator(CompilationUnit unit) {
        this.unit = unit;
    }

    public Value evaluate(Context context, MetaDataNode node) {
        if ("Style".equals(node.id)) {
            if (NodeMagic.isClassDefinition(node)) {
                this.processStyle(context, node);
            } else {
                context.localizedError2(node.pos(), new StyleMustAnnotateAClass());
            }
        }
        return null;
    }

    private void processStyle(Context context, MetaDataNode metaDataNode) {
        MetaData metaData = new MetaData(metaDataNode);
        String styleName = metaData.getValue("name");
        String typeName = metaData.getValue("type");
        if (styleName == null) {
            context.localizedError2(metaDataNode.pos(), new StyleHasMissingName());
        }
        if (typeName != null) {
            this.unit.expressions.add(NameFormatter.toMultiName(typeName));
        }
        this.registerStyle(context, metaDataNode, styleName, metaData);
    }

    private void registerStyle(Context context, MetaDataNode metaDataNode, String name, MetaData md) {
        block2: {
            try {
                this.unit.styles.addStyle(name, md, this.unit.getSource());
            }
            catch (StyleConflictException e) {
                context.localizedWarning2(metaDataNode.pos(), e);
                if (!Trace.error) break block2;
                e.printStackTrace();
            }
        }
    }

    public static class StyleHasMissingName
    extends CompilerMessage.CompilerError {
    }

    public static class StyleMustAnnotateAClass
    extends CompilerMessage.CompilerError {
    }
}

