/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.swf.Frame;
import flash.swf.Movie;
import flash.swf.MovieDecoder;
import flash.swf.TagDecoder;
import flash.swf.TagHandler;
import flash.swf.tags.DoABC;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import macromedia.abc.BytecodeBuffer;
import macromedia.abc.Decoder;
import macromedia.abc.DecoderException;
import macromedia.abc.DefaultVisitor;
import macromedia.abc.MultiName;
import macromedia.abc.QName;

public class MovieMetaData {
    private Map classes = new LinkedHashMap();
    private Map locations;
    private Set functions = new LinkedHashSet();

    public static void main(String[] args) throws Exception {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(args[0]));
        Movie movie = new Movie();
        new TagDecoder((InputStream)in).parse((TagHandler)new MovieDecoder(movie));
        MovieMetaData metadata = new MovieMetaData();
        metadata.process(movie);
        System.out.println(metadata.toString());
    }

    public MovieMetaData() {
        this.locations = new LinkedHashMap();
    }

    public boolean process(Movie movie) {
        boolean result = true;
        int frameSize = movie.frames.size();
        for (int i = 0; i < frameSize; ++i) {
            Frame f = (Frame)movie.frames.get(i);
            int codeSize = f.doABCs.size();
            for (int j = 0; j < codeSize; ++j) {
                DoABC t = (DoABC)f.doABCs.get(j);
                BytecodeBuffer buffer = new BytecodeBuffer(t.abc);
                try {
                    Decoder decoder = new Decoder(buffer);
                    result = this.processABC(decoder);
                    continue;
                }
                catch (DecoderException ex) {
                    ex.printStackTrace();
                    result = false;
                }
            }
        }
        return result;
    }

    private boolean processABC(Decoder decoder) {
        ABCVisitor v = new ABCVisitor(decoder);
        boolean result = true;
        Decoder.ScriptInfo scriptInfo = decoder.scriptInfo;
        int size = scriptInfo.size();
        for (int i = 0; i < size; ++i) {
            try {
                scriptInfo.decode(i, v);
                continue;
            }
            catch (DecoderException ex) {
                result = false;
            }
        }
        Decoder.MethodBodies methodBodies = decoder.methodBodies;
        int size2 = methodBodies.size();
        for (int i = 0; i < size2; ++i) {
            try {
                methodBodies.decode(i, v);
                continue;
            }
            catch (DecoderException ex) {
                result = false;
            }
        }
        return result;
    }

    public String toString() {
        String key;
        StringWriter w = new StringWriter();
        PrintWriter out = new PrintWriter((Writer)w, true);
        Iterator<Object> i = this.classes.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            Class c = (Class)this.classes.get(key);
            if (c.metadata.size() > 0) {
                out.println(c.metadata);
            }
            out.println(key);
            Iterator j = c.functions.keySet().iterator();
            while (j.hasNext()) {
                Function f = (Function)c.functions.get(j.next());
                if (f.metadata.size() > 0) {
                    out.println("\t" + f.metadata);
                }
                out.println("\t" + f.name);
            }
        }
        i = this.functions.iterator();
        while (i.hasNext()) {
            Function f = (Function)i.next();
            if (f.metadata.size() > 0) {
                out.println(f.metadata);
            }
            out.println(f.name);
        }
        i = this.locations.keySet().iterator();
        while (i.hasNext()) {
            key = (String)i.next();
            out.println(key + " --> " + this.locations.get(key));
        }
        return w.toString();
    }

    class ABCVisitor
    extends DefaultVisitor {
        private String currentClass;
        private String currentFunction;
        private String currentDefinition;
        private Map methods;
        private Stack mdStack;

        ABCVisitor(Decoder decoder) {
            super(decoder);
            this.methods = new HashMap();
            this.mdStack = new Stack();
        }

        private void registerMethodInfo(int methodInfo) {
            if (this.currentClass != null) {
                this.methods.put(new Integer(methodInfo), this.currentClass);
            } else if (this.currentFunction != null) {
                this.methods.put(new Integer(methodInfo), this.currentFunction);
            }
        }

        private void registerClass(String className) {
            if (!MovieMetaData.this.classes.containsKey(className)) {
                MovieMetaData.this.classes.put(className, new Class());
            }
            Class clazz = (Class)MovieMetaData.this.classes.get(className);
            this.mdStack.push(clazz.metadata);
            this.currentClass = className;
        }

        private void registerFunction(String functionName) {
            Function f = new Function();
            f.name = functionName;
            MovieMetaData.this.functions.add(f);
            this.currentFunction = functionName;
            this.mdStack.push(f.metadata);
        }

        private void registerMethod(String functionName) {
            Class c = (Class)MovieMetaData.this.classes.get(this.currentClass);
            if (c != null) {
                Function f = new Function();
                f.name = functionName;
                c.functions.put(functionName, f);
                this.mdStack.push(f.metadata);
            }
        }

        public void beginABC() {
        }

        public void beginBody(int methodID, int codeStart, long codeLength) {
            this.currentDefinition = (String)this.methods.get(new Integer(methodID));
        }

        public void beginCInit(int methodID) {
            this.registerMethodInfo(methodID);
            this.mdStack.push(new ArrayList(1));
        }

        public void beginClass(QName name, int slotID) {
            this.registerClass(name.toString());
        }

        public void beginConst(QName name, int slotID, QName type, Object value) {
            this.mdStack.push(new ArrayList(1));
        }

        public void beginFunction(int methodID, QName name, int slotID) {
            this.registerFunction(name.toString());
            this.registerMethodInfo(methodID);
        }

        public void beginGetter(int methodID, QName name, int dispID, int attr) {
            if (this.currentClass != null) {
                this.registerMethod("get " + name.toString());
            } else {
                this.registerFunction("get " + name.toString());
            }
            this.registerMethodInfo(methodID);
        }

        public void beginIInit(int methodID) {
            this.registerMethodInfo(methodID);
        }

        public void beginMethod(int methodID, QName name, int dispID, int attr) {
            this.registerMethod(name.toString());
            this.registerMethodInfo(methodID);
        }

        public void beginSetter(int methodID, QName name, int dispID, int attr) {
            if (this.currentClass != null) {
                this.registerMethod("set " + name.toString());
            } else {
                this.registerFunction("set " + name.toString());
            }
            this.registerMethodInfo(methodID);
        }

        public void beginVar(QName name, int slotID, QName type, Object value) {
            this.mdStack.push(new ArrayList(1));
        }

        public void classInfo(QName name) {
        }

        public void endABC() {
        }

        public void endBody() {
        }

        public void endCInit() {
            this.mdStack.pop();
        }

        public void endClass(QName name) {
            this.currentClass = null;
            this.mdStack.pop();
        }

        public void endConst(QName name) {
            this.mdStack.pop();
        }

        public void endFunction(QName name) {
            this.currentFunction = null;
            this.mdStack.pop();
        }

        public void endGetter(QName name) {
            if (this.currentClass != null) {
                Class c = (Class)MovieMetaData.this.classes.get(this.currentClass);
                if (c != null) {
                    this.mdStack.pop();
                }
            } else {
                this.mdStack.pop();
            }
            this.currentFunction = null;
        }

        public void endIInit() {
        }

        public void endMethod(QName name) {
            Class c = (Class)MovieMetaData.this.classes.get(this.currentClass);
            if (c != null) {
                this.mdStack.pop();
            }
        }

        public void endSetter(QName name) {
            if (this.currentClass != null) {
                Class c = (Class)MovieMetaData.this.classes.get(this.currentClass);
                if (c != null) {
                    this.mdStack.pop();
                }
            } else {
                this.mdStack.pop();
            }
            this.currentFunction = null;
        }

        public void endVar(QName name) {
            this.mdStack.pop();
        }

        public void instanceInfo(QName name, QName superName, MultiName[] interfaces) {
        }

        public void metadata(String name, String[] keys, String[] values) {
            List metadata = (List)this.mdStack.peek();
            if (metadata != null) {
                int size;
                StringBuffer b = new StringBuffer();
                b.append(name);
                b.append("(");
                int n = size = keys == null ? 0 : keys.length;
                for (int i = 0; i < size; ++i) {
                    if (keys[i] != null) {
                        b.append(keys[i]);
                        b.append("=");
                    }
                    b.append(values[i]);
                    if (i >= size - 1) continue;
                    b.append(",");
                }
                b.append(")");
                metadata.add(b.toString());
            }
        }

        public void methodInfo(QName returnType, QName[] paramTypes, String nativeName, int flags, Object[] values, String[] param_names) {
        }

        public void OP_add() {
        }

        public void OP_add_i() {
        }

        public void OP_add_p(int i) {
        }

        public void OP_astype(int index) {
        }

        public void OP_astypelate() {
        }

        public void OP_bitand() {
        }

        public void OP_bitnot() {
        }

        public void OP_bitor() {
        }

        public void OP_bitxor() {
        }

        public void OP_bkpt() {
        }

        public void OP_bkptline() {
        }

        public void OP_call(int size) {
        }

        public void OP_callmethod(int id, int argc) {
        }

        public void OP_callproperty(int index, int argc) {
        }

        public void OP_callproplex(int index, int argc) {
        }

        public void OP_callpropvoid(int index, int argc) {
        }

        public void OP_callstatic(int id, int argc) {
        }

        public void OP_callsuper(int index, int argc) {
        }

        public void OP_callsupervoid(int index, int argc) {
        }

        public void OP_checkfilter() {
        }

        public void OP_coerce(int index) {
        }

        public void OP_coerce_a() {
        }

        public void OP_coerce_b() {
        }

        public void OP_coerce_d() {
        }

        public void OP_coerce_i() {
        }

        public void OP_coerce_o() {
        }

        public void OP_coerce_s() {
        }

        public void OP_coerce_u() {
        }

        public void OP_construct(int size) {
        }

        public void OP_constructprop(int index, int argc) {
        }

        public void OP_constructsuper(int argc) {
        }

        public void OP_convert_b() {
        }

        public void OP_convert_d() {
        }

        public void OP_convert_i() {
        }

        public void OP_convert_o() {
        }

        public void OP_convert_s() {
        }

        public void OP_convert_u() {
        }

        public void OP_convert_m() {
        }

        public void OP_convert_m_p(int i) {
        }

        public void OP_debug(int di_local, int index, int slot, int linenum) {
        }

        public void OP_debugfile(int index) {
            try {
                String value = this.decoder.constantPool.getString(index);
                if (this.currentDefinition != null && !MovieMetaData.this.locations.containsKey(this.currentDefinition)) {
                    MovieMetaData.this.locations.put(this.currentDefinition, value);
                }
            }
            catch (DecoderException decoderException) {
                // empty catch block
            }
        }

        public void OP_debugline(int linenum) {
        }

        public void OP_declocal(int index) {
        }

        public void OP_declocal_i(int index) {
        }

        public void OP_declocal_p(int i1, int i2) {
        }

        public void OP_decrement() {
        }

        public void OP_decrement_i() {
        }

        public void OP_decrement_p(int i) {
        }

        public void OP_deldescendants() {
        }

        public void OP_deleteproperty(int index) {
        }

        public void OP_divide() {
        }

        public void OP_divide_p(int i) {
        }

        public void OP_dup() {
        }

        public void OP_dxns(int index) {
        }

        public void OP_dxnslate() {
        }

        public void OP_equals() {
        }

        public void OP_esc_xattr() {
        }

        public void OP_esc_xelem() {
        }

        public void OP_finddef(int index) {
        }

        public void OP_findproperty(int index) {
        }

        public void OP_findpropstrict(int index) {
        }

        public void OP_getdescendants(int index) {
        }

        public void OP_getglobalscope() {
        }

        public void OP_getglobalslot(int index) {
        }

        public void OP_getlex(int index) {
        }

        public void OP_getlocal(int index) {
        }

        public void OP_getlocal0() {
        }

        public void OP_getlocal1() {
        }

        public void OP_getlocal2() {
        }

        public void OP_getlocal3() {
        }

        public void OP_getproperty(int index) {
        }

        public void OP_getscopeobject(int index) {
        }

        public void OP_getslot(int index) {
        }

        public void OP_getsuper(int index) {
        }

        public void OP_greaterequals() {
        }

        public void OP_greaterthan() {
        }

        public void OP_hasnext() {
        }

        public void OP_hasnext2(int objectRegister, int indexRegister) {
        }

        public void OP_ifeq(int offset, int nextPos) {
        }

        public void OP_iffalse(int offset, int nextPos) {
        }

        public void OP_ifge(int offset, int nextPos) {
        }

        public void OP_ifgt(int offset, int nextPos) {
        }

        public void OP_ifle(int offset, int nextPos) {
        }

        public void OP_iflt(int offset, int nextPos) {
        }

        public void OP_ifne(int offset, int nextPos) {
        }

        public void OP_ifnge(int offset, int nextPos) {
        }

        public void OP_ifngt(int offset, int nextPos) {
        }

        public void OP_ifnle(int offset, int nextPos) {
        }

        public void OP_ifnlt(int offset, int nextPos) {
        }

        public void OP_ifstricteq(int offset, int nextPos) {
        }

        public void OP_ifstrictne(int offset, int nextPos) {
        }

        public void OP_iftrue(int offset, int nextPos) {
        }

        public void OP_in() {
        }

        public void OP_inclocal(int index) {
        }

        public void OP_inclocal_i(int index) {
        }

        public void OP_inclocal_p(int i1, int i2) {
        }

        public void OP_increment() {
        }

        public void OP_increment_i() {
        }

        public void OP_increment_p(int i) {
        }

        public void OP_initproperty(int index) {
        }

        public void OP_instanceof() {
        }

        public void OP_istype(int index) {
        }

        public void OP_istypelate() {
        }

        public void OP_jump(int jump, int pos) {
        }

        public void OP_kill(int index) {
        }

        public void OP_label() {
        }

        public void OP_lessequals() {
        }

        public void OP_lessthan() {
        }

        public void OP_lookupswitch(int defaultPos, int[] casePos, int thisPos, int caseTablePos) {
        }

        public void OP_lshift() {
        }

        public void OP_modulo() {
        }

        public void OP_modulo_p(int i) {
        }

        public void OP_multiply() {
        }

        public void OP_multiply_i() {
        }

        public void OP_multiply_p(int i) {
        }

        public void OP_negate() {
        }

        public void OP_negate_i() {
        }

        public void OP_negate_p(int index) {
        }

        public void OP_newactivation() {
        }

        public void OP_newarray(int size) {
        }

        public void OP_newcatch(int index) {
        }

        public void OP_newclass(int id) {
        }

        public void OP_newfunction(int id) {
        }

        public void OP_newobject(int size) {
        }

        public void OP_nextname() {
        }

        public void OP_nextvalue() {
        }

        public void OP_nop() {
        }

        public void OP_not() {
        }

        public void OP_pop() {
        }

        public void OP_popscope() {
        }

        public void OP_pushbyte(int n) {
        }

        public void OP_pushconstant(int id) {
        }

        public void OP_pushdouble(int index) {
        }

        public void OP_pushdecimal(int index) {
        }

        public void OP_pushfalse() {
        }

        public void OP_pushint(int index) {
        }

        public void OP_pushnamespace(int index) {
        }

        public void OP_pushnan() {
        }

        public void OP_pushdnan() {
        }

        public void OP_pushnull() {
        }

        public void OP_pushscope() {
        }

        public void OP_pushshort(int n) {
        }

        public void OP_pushstring(int index) {
        }

        public void OP_pushtrue() {
        }

        public void OP_pushuint(int index) {
        }

        public void OP_pushundefined() {
        }

        public void OP_pushwith() {
        }

        public void OP_returnvalue() {
        }

        public void OP_returnvoid() {
        }

        public void OP_rshift() {
        }

        public void OP_setglobalslot(int index) {
        }

        public void OP_setlocal(int index) {
        }

        public void OP_setlocal0() {
        }

        public void OP_setlocal1() {
        }

        public void OP_setlocal2() {
        }

        public void OP_setlocal3() {
        }

        public void OP_setproperty(int index) {
        }

        public void OP_setslot(int index) {
        }

        public void OP_setsuper(int index) {
        }

        public void OP_strictequals() {
        }

        public void OP_subtract() {
        }

        public void OP_subtract_i() {
        }

        public void OP_subtract_p(int i) {
        }

        public void OP_swap() {
        }

        public void OP_throw() {
        }

        public void OP_timestamp() {
        }

        public void OP_typeof() {
        }

        public void OP_urshift() {
        }

        public void target(int pos) {
        }
    }

    class Function {
        List metadata = new ArrayList();
        String name;

        Function() {
        }

        public String toString() {
            return this.name;
        }
    }

    class Class {
        List metadata = new ArrayList();
        Map functions = new LinkedHashMap();

        Class() {
        }
    }
}

