/*
 * Decompiled with CFR 0.152.
 */
package flash.graphics.images;

import flash.graphics.images.BitmapImage;
import flash.graphics.images.ImageUtil;
import flash.util.FileUtils;
import flash.util.Trace;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class LosslessImage
extends BitmapImage {
    protected int[] pixels;

    public LosslessImage(File imageFile) throws MalformedURLException, IOException {
        this(imageFile.getName(), imageFile.toURL().openStream(), imageFile.lastModified());
    }

    public LosslessImage(String location, InputStream inputStream, long modified) {
        this.location = location;
        this.modified = modified;
        byte[] bytes = FileUtils.toByteArray(inputStream);
        Image image = ImageUtil.getImage(bytes);
        this.init(image);
    }

    public LosslessImage(URL imageURL) {
        Image image = Toolkit.getDefaultToolkit().getImage(imageURL);
        try {
            URLConnection conn = imageURL.openConnection();
            this.location = imageURL.toString();
            this.modified = conn.getLastModified();
        }
        catch (InternalError ie) {
            if (Trace.error) {
                ie.printStackTrace();
            }
            throw new InternalError("An error occurred because there is no graphics environment available.  Please set the headless-server setting in the configuration file to true.");
        }
        catch (NoClassDefFoundError ce) {
            if (Trace.error) {
                ce.printStackTrace();
            }
            throw new InternalError("An error occurred because there is no graphics environment available.  Please set the headless-server setting in the configuration file to true.");
        }
        catch (IOException ioe) {
            throw new RuntimeException("Error reading image from URL. " + ioe.getMessage());
        }
        this.init(image);
    }

    public LosslessImage(Image image) {
        this.location = "Synthetic";
        this.modified = System.currentTimeMillis();
        this.init(image);
    }

    private void init(Image image) {
        Class<?> ct;
        PixelGrabber pixelGrabber = ImageUtil.getPixelGrabber(image, this.location);
        this.width = pixelGrabber.getWidth();
        this.height = pixelGrabber.getHeight();
        Object p = pixelGrabber.getPixels();
        if (p != null && (ct = p.getClass().getComponentType()) != null) {
            if (ct.equals(Integer.TYPE)) {
                this.pixels = (int[])p;
            } else if (ct.equals(Byte.TYPE)) {
                throw new IllegalStateException("int[] of pixels expected, received byte[] instead.");
            }
        }
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public void dispose() {
    }
}

