/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.tools;

import flash.swf.ActionDecoder;
import flash.swf.Dictionary;
import flash.swf.Header;
import flash.swf.SwfDecoder;
import flash.swf.Tag;
import flash.swf.TagDecoder;
import flash.swf.TagEncoder;
import flash.swf.TagHandler;
import flash.swf.TagValues;
import flash.swf.tags.CSMTextSettings;
import flash.swf.tags.DebugID;
import flash.swf.tags.DefineBinaryData;
import flash.swf.tags.DefineBits;
import flash.swf.tags.DefineBitsJPEG3;
import flash.swf.tags.DefineBitsLossless;
import flash.swf.tags.DefineButton;
import flash.swf.tags.DefineButtonCxform;
import flash.swf.tags.DefineButtonSound;
import flash.swf.tags.DefineEditText;
import flash.swf.tags.DefineFont;
import flash.swf.tags.DefineFontAlignZones;
import flash.swf.tags.DefineFontInfo;
import flash.swf.tags.DefineFontName;
import flash.swf.tags.DefineMorphShape;
import flash.swf.tags.DefineScalingGrid;
import flash.swf.tags.DefineShape;
import flash.swf.tags.DefineSound;
import flash.swf.tags.DefineSprite;
import flash.swf.tags.DefineTag;
import flash.swf.tags.DefineText;
import flash.swf.tags.DefineVideoStream;
import flash.swf.tags.DoABC;
import flash.swf.tags.DoAction;
import flash.swf.tags.DoInitAction;
import flash.swf.tags.EnableDebugger;
import flash.swf.tags.ExportAssets;
import flash.swf.tags.FileAttributes;
import flash.swf.tags.FrameLabel;
import flash.swf.tags.GenericTag;
import flash.swf.tags.ImportAssets;
import flash.swf.tags.Metadata;
import flash.swf.tags.PlaceObject;
import flash.swf.tags.ProductInfo;
import flash.swf.tags.RemoveObject;
import flash.swf.tags.ScriptLimits;
import flash.swf.tags.SetBackgroundColor;
import flash.swf.tags.SetTabIndex;
import flash.swf.tags.ShowFrame;
import flash.swf.tags.SoundStreamHead;
import flash.swf.tags.StartSound;
import flash.swf.tags.SymbolClass;
import flash.swf.tags.VideoFrame;
import flash.swf.tags.ZoneRecord;
import flash.swf.tools.AbcPrinter;
import flash.swf.tools.Disassembler;
import flash.swf.tools.SyntaxTreeDumper;
import flash.swf.types.ActionList;
import flash.swf.types.ButtonCondAction;
import flash.swf.types.ButtonRecord;
import flash.swf.types.ClipActionRecord;
import flash.swf.types.CurvedEdgeRecord;
import flash.swf.types.EdgeRecord;
import flash.swf.types.FillStyle;
import flash.swf.types.Filter;
import flash.swf.types.FocalGradient;
import flash.swf.types.GlyphEntry;
import flash.swf.types.GradRecord;
import flash.swf.types.ImportRecord;
import flash.swf.types.KerningRecord;
import flash.swf.types.LineStyle;
import flash.swf.types.MorphFillStyle;
import flash.swf.types.MorphGradRecord;
import flash.swf.types.MorphLineStyle;
import flash.swf.types.Shape;
import flash.swf.types.ShapeRecord;
import flash.swf.types.ShapeWithStyle;
import flash.swf.types.SoundInfo;
import flash.swf.types.StraightEdgeRecord;
import flash.swf.types.StyleChangeRecord;
import flash.swf.types.TextRecord;
import flash.util.Base64;
import flash.util.FileUtils;
import flash.util.SwfImageUtils;
import flash.util.Trace;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import macromedia.abc.AbcParser;
import macromedia.asc.embedding.CompilerHandler;
import macromedia.asc.embedding.avmplus.ActionBlockEmitter;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.semantics.Emitter;
import macromedia.asc.semantics.ObjectValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.Context;
import macromedia.asc.util.ContextStatics;
import macromedia.asc.util.StringPrintWriter;

public final class SwfxPrinter
extends TagHandler {
    private boolean abc = false;
    private boolean showActions = true;
    private boolean showOffset = false;
    private boolean showDebugSource = false;
    private boolean glyphs = true;
    private boolean external = false;
    private String externalPrefix = null;
    private String externalDirectory = null;
    private boolean decompile;
    private boolean defunc;
    private int indent = 0;
    private boolean tabbedGlyphs = false;
    private final PrintWriter out;
    private Dictionary dict;
    static final char[] digits;
    static boolean abcOption;
    static boolean encodeOption;
    static boolean showActionsOption;
    static boolean showOffsetOption;
    static boolean showDebugSourceOption;
    static boolean glyphsOption;
    static boolean externalOption;
    static boolean decompileOption;
    static boolean defuncOption;
    static boolean saveOption;
    static boolean tabbedGlyphsOption;

    public SwfxPrinter(PrintWriter out) {
        this.out = out;
    }

    private void printActions(ActionList list) {
        if (this.decompile) {
            // empty if block
        }
        Disassembler disassembler = new Disassembler(this.out, this.showOffset, this.indent);
        if (this.showDebugSource) {
            disassembler.setShowDebugSource(this.showDebugSource);
            disassembler.setComment("// ");
        }
        list.visitAll(disassembler);
    }

    private void setExternal(boolean b, String path) {
        this.external = b;
        if (this.external) {
            if (path != null) {
                this.externalPrefix = SwfxPrinter.baseName(path);
                this.externalDirectory = SwfxPrinter.dirName(path);
            }
            this.externalPrefix = this.externalPrefix == null ? "" : this.externalPrefix + "-";
            if (this.externalDirectory == null) {
                this.externalDirectory = "";
            }
        }
    }

    private void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.out.print("  ");
        }
    }

    public void header(Header h) {
        this.out.println("<!-- ?xml version=\"1.0\" encoding=\"UTF-8\"? -->");
        this.out.println("<swf xmlns='http://macromedia/2003/swfx' version='" + h.version + "'" + " framerate='" + h.rate + "'" + " size='" + h.size + "'" + " compressed='" + h.compressed + "'" + " >");
        ++this.indent;
        this.indent();
        this.out.println("<!-- framecount=" + h.framecount + " length=" + h.length + " -->");
    }

    public void productInfo(ProductInfo productInfo) {
        this.open(productInfo);
        this.out.print(" product='" + productInfo.getProductString() + "'");
        this.out.print(" edition='" + productInfo.getEditionString() + "'");
        this.out.print(" version='" + productInfo.getMajorVersion() + "." + productInfo.getMinorVersion() + "'");
        this.out.print(" build='" + productInfo.getBuild() + "'");
        this.out.print(" compileDate='" + DateFormat.getInstance().format(new Date(productInfo.getCompileDate())) + "'");
        this.close();
    }

    public void metadata(Metadata tag) {
        this.open(tag);
        this.end();
        this.indent();
        this.out.println(tag.xml);
        this.close(tag);
    }

    public void fileAttributes(FileAttributes tag) {
        this.open(tag);
        this.out.print(" hasMetadata='" + tag.hasMetadata + "'");
        this.out.print(" actionScript3='" + tag.actionScript3 + "'");
        this.out.print(" suppressCrossDomainCaching='" + tag.suppressCrossDomainCaching + "'");
        this.out.print(" swfRelativeUrls='" + tag.swfRelativeUrls + "'");
        this.out.print(" useNetwork='" + tag.useNetwork + "'");
        this.close();
    }

    public void setDecoderDictionary(Dictionary dict) {
        this.dict = dict;
    }

    public void setOffsetAndSize(int offset, int size) {
        if (this.showOffset) {
            this.indent();
            this.out.println("<!-- offset=" + offset + " size=" + size + " -->");
        }
    }

    private void open(Tag tag) {
        this.indent();
        this.out.print("<" + TagValues.names[tag.code]);
    }

    private void end() {
        this.out.println(">");
        ++this.indent;
    }

    private void openCDATA() {
        this.indent();
        this.out.println("<![CDATA[");
        ++this.indent;
    }

    private void closeCDATA() {
        --this.indent;
        this.indent();
        this.out.println("]]>");
    }

    private void close() {
        this.out.println("/>");
    }

    private void close(Tag tag) {
        --this.indent;
        this.indent();
        this.out.println("</" + TagValues.names[tag.code] + ">");
    }

    public void error(String s) {
        this.indent();
        this.out.println("<!-- error: " + s + " -->");
    }

    public void unknown(GenericTag tag) {
        this.indent();
        this.out.println("<!-- unknown tag=" + tag.code + " length=" + (tag.data != null ? tag.data.length : 0) + " -->");
    }

    public void showFrame(ShowFrame tag) {
        this.open(tag);
        this.close();
    }

    public void defineShape(DefineShape tag) {
        this.printDefineShape(tag, false);
    }

    private void printDefineShape(DefineShape tag, boolean alpha) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.out.print(" bounds='" + tag.bounds + "'");
        if (tag.code == 83) {
            this.out.print(" edgebounds='" + tag.edgeBounds + "'");
            this.out.print(" usesNonScalingStrokes='" + tag.usesNonScalingStrokes + "'");
            this.out.print(" usesScalingStrokes='" + tag.usesScalingStrokes + "'");
        }
        this.end();
        this.printShapeWithStyles(tag.shapeWithStyle, alpha);
        this.close(tag);
    }

    private String id(DefineTag tag) {
        int id = this.dict.getId(tag);
        return String.valueOf(id);
    }

    public String printRGB(int rgb) {
        StringBuffer b = new StringBuffer();
        b.append('#');
        int red = rgb >> 16 & 0xFF;
        b.append(digits[red >> 4 & 0xF]);
        b.append(digits[red & 0xF]);
        int green = rgb >> 8 & 0xFF;
        b.append(digits[green >> 4 & 0xF]);
        b.append(digits[green & 0xF]);
        int blue = rgb & 0xFF;
        b.append(digits[blue >> 4 & 0xF]);
        b.append(digits[blue & 0xF]);
        return b.toString();
    }

    public String printRGBA(int rgb) {
        StringBuffer b = new StringBuffer();
        b.append('#');
        int red = rgb >> 16 & 0xFF;
        b.append(digits[red >> 4 & 0xF]);
        b.append(digits[red & 0xF]);
        int green = rgb >> 8 & 0xFF;
        b.append(digits[green >> 4 & 0xF]);
        b.append(digits[green & 0xF]);
        int blue = rgb & 0xFF;
        b.append(digits[blue >> 4 & 0xF]);
        b.append(digits[blue & 0xF]);
        int alpha = rgb >> 24 & 0xFF;
        b.append(digits[alpha >> 4 & 0xF]);
        b.append(digits[alpha & 0xF]);
        return b.toString();
    }

    public void placeObject(PlaceObject tag) {
        this.open(tag);
        this.out.print(" idref='" + this.idRef(tag.ref) + "'");
        this.out.print(" depth='" + tag.depth + "'");
        this.out.print(" matrix='" + tag.matrix + "'");
        if (tag.colorTransform != null) {
            this.out.print(" colorXform='" + tag.colorTransform + "'");
        }
        this.close();
    }

    public void removeObject(RemoveObject tag) {
        this.open(tag);
        this.out.print(" idref='" + this.idRef(tag.ref) + "'");
        this.close();
    }

    public void outputBase64(byte[] data) {
        int block;
        Base64.Encoder e = new Base64.Encoder(1024);
        this.indent();
        for (int remain = data.length; remain > 0; remain -= block) {
            block = 1024;
            if (block > remain) {
                block = remain;
            }
            e.encode(data, data.length - remain, block);
            this.out.print(e.drain());
        }
        this.out.println(e.flush());
    }

    public void defineBits(DefineBits tag) {
        if (tag.jpegTables == null) {
            this.out.println("<!-- warning: no JPEG table tag found. -->");
        }
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        if (this.external) {
            String path = this.externalDirectory + this.externalPrefix + "image" + this.dict.getId(tag) + ".jpg";
            this.out.println(" src='" + path + "' />");
            try {
                FileOutputStream image = new FileOutputStream(path, false);
                SwfImageUtils.JPEG jpeg = new SwfImageUtils.JPEG(tag.jpegTables.data, tag.data);
                jpeg.write(image);
                image.close();
            }
            catch (IOException e) {
                this.out.println("<!-- error: unable to write external asset file " + path + "-->");
            }
        } else {
            this.out.print(" encoding='base64'");
            this.end();
            this.outputBase64(tag.data);
            this.close(tag);
        }
    }

    public void defineButton(DefineButton tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.end();
        if (this.showActions) {
            this.openCDATA();
            this.printActions(tag.condActions[0].actionList);
            this.closeCDATA();
        } else {
            this.out.println("<!-- " + tag.condActions[0].actionList.size() + " action(s) elided -->");
        }
        this.close(tag);
    }

    public void jpegTables(GenericTag tag) {
        this.open(tag);
        this.out.print(" encoding='base64'");
        this.end();
        this.outputBase64(tag.data);
        this.close(tag);
    }

    public void setBackgroundColor(SetBackgroundColor tag) {
        this.open(tag);
        this.out.print(" color='" + this.printRGB(tag.color) + "'");
        this.close();
    }

    public void defineFont(DefineFont tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.end();
        if (this.glyphs) {
            for (int i = 0; i < tag.glyphShapeTable.length; ++i) {
                this.indent();
                this.out.println("<glyph>");
                Shape shape = tag.glyphShapeTable[i];
                ++this.indent;
                this.printShapeWithTabs(shape);
                --this.indent;
                this.indent();
                this.out.println("</glyph>");
            }
        }
        this.close(tag);
    }

    public void defineText(DefineText tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.out.print(" bounds='" + tag.bounds + "'");
        this.out.print(" matrix='" + tag.matrix + "'");
        this.end();
        Iterator it = tag.records.iterator();
        while (it.hasNext()) {
            TextRecord tr = (TextRecord)it.next();
            this.printTextRecord(tr, tag.code);
        }
        this.close(tag);
    }

    public void doAction(DoAction tag) {
        this.open(tag);
        this.end();
        if (this.showActions) {
            this.openCDATA();
            this.printActions(tag.actionList);
            this.closeCDATA();
        } else {
            this.out.println("<!-- " + tag.actionList.size() + " action(s) elided -->");
        }
        this.close(tag);
    }

    public void defineFontInfo(DefineFontInfo tag) {
        this.open(tag);
        this.out.print(" idref='" + this.idRef(tag.font) + "'");
        this.out.print(" ansi='" + tag.ansi + "'");
        this.out.print(" italic='" + tag.italic + "'");
        this.out.print(" bold='" + tag.bold + "'");
        this.out.print(" wideCodes='" + tag.wideCodes + "'");
        this.out.print(" langCold='" + tag.langCode + "'");
        this.out.print(" name='" + tag.name + "'");
        this.out.print(" shiftJIS='" + tag.shiftJIS + "'");
        this.end();
        this.indent();
        for (int i = 0; i < tag.codeTable.length; ++i) {
            this.out.print((int)tag.codeTable[i]);
            if ((i + 1) % 16 == 0) {
                this.out.println();
                this.indent();
                continue;
            }
            this.out.print(' ');
        }
        if (tag.codeTable.length % 16 != 0) {
            this.out.println();
            this.indent();
        }
        this.close(tag);
    }

    public void defineSound(DefineSound tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.out.print(" format='" + tag.format + "'");
        this.out.print(" rate='" + tag.rate + "'");
        this.out.print(" size='" + tag.size + "'");
        this.out.print(" type='" + tag.type + "'");
        this.out.print(" sampleCount='" + tag.sampleCount + "'");
        this.out.print(" soundDataSize='" + tag.data.length + "'");
        this.end();
        this.openCDATA();
        this.outputBase64(tag.data);
        this.closeCDATA();
        this.close(tag);
    }

    public void startSound(StartSound tag) {
        this.open(tag);
        this.out.print(" soundid='" + this.idRef(tag.sound) + "'");
        this.printSoundInfo(tag.soundInfo);
        this.close(tag);
    }

    private void printSoundInfo(SoundInfo info) {
        this.out.print(" syncStop='" + info.syncStop + "'");
        this.out.print(" syncNoMultiple='" + info.syncNoMultiple + "'");
        if (info.inPoint != -1L) {
            this.out.print(" inPoint='" + info.inPoint + "'");
        }
        if (info.outPoint != -1L) {
            this.out.print(" outPoint='" + info.outPoint + "'");
        }
        if (info.loopCount != -1) {
            this.out.print(" loopCount='" + info.loopCount + "'");
        }
        this.end();
        if (info.records != null && info.records.length > 0) {
            this.openCDATA();
            for (int i = 0; i < info.records.length; ++i) {
                this.out.println(info.records[i]);
            }
            this.closeCDATA();
        }
    }

    public void defineButtonSound(DefineButtonSound tag) {
        this.open(tag);
        this.out.print(" buttonId='" + this.idRef(tag.button) + "'");
        this.close();
    }

    public void soundStreamHead(SoundStreamHead tag) {
        this.open(tag);
        this.close();
    }

    public void soundStreamBlock(GenericTag tag) {
        this.open(tag);
        this.close();
    }

    public void defineBinaryData(DefineBinaryData tag) {
        this.open(tag);
        this.out.println(" id='" + this.id(tag) + "' length='" + tag.data.length + "' />");
    }

    public void defineBitsLossless(DefineBitsLossless tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "' width='" + tag.width + "' height='" + tag.height + "'");
        if (this.external) {
            String path = this.externalDirectory + this.externalPrefix + "image" + this.dict.getId(tag) + ".bitmap";
            this.out.println(" src='" + path + "' />");
            try {
                FileOutputStream image = new FileOutputStream(path, false);
                image.write(tag.data);
                image.close();
            }
            catch (IOException e) {
                this.out.println("<!-- error: unable to write external asset file " + path + "-->");
            }
        } else {
            this.out.print(" encoding='base64'");
            this.end();
            this.outputBase64(tag.data);
            this.close(tag);
        }
    }

    public void defineBitsJPEG2(DefineBits tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        if (this.external) {
            String path = this.externalDirectory + this.externalPrefix + "image" + this.dict.getId(tag) + ".jpg";
            this.out.println(" src='" + path + "' />");
            try {
                FileOutputStream image = new FileOutputStream(path, false);
                image.write(tag.data);
                image.close();
            }
            catch (IOException e) {
                this.out.println("<!-- error: unable to write external asset file " + path + "-->");
            }
        } else {
            this.out.print(" encoding='base64'");
            this.end();
            this.outputBase64(tag.data);
            this.close(tag);
        }
    }

    public void defineShape2(DefineShape tag) {
        this.printDefineShape(tag, false);
    }

    public void defineButtonCxform(DefineButtonCxform tag) {
        this.open(tag);
        this.out.print(" buttonId='" + this.idRef(tag.button) + "'");
        this.close();
    }

    public void protect(GenericTag tag) {
        this.open(tag);
        if (tag.data != null) {
            this.out.print(" password='" + this.hexify(tag.data) + "'");
        }
        this.close();
    }

    public void placeObject2(PlaceObject tag) {
        this.placeObject23(tag);
    }

    public void placeObject3(PlaceObject tag) {
        this.placeObject23(tag);
    }

    public void placeObject23(PlaceObject tag) {
        Iterator it;
        if (tag.hasCharID() && tag.ref.name != null) {
            this.indent();
            this.out.println("<!-- instance of " + tag.ref.name + " -->");
        }
        this.open(tag);
        if (tag.hasCharID()) {
            this.out.print(" idref='" + this.idRef(tag.ref) + "'");
        }
        if (tag.hasName()) {
            this.out.print(" name='" + tag.name + "'");
        }
        this.out.print(" depth='" + tag.depth + "'");
        if (tag.hasClipDepth()) {
            this.out.print(" clipDepth='" + tag.clipDepth + "'");
        }
        if (tag.hasRatio()) {
            this.out.print(" ratio='" + tag.ratio + "'");
        }
        if (tag.hasCxform()) {
            this.out.print(" cxform='" + tag.colorTransform + "'");
        }
        if (tag.hasMatrix()) {
            this.out.print(" matrix='" + tag.matrix + "'");
        }
        if (tag.hasBlendMode()) {
            this.out.print(" blendmode='" + tag.blendMode + "'");
        }
        if (tag.hasFilterList()) {
            this.out.print(" filters='");
            it = tag.filters.iterator();
            while (it.hasNext()) {
                this.out.print(((Filter)it.next()).getID() + " ");
            }
            this.out.print("'");
        }
        if (tag.hasClipAction()) {
            this.end();
            it = tag.clipActions.clipActionRecords.iterator();
            this.openCDATA();
            while (it.hasNext()) {
                ClipActionRecord record = (ClipActionRecord)it.next();
                this.indent();
                this.out.println("onClipEvent(" + this.printClipEventFlags(record.eventFlags) + (record.hasKeyPress() ? "<" + record.keyCode + ">" : "") + ") {");
                ++this.indent;
                if (this.showActions) {
                    this.printActions(record.actionList);
                } else {
                    this.indent();
                    this.out.println("// " + record.actionList.size() + " action(s) elided");
                }
                --this.indent;
                this.indent();
                this.out.println("}");
            }
            this.closeCDATA();
            this.close(tag);
        } else {
            this.close();
        }
    }

    public void removeObject2(RemoveObject tag) {
        this.open(tag);
        this.out.print(" depth='" + tag.depth + "'");
        this.close();
    }

    public void defineShape3(DefineShape tag) {
        this.printDefineShape(tag, true);
    }

    public void defineShape6(DefineShape tag) {
        this.printDefineShape(tag, true);
    }

    private void printShapeWithStyles(ShapeWithStyle shapes, boolean alpha) {
        this.printFillStyles(shapes.fillstyles, alpha);
        this.printLineStyles(shapes.linestyles, alpha);
        this.printShape(shapes, alpha);
    }

    private void printMorphLineStyles(MorphLineStyle[] lineStyles) {
        for (int i = 0; i < lineStyles.length; ++i) {
            MorphLineStyle lineStyle = lineStyles[i];
            this.indent();
            this.out.print("<linestyle ");
            this.out.print("startColor='" + this.printRGBA(lineStyle.startColor) + "' ");
            this.out.print("endColor='" + this.printRGBA(lineStyle.startColor) + "' ");
            this.out.print("startWidth='" + lineStyle.startWidth + "' ");
            this.out.print("endWidth='" + lineStyle.endWidth + "' ");
            this.out.println("/>");
        }
    }

    private void printLineStyles(ArrayList linestyles, boolean alpha) {
        Iterator it = linestyles.iterator();
        while (it.hasNext()) {
            LineStyle lineStyle = (LineStyle)it.next();
            this.indent();
            this.out.print("<linestyle ");
            String color = alpha ? this.printRGBA(lineStyle.color) : this.printRGB(lineStyle.color);
            this.out.print("color='" + color + "' ");
            this.out.print("width='" + lineStyle.width + "' ");
            if (lineStyle.flags != 0) {
                this.out.print("flags='" + lineStyle.flags + "' ");
            }
            if (lineStyle.hasMiterJoint()) {
                this.out.print("miterLimit='" + lineStyle.miterLimit + "' ");
            }
            if (lineStyle.hasFillStyle()) {
                this.out.print("fillStyle='" + lineStyle.fillStyle + "' ");
            }
            this.out.println("/>");
        }
    }

    private void printFillStyles(ArrayList fillstyles, boolean alpha) {
        Iterator it = fillstyles.iterator();
        while (it.hasNext()) {
            FillStyle fillStyle = (FillStyle)it.next();
            this.indent();
            this.out.print("<fillstyle");
            this.out.print(" type='" + fillStyle.getType() + "'");
            if (fillStyle.getType() == 0) {
                this.out.print(" color='" + (alpha ? this.printRGBA(fillStyle.color) : this.printRGB(fillStyle.color)) + "'");
            }
            if ((fillStyle.getType() & 0x10) != 0) {
                if (fillStyle.getType() == 18) {
                    this.out.print("type='radial'");
                } else if (fillStyle.getType() == 19) {
                    this.out.print("type='focal' focalPoint='" + ((FocalGradient)fillStyle.gradient).focalPoint + "'");
                }
                this.out.print(" gradient='" + this.formatGradient(fillStyle.gradient.records, alpha) + "'");
                this.out.print(" matrix='" + fillStyle.matrix + "'");
            }
            if ((fillStyle.getType() & 0x40) != 0) {
                this.out.print(" idref='" + this.idRef(fillStyle.bitmap) + "'");
                this.out.print(" matrix='" + fillStyle.matrix + "'");
            }
            this.out.println(" />");
        }
    }

    private void printMorphFillStyles(MorphFillStyle[] fillStyles) {
        for (int i = 0; i < fillStyles.length; ++i) {
            MorphFillStyle fillStyle = fillStyles[i];
            this.indent();
            this.out.print("<fillstyle");
            this.out.print(" type='" + fillStyle.type + "'");
            if (fillStyle.type == 0) {
                this.out.print(" startColor='" + this.printRGBA(fillStyle.startColor) + "'");
                this.out.print(" endColor='" + this.printRGBA(fillStyle.endColor) + "'");
            }
            if ((fillStyle.type & 0x10) != 0) {
                this.out.print(" gradient='" + this.formatMorphGradient(fillStyle.gradRecords) + "'");
                this.out.print(" startMatrix='" + fillStyle.startGradientMatrix + "'");
                this.out.print(" endMatrix='" + fillStyle.endGradientMatrix + "'");
            }
            if ((fillStyle.type & 0x40) != 0) {
                this.out.print(" idref='" + this.idRef(fillStyle.bitmap) + "'");
                this.out.print(" startMatrix='" + fillStyle.startBitmapMatrix + "'");
                this.out.print(" endMatrix='" + fillStyle.endBitmapMatrix + "'");
            }
            this.out.println(" />");
        }
    }

    private String formatGradient(GradRecord[] records, boolean alpha) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < records.length; ++i) {
            b.append(records[i].ratio);
            b.append(' ');
            b.append(alpha ? this.printRGBA(records[i].color) : this.printRGB(records[i].color));
            if (i + 1 >= records.length) continue;
            b.append(' ');
        }
        return b.toString();
    }

    private String formatMorphGradient(MorphGradRecord[] records) {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < records.length; ++i) {
            b.append(records[i].startRatio);
            b.append(',');
            b.append(records[i].endRatio);
            b.append(' ');
            b.append(this.printRGBA(records[i].startColor));
            b.append(',');
            b.append(this.printRGBA(records[i].endColor));
            if (i + 1 >= records.length) continue;
            b.append(' ');
        }
        return b.toString();
    }

    private void printShape(Shape shapes, boolean alpha) {
        Iterator it = shapes.shapeRecords.iterator();
        while (it.hasNext()) {
            this.indent();
            ShapeRecord shape = (ShapeRecord)it.next();
            if (shape instanceof StyleChangeRecord) {
                StyleChangeRecord styleChange = (StyleChangeRecord)shape;
                this.out.print("<styleChange ");
                if (styleChange.stateMoveTo) {
                    this.out.print("dx='" + styleChange.moveDeltaX + "' dy='" + styleChange.moveDeltaY + "' ");
                }
                if (styleChange.stateFillStyle0) {
                    this.out.print("fillStyle0='" + styleChange.fillstyle0 + "' ");
                }
                if (styleChange.stateFillStyle1) {
                    this.out.print("fillStyle1='" + styleChange.fillstyle1 + "' ");
                }
                if (styleChange.stateLineStyle) {
                    this.out.print("lineStyle='" + styleChange.linestyle + "' ");
                }
                if (styleChange.stateNewStyles) {
                    this.out.println(">");
                    ++this.indent;
                    this.printFillStyles(styleChange.fillstyles, alpha);
                    this.printLineStyles(styleChange.linestyles, alpha);
                    --this.indent;
                    this.indent();
                    this.out.println("</styleChange>");
                    continue;
                }
                this.out.println("/>");
                continue;
            }
            EdgeRecord edge = (EdgeRecord)shape;
            if (edge instanceof StraightEdgeRecord) {
                StraightEdgeRecord straightEdge = (StraightEdgeRecord)edge;
                this.out.println("<line dx='" + straightEdge.deltaX + "' dy='" + straightEdge.deltaY + "' />");
                continue;
            }
            CurvedEdgeRecord curvedEdge = (CurvedEdgeRecord)edge;
            this.out.print("<curve ");
            this.out.print("cdx='" + curvedEdge.controlDeltaX + "' cdy='" + curvedEdge.controlDeltaY + "' ");
            this.out.print("dx='" + curvedEdge.anchorDeltaX + "' dy='" + curvedEdge.anchorDeltaY + "' ");
            this.out.println("/>");
        }
    }

    private void printShapeWithTabs(Shape shapes) {
        Iterator it = shapes.shapeRecords.iterator();
        int startX = 0;
        int startY = 0;
        int x = 0;
        int y = 0;
        while (it.hasNext()) {
            this.indent();
            ShapeRecord shape = (ShapeRecord)it.next();
            if (shape instanceof StyleChangeRecord) {
                StyleChangeRecord styleChange = (StyleChangeRecord)shape;
                this.out.print("SSCR" + styleChange.nMoveBits() + "\t");
                if (styleChange.stateMoveTo) {
                    this.out.print(styleChange.moveDeltaX + "\t" + styleChange.moveDeltaY);
                    if (startX == 0 && startY == 0) {
                        startX = styleChange.moveDeltaX;
                        startY = styleChange.moveDeltaY;
                    }
                    x = styleChange.moveDeltaX;
                    y = styleChange.moveDeltaY;
                    this.out.print("\t\t");
                }
            } else {
                EdgeRecord edge = (EdgeRecord)shape;
                if (edge instanceof StraightEdgeRecord) {
                    StraightEdgeRecord straightEdge = (StraightEdgeRecord)edge;
                    this.out.print("SER\t");
                    this.out.print(straightEdge.deltaX + "\t" + straightEdge.deltaY);
                    x += straightEdge.deltaX;
                    y += straightEdge.deltaY;
                    this.out.print("\t\t");
                } else {
                    CurvedEdgeRecord curvedEdge = (CurvedEdgeRecord)edge;
                    this.out.print("CER\t");
                    this.out.print(curvedEdge.controlDeltaX + "\t" + curvedEdge.controlDeltaY + "\t");
                    this.out.print(curvedEdge.anchorDeltaX + "\t" + curvedEdge.anchorDeltaY);
                    x += curvedEdge.controlDeltaX + curvedEdge.anchorDeltaX;
                    y += curvedEdge.controlDeltaY + curvedEdge.anchorDeltaY;
                }
            }
            this.out.println("\t\t" + x + "\t" + y);
        }
    }

    private String printClipEventFlags(int flags) {
        StringBuffer b = new StringBuffer();
        if ((flags & Integer.MIN_VALUE) != 0) {
            b.append("res31,");
        }
        if ((flags & 0x40000000) != 0) {
            b.append("res30,");
        }
        if ((flags & 0x20000000) != 0) {
            b.append("res29,");
        }
        if ((flags & 0x10000000) != 0) {
            b.append("res28,");
        }
        if ((flags & 0x8000000) != 0) {
            b.append("res27,");
        }
        if ((flags & 0x4000000) != 0) {
            b.append("res26,");
        }
        if ((flags & 0x2000000) != 0) {
            b.append("res25,");
        }
        if ((flags & 0x1000000) != 0) {
            b.append("res24,");
        }
        if ((flags & 0x800000) != 0) {
            b.append("res23,");
        }
        if ((flags & 0x400000) != 0) {
            b.append("res22,");
        }
        if ((flags & 0x200000) != 0) {
            b.append("res21,");
        }
        if ((flags & 0x100000) != 0) {
            b.append("res20,");
        }
        if ((flags & 0x80000) != 0) {
            b.append("res19,");
        }
        if ((flags & 0x40000) != 0) {
            b.append("construct,");
        }
        if ((flags & 0x20000) != 0) {
            b.append("keyPress,");
        }
        if ((flags & 0x10000) != 0) {
            b.append("dragOut,");
        }
        if ((flags & 0x8000) != 0) {
            b.append("dragOver,");
        }
        if ((flags & 0x4000) != 0) {
            b.append("rollOut,");
        }
        if ((flags & 0x2000) != 0) {
            b.append("rollOver,");
        }
        if ((flags & 0x1000) != 0) {
            b.append("releaseOutside,");
        }
        if ((flags & 0x800) != 0) {
            b.append("release,");
        }
        if ((flags & 0x400) != 0) {
            b.append("press,");
        }
        if ((flags & 0x200) != 0) {
            b.append("initialize,");
        }
        if ((flags & 0x100) != 0) {
            b.append("data,");
        }
        if ((flags & 0x80) != 0) {
            b.append("keyUp,");
        }
        if ((flags & 0x40) != 0) {
            b.append("keyDown,");
        }
        if ((flags & 0x20) != 0) {
            b.append("mouseUp,");
        }
        if ((flags & 0x10) != 0) {
            b.append("mouseDown,");
        }
        if ((flags & 8) != 0) {
            b.append("moseMove,");
        }
        if ((flags & 4) != 0) {
            b.append("unload,");
        }
        if ((flags & 2) != 0) {
            b.append("enterFrame,");
        }
        if ((flags & 1) != 0) {
            b.append("load,");
        }
        if (b.length() > 1) {
            b.setLength(b.length() - 1);
        }
        return b.toString();
    }

    public void defineText2(DefineText tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.end();
        Iterator it = tag.records.iterator();
        while (it.hasNext()) {
            TextRecord tr = (TextRecord)it.next();
            this.printTextRecord(tr, tag.code);
        }
        this.close(tag);
    }

    public void printTextRecord(TextRecord tr, int tagCode) {
        this.indent();
        this.out.print("<textRecord ");
        if (tr.hasFont()) {
            this.out.print(" font='" + tr.font.fontName + "'");
        }
        if (tr.hasHeight()) {
            this.out.print(" height='" + tr.height + "'");
        }
        if (tr.hasX()) {
            this.out.print(" xOffset='" + tr.xOffset + "'");
        }
        if (tr.hasY()) {
            this.out.print(" yOffset='" + tr.yOffset + "'");
        }
        if (tr.hasColor()) {
            this.out.print(" color='" + (tagCode == 37 ? this.printRGB(tr.color) : this.printRGBA(tr.color)) + "'");
        }
        this.out.println(">");
        ++this.indent;
        this.printGlyphEntries(tr);
        --this.indent;
        this.indent();
        this.out.println("</textRecord>");
    }

    private void printGlyphEntries(TextRecord tr) {
        this.indent();
        for (int i = 0; i < tr.entries.length; ++i) {
            GlyphEntry ge = tr.entries[i];
            this.out.print(ge.getIndex());
            if (ge.advance >= 0) {
                this.out.print('+');
            }
            this.out.print(ge.advance);
            this.out.print(' ');
            if ((i + 1) % 10 != 0) continue;
            this.out.println();
            this.indent();
        }
        if (tr.entries.length % 10 != 0) {
            this.out.println();
        }
    }

    public void defineButton2(DefineButton tag) {
        int i;
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.out.print(" trackAsMenu='" + tag.trackAsMenu + "'");
        this.end();
        for (i = 0; i < tag.buttonRecords.length; ++i) {
            ButtonRecord record = tag.buttonRecords[i];
            this.indent();
            this.out.println("<buttonRecord idref='" + this.idRef(record.characterRef) + "' " + "depth='" + record.placeDepth + "' " + "matrix='" + record.placeMatrix + "' " + "states='" + record.getFlags() + "'/>");
        }
        if (tag.condActions.length > 0 && this.showActions) {
            this.indent();
            this.out.println("<buttonCondAction>");
            this.openCDATA();
            for (i = 0; i < tag.condActions.length; ++i) {
                ButtonCondAction cond = tag.condActions[i];
                this.indent();
                this.out.println("on(" + cond + ") {");
                ++this.indent;
                this.printActions(cond.actionList);
                --this.indent;
                this.indent();
                this.out.println("}");
            }
            this.closeCDATA();
            this.indent();
            this.out.println("</buttonCondAction>");
        }
        this.close(tag);
    }

    public void defineBitsJPEG3(DefineBitsJPEG3 tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.close();
    }

    public void defineBitsLossless2(DefineBitsLossless tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        if (this.external) {
            String path = this.externalDirectory + this.externalPrefix + "image" + this.dict.getId(tag) + ".bitmap";
            this.out.println(" src='" + path + "' />");
            try {
                FileOutputStream image = new FileOutputStream(path, false);
                image.write(tag.data);
                image.close();
            }
            catch (IOException e) {
                this.out.println("<!-- error: unable to write external asset file " + path + "-->");
            }
        } else {
            this.out.print(" encoding='base64'");
            this.end();
            this.outputBase64(tag.data);
            this.close(tag);
        }
    }

    String escape(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer b = new StringBuffer(s.length());
        block5: for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    b.append("&lt;");
                    continue block5;
                }
                case '>': {
                    b.append("&gt;");
                    continue block5;
                }
                case '&': {
                    b.append("&amp;");
                }
            }
        }
        return b.toString();
    }

    public void defineEditText(DefineEditText tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        if (tag.hasText) {
            this.out.print(" text='" + this.escape(tag.initialText) + "'");
        }
        if (tag.hasFont) {
            this.out.print(" fontId='" + this.id(tag.font) + "'");
            this.out.print(" fontName='" + tag.font.fontName + "'");
            this.out.print(" fontHeight='" + tag.height + "'");
        }
        this.out.print(" bounds='" + tag.bounds + "'");
        if (tag.hasTextColor) {
            this.out.print(" color='" + this.printRGBA(tag.color) + "'");
        }
        this.out.print(" html='" + tag.html + "'");
        this.out.print(" autoSize='" + tag.autoSize + "'");
        this.out.print(" border='" + tag.border + "'");
        if (tag.hasMaxLength) {
            this.out.print(" maxLength='" + tag.maxLength + "'");
        }
        this.out.print(" multiline='" + tag.multiline + "'");
        this.out.print(" noSelect='" + tag.noSelect + "'");
        this.out.print(" password='" + tag.password + "'");
        this.out.print(" readOnly='" + tag.readOnly + "'");
        this.out.print(" useOutlines='" + tag.useOutlines + "'");
        this.out.print(" varName='" + tag.varName + "'");
        this.out.print(" wordWrap='" + tag.wordWrap + "'");
        if (tag.hasLayout) {
            this.out.print(" align='" + tag.align + "'");
            this.out.print(" indent='" + tag.ident + "'");
            this.out.print(" leading='" + tag.leading + "'");
            this.out.print(" leftMargin='" + tag.leftMargin + "'");
            this.out.print(" rightMargin='" + tag.rightMargin + "'");
        }
        this.close();
    }

    public void defineSprite(DefineSprite tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.end();
        this.indent();
        this.out.println("<!-- sprite framecount=" + tag.framecount + " -->");
        tag.tagList.visitTags(this);
        this.close(tag);
    }

    public void finish() {
        --this.indent;
        this.indent();
        this.out.println("</swf>");
    }

    public void frameLabel(FrameLabel tag) {
        this.open(tag);
        this.out.print(" label='" + tag.label + "'");
        if (tag.anchor) {
            this.out.print(" anchor='true'");
        }
        this.close();
    }

    public void soundStreamHead2(SoundStreamHead tag) {
        this.open(tag);
        this.out.print(" playbackRate='" + tag.playbackRate + "'");
        this.out.print(" playbackSize='" + tag.playbackSize + "'");
        this.out.print(" playbackType='" + tag.playbackType + "'");
        this.out.print(" compression='" + tag.compression + "'");
        this.out.print(" streamRate='" + tag.streamRate + "'");
        this.out.print(" streamSize='" + tag.streamSize + "'");
        this.out.print(" streamType='" + tag.streamType + "'");
        this.out.print(" streamSampleCount='" + tag.streamSampleCount + "'");
        if (tag.compression == 2) {
            this.out.print(" latencySeek='" + tag.latencySeek + "'");
        }
        this.close();
    }

    public void defineScalingGrid(DefineScalingGrid tag) {
        this.open(tag);
        this.out.print(" idref='" + this.id(tag.scalingTarget) + "'");
        this.out.print(" grid='" + tag.rect + "'");
        this.close();
    }

    public void defineMorphShape(DefineMorphShape tag) {
        this.defineMorphShape2(tag);
    }

    public void defineMorphShape2(DefineMorphShape tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.out.print(" startBounds='" + tag.startBounds + "'");
        this.out.print(" endBounds='" + tag.endBounds + "'");
        if (tag.code == 84) {
            this.out.print(" startEdgeBounds='" + tag.startEdgeBounds + "'");
            this.out.print(" endEdgeBounds='" + tag.endEdgeBounds + "'");
            this.out.print(" usesNonScalingStrokes='" + tag.usesNonScalingStrokes + "'");
            this.out.print(" usesScalingStrokes='" + tag.usesScalingStrokes + "'");
        }
        this.end();
        this.printMorphLineStyles(tag.lineStyles);
        this.printMorphFillStyles(tag.fillStyles);
        this.indent();
        this.out.println("<start>");
        ++this.indent;
        this.printShape(tag.startEdges, true);
        --this.indent;
        this.indent();
        this.out.println("</start>");
        this.indent();
        this.out.println("<end>");
        ++this.indent;
        this.printShape(tag.endEdges, true);
        --this.indent;
        this.indent();
        this.out.println("</end>");
        this.close(tag);
    }

    public void defineFont2(DefineFont tag) {
        int i;
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.out.print(" font='" + tag.fontName + "'");
        this.out.print(" numGlyphs='" + tag.glyphShapeTable.length + "'");
        this.out.print(" italic='" + tag.italic + "'");
        this.out.print(" bold='" + tag.bold + "'");
        this.out.print(" ansi='" + tag.ansi + "'");
        this.out.print(" wideOffsets='" + tag.wideOffsets + "'");
        this.out.print(" wideCodes='" + tag.wideCodes + "'");
        this.out.print(" shiftJIS='" + tag.shiftJIS + "'");
        this.out.print(" langCode='" + tag.langCode + "'");
        this.out.print(" hasLayout='" + tag.hasLayout + "'");
        this.out.print(" ascent='" + tag.ascent + "'");
        this.out.print(" descent='" + tag.descent + "'");
        this.out.print(" leading='" + tag.leading + "'");
        this.out.print(" kerningCount='" + tag.kerningCount + "'");
        this.out.print(" codepointCount='" + tag.codeTable.length + "'");
        if (tag.hasLayout) {
            this.out.print(" advanceCount='" + tag.advanceTable.length + "'");
            this.out.print(" boundsCount='" + tag.boundsTable.length + "'");
        }
        this.end();
        for (i = 0; i < tag.kerningCount; ++i) {
            KerningRecord rec = tag.kerningTable[i];
            this.indent();
            this.out.println("<kerningRecord adjustment='" + rec.adjustment + "' code1='" + rec.code1 + "' code2='" + rec.code2 + "' />");
        }
        if (this.glyphs) {
            for (i = 0; i < tag.glyphShapeTable.length; ++i) {
                this.indent();
                this.out.print("<glyph");
                this.out.print(" codepoint='" + tag.codeTable[i] + (this.isPrintable(tag.codeTable[i]) ? "(" + tag.codeTable[i] + ")" : "(?)") + "'");
                if (tag.hasLayout) {
                    this.out.print(" advance='" + tag.advanceTable[i] + "'");
                    this.out.print(" bounds='" + tag.boundsTable[i] + "'");
                }
                this.out.println(">");
                Shape shape = tag.glyphShapeTable[i];
                ++this.indent;
                if (this.tabbedGlyphs) {
                    this.printShapeWithTabs(shape);
                } else {
                    this.printShape(shape, true);
                }
                --this.indent;
                this.indent();
                this.out.println("</glyph>");
            }
        }
        this.close(tag);
    }

    public void defineFont3(DefineFont tag) {
        this.defineFont2(tag);
    }

    public void defineFontAlignZones(DefineFontAlignZones tag) {
        this.open(tag);
        if (tag.name != null) {
            this.out.print(" id='" + this.id(tag) + "'");
        }
        this.out.print(" fontID='" + this.id(tag.font) + "'");
        this.out.print(" CSMTableHint='" + tag.csmTableHint + "'");
        this.out.println(">");
        ++this.indent;
        this.indent();
        this.out.println("<ZoneTable>");
        ++this.indent;
        for (int i = 0; i < tag.zoneTable.length; ++i) {
            ZoneRecord record = tag.zoneTable[i];
            this.indent();
            this.out.print("<ZoneRecord num='" + record.numZoneData + "' mask='" + record.zoneMask + "'>");
            for (int j = 0; j < record.zoneData.length; ++j) {
                this.out.print(record.zoneData[j] + " ");
            }
            this.out.println("</ZoneRecord>");
        }
        --this.indent;
        this.indent();
        this.out.println("</ZoneTable>");
        this.close(tag);
    }

    public void csmTextSettings(CSMTextSettings tag) {
        this.open(tag);
        if (tag.name != null) {
            this.out.print(" id='" + this.id(tag) + "'");
        }
        String textID = tag.textReference == null ? "0" : this.id(tag.textReference);
        this.out.print(" textID='" + textID + "'");
        this.out.print(" styleFlagsUseSaffron='" + tag.styleFlagsUseSaffron + "'");
        this.out.print(" gridFitType='" + tag.gridFitType + "'");
        this.out.print(" thickness='" + tag.thickness + "'");
        this.out.print(" sharpness='" + tag.sharpness + "'");
        this.close();
    }

    public void defineFontName(DefineFontName tag) {
        this.open(tag);
        if (tag.name != null) {
            this.out.print(" id='" + this.id(tag) + "'");
        }
        this.out.print(" fontID='" + this.id(tag.font) + "'");
        if (tag.fontName != null) {
            this.out.print(" name='" + tag.fontName + "'");
        }
        if (tag.copyright != null) {
            this.out.print(" copyright='" + tag.copyright + "'");
        }
        this.close();
    }

    private boolean isPrintable(char c) {
        int i = c & 0xFFFF;
        return i >= 32 && i != 60 && i != 38 && i != 39;
    }

    public void exportAssets(ExportAssets tag) {
        this.open(tag);
        this.end();
        Iterator it = tag.exports.iterator();
        while (it.hasNext()) {
            DefineTag ref = (DefineTag)it.next();
            this.indent();
            this.out.println("<Export idref='" + this.dict.getId(ref) + "' name='" + ref.name + "' />");
        }
        this.close(tag);
    }

    public void symbolClass(SymbolClass tag) {
        this.open(tag);
        this.end();
        Iterator it = tag.class2tag.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry e = it.next();
            String className = (String)e.getKey();
            DefineTag ref = (DefineTag)e.getValue();
            this.indent();
            this.out.println("<Symbol idref='" + this.dict.getId(ref) + "' className='" + className + "' />");
        }
        if (tag.topLevelClass != null) {
            this.indent();
            this.out.println("<Symbol idref='0' className='" + tag.topLevelClass + "' />");
        }
        this.close(tag);
    }

    public void importAssets(ImportAssets tag) {
        this.open(tag);
        this.out.print(" url='" + tag.url + "'");
        this.end();
        Iterator it = tag.importRecords.iterator();
        while (it.hasNext()) {
            ImportRecord record = (ImportRecord)it.next();
            this.indent();
            this.out.println("<Import name='" + record.name + "' id='" + this.dict.getId(record) + "' />");
        }
        this.close(tag);
    }

    public void importAssets2(ImportAssets tag) {
        this.importAssets(tag);
    }

    public void enableDebugger(EnableDebugger tag) {
        this.open(tag);
        this.out.print(" password='" + tag.password + "'");
        this.close();
    }

    public void doInitAction(DoInitAction tag) {
        if (tag.sprite != null && tag.sprite.name != null) {
            this.indent();
            this.out.println("<!-- init " + tag.sprite.name + " " + this.dict.getId(tag.sprite) + " -->");
        }
        this.open(tag);
        if (tag.sprite != null) {
            this.out.print(" idref='" + this.idRef(tag.sprite) + "'");
        }
        this.end();
        if (this.showActions) {
            this.openCDATA();
            this.printActions(tag.actionList);
            this.closeCDATA();
        } else {
            this.indent();
            this.out.println("<!-- " + tag.actionList.size() + " action(s) elided -->");
        }
        this.close(tag);
    }

    private String idRef(DefineTag tag) {
        if (tag == null) {
            return "-1";
        }
        if (tag.name == null) {
            return String.valueOf(this.dict.getId(tag));
        }
        return tag.name;
    }

    public void defineVideoStream(DefineVideoStream tag) {
        this.open(tag);
        this.out.print(" id='" + this.id(tag) + "'");
        this.close();
    }

    public void videoFrame(VideoFrame tag) {
        this.open(tag);
        this.out.print(" streamId='" + this.idRef(tag.stream) + "'");
        this.out.print(" frame='" + tag.frameNum + "'");
        this.close();
    }

    public void defineFontInfo2(DefineFontInfo tag) {
        this.defineFontInfo(tag);
    }

    public void enableDebugger2(EnableDebugger tag) {
        this.open(tag);
        this.out.print(" password='" + tag.password + "'");
        this.out.print(" reserved='0x" + Integer.toHexString(tag.reserved) + "'");
        this.close();
    }

    public void debugID(DebugID tag) {
        this.open(tag);
        this.out.print(" uuid='" + tag.uuid + "'");
        this.close();
    }

    public void scriptLimits(ScriptLimits tag) {
        this.open(tag);
        this.out.print(" scriptRecursionLimit='" + tag.scriptRecursionLimit + "'" + " scriptTimeLimit='" + tag.scriptTimeLimit + "'");
        this.close();
    }

    public void setTabIndex(SetTabIndex tag) {
        this.open(tag);
        this.out.print(" depth='" + tag.depth + "'");
        this.out.print(" index='" + tag.index + "'");
        this.close();
    }

    public void doABC(DoABC tag) {
        if (this.abc) {
            this.open(tag);
            this.end();
            AbcPrinter abcPrinter = new AbcPrinter(tag.abc, this.out, this.showOffset, this.indent);
            abcPrinter.print();
            this.close(tag);
        } else if (this.showActions) {
            this.open(tag);
            if (tag.code == 82) {
                this.out.print(" name='" + tag.name + "'");
            }
            this.end();
            ContextStatics contextStatics = new ContextStatics();
            contextStatics.use_static_semantics = true;
            contextStatics.dialect = 9;
            Context context = new Context(contextStatics);
            context.setHandler(new CompilerHandler());
            AbcParser abcParser = new AbcParser(context, tag.abc);
            context.setEmitter((Emitter)new ActionBlockEmitter(context, tag.name, (PrintWriter)new StringPrintWriter(), (PrintWriter)new StringPrintWriter(), false, false, false, false));
            ProgramNode programNode = abcParser.parseAbc();
            if (programNode == null) {
                this.out.println("<!-- Error: could not parse abc -->");
            } else if (!this.decompile) {
                SyntaxTreeDumper syntaxTreeDumper = new SyntaxTreeDumper(this.out, this.indent);
                programNode.evaluate(context, (Evaluator)syntaxTreeDumper);
            }
            this.close(tag);
        } else {
            this.open(tag);
            this.close();
        }
    }

    private String hexify(byte[] id) {
        StringBuffer b = new StringBuffer(id.length * 2);
        for (int i = 0; i < id.length; ++i) {
            b.append(Character.forDigit(id[i] >> 4 & 0xF, 16));
            b.append(Character.forDigit(id[i] & 0xF, 16));
        }
        return b.toString().toUpperCase();
    }

    public static String baseName(String path) {
        int start = path.lastIndexOf(File.separatorChar);
        if (File.separatorChar != '/') {
            int altstart = path.lastIndexOf(47);
            if (start == -1 || altstart > start) {
                start = altstart;
            }
        }
        start = start == -1 ? 0 : ++start;
        int end = path.lastIndexOf(46);
        if (end == -1) {
            end = path.length();
        }
        if (start > end) {
            end = path.length();
        }
        return path.substring(start, end);
    }

    public static String dirName(String path) {
        int end = path.lastIndexOf(File.pathSeparatorChar);
        if (File.pathSeparatorChar != '/') {
            int altend = path.lastIndexOf(47);
            if (end == -1 || altend < end) {
                end = altend;
            }
        }
        if (end == -1) {
            return "";
        }
        return path.substring(0, ++end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        URL[] urls;
        File f;
        if (args.length == 0) {
            System.err.println("Usage: java tools.SwfxPrinter [-encode] [-asm] [-abc] [-noactions] [-showdebugsource] [-showoffset] [-noglyphs] [-external] [-save file.swf] [-nofunctions] [-out file.swfx] file1.swf ...");
            System.exit(1);
        }
        int index = 0;
        PrintWriter out = null;
        String outfile = null;
        while (index < args.length && args[index].startsWith("-")) {
            if (args[index].equals("-encode")) {
                encodeOption = true;
                ++index;
                continue;
            }
            if (args[index].equals("-save")) {
                saveOption = true;
                int n = ++index;
                ++index;
                outfile = args[n];
                continue;
            }
            if (args[index].equals("-decompile")) {
                decompileOption = true;
                ++index;
                continue;
            }
            if (args[index].equals("-nofunctions")) {
                defuncOption = false;
                ++index;
                continue;
            }
            if (args[index].equals("-asm")) {
                decompileOption = false;
                ++index;
                continue;
            }
            if (args[index].equals("-abc")) {
                abcOption = true;
                ++index;
                continue;
            }
            if (args[index].equals("-noactions")) {
                showActionsOption = false;
                ++index;
                continue;
            }
            if (args[index].equals("-showoffset")) {
                showOffsetOption = true;
                ++index;
                continue;
            }
            if (args[index].equals("-showdebugsource")) {
                showDebugSourceOption = true;
                ++index;
                continue;
            }
            if (args[index].equals("-noglyphs")) {
                glyphsOption = false;
                ++index;
                continue;
            }
            if (args[index].equals("-out")) {
                if (index + 1 == args.length) {
                    System.err.println("-out requires a filename or - for stdout");
                    System.exit(1);
                }
                if (!args[index + 1].equals("-")) {
                    outfile = args[index + 1];
                    out = new PrintWriter(new FileOutputStream(outfile, false));
                }
                index += 2;
                continue;
            }
            if (args[index].equals("-external")) {
                externalOption = true;
                ++index;
                continue;
            }
            if (args[index].equalsIgnoreCase("-tabbedGlyphs")) {
                tabbedGlyphsOption = true;
                ++index;
                continue;
            }
            System.err.println("unknown argument " + args[index]);
            ++index;
        }
        if (out == null) {
            out = new PrintWriter(System.out, true);
        }
        if (!(f = new File(args[index])).exists()) {
            urls = new URL[]{new URL(args[index])};
        } else if (f.isDirectory()) {
            File[] list = FileUtils.listFiles(f);
            urls = new URL[list.length];
            for (int i = 0; i < list.length; ++i) {
                urls[i] = FileUtils.toURL(list[i]);
            }
        } else {
            urls = new URL[]{FileUtils.toURL(f)};
        }
        for (int i = 0; i < urls.length; ++i) {
            try {
                URL url = urls[i];
                if (saveOption) {
                    BufferedInputStream in = new BufferedInputStream(url.openStream());
                    try {
                        BufferedOutputStream fileOut = new BufferedOutputStream(new FileOutputStream(outfile));
                        try {
                            int c;
                            while ((c = ((InputStream)in).read()) != -1) {
                                ((OutputStream)fileOut).write(c);
                            }
                        }
                        finally {
                            ((OutputStream)fileOut).close();
                        }
                    }
                    finally {
                        ((InputStream)in).close();
                    }
                }
                if (SwfxPrinter.isSwf(url)) {
                    SwfxPrinter.dumpSwf(out, url, outfile);
                } else if (SwfxPrinter.isZip(url) && !url.toString().endsWith(".abj")) {
                    SwfxPrinter.dumpZip(out, url, outfile);
                } else {
                    out.println("<!-- Parsing actions from " + url + " -->");
                    URLConnection connection = url.openConnection();
                    ActionDecoder actionDecoder = new ActionDecoder(new SwfDecoder(connection.getInputStream(), 7));
                    actionDecoder.setKeepOffsets(true);
                    ActionList actions = actionDecoder.decode(connection.getContentLength());
                    SwfxPrinter printer = new SwfxPrinter(out);
                    printer.decompile = decompileOption;
                    printer.defunc = defuncOption;
                    printer.printActions(actions);
                }
                out.flush();
                continue;
            }
            catch (Error e) {
                if (Trace.error) {
                    e.printStackTrace();
                }
                System.err.println("");
                System.err.println("An unrecoverable error occurred.  The given file " + urls[i] + " may not be");
                System.err.println("a valid swf.");
                continue;
            }
            catch (FileNotFoundException e) {
                System.err.println("Error: " + e.getMessage());
                System.exit(1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpZip(PrintWriter out, URL url, String outfile) throws IOException {
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        try {
            ZipInputStream zipIn = new ZipInputStream(in);
            ZipEntry zipEntry = zipIn.getNextEntry();
            while (zipEntry != null) {
                URL fileUrl = new URL("jar:" + url.toString() + "!/" + zipEntry.getName());
                if (SwfxPrinter.isSwf(fileUrl)) {
                    SwfxPrinter.dumpSwf(out, fileUrl, outfile);
                }
                zipEntry = zipIn.getNextEntry();
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    private static void dumpSwf(PrintWriter out, URL url, String outfile) throws IOException {
        InputStream in;
        out.println("<!-- Parsing swf " + url + " -->");
        SwfxPrinter debugPrinter = new SwfxPrinter(out);
        debugPrinter.showActions = showActionsOption;
        debugPrinter.showOffset = showOffsetOption;
        debugPrinter.showDebugSource = showDebugSourceOption;
        debugPrinter.glyphs = glyphsOption;
        debugPrinter.setExternal(externalOption, outfile);
        debugPrinter.decompile = decompileOption;
        debugPrinter.abc = abcOption;
        debugPrinter.defunc = defuncOption;
        debugPrinter.tabbedGlyphs = tabbedGlyphsOption;
        if (encodeOption) {
            TagEncoder encoder = new TagEncoder();
            in = url.openStream();
            new TagDecoder(in, url).parse(encoder);
            encoder.finish();
            in = new ByteArrayInputStream(encoder.toByteArray());
        } else {
            in = url.openStream();
        }
        TagDecoder t = new TagDecoder(in, url);
        t.setKeepOffsets(debugPrinter.showOffset);
        t.parse(debugPrinter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSwf(URL url) throws IOException {
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        try {
            boolean bl = SwfxPrinter.isSwf(in);
            return bl;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static boolean isSwf(InputStream in) {
        try {
            DataInputStream data = new DataInputStream(in);
            byte[] b = new byte[3];
            data.mark(b.length);
            data.readFully(b);
            if (b[0] == 67 && b[1] == 87 && b[2] == 83 || b[0] == 70 && b[1] == 87 && b[2] == 83) {
                data.reset();
                return true;
            }
            data.reset();
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isZip(URL url) throws IOException {
        BufferedInputStream in = new BufferedInputStream(url.openStream());
        try {
            boolean bl = SwfxPrinter.isZip(in);
            return bl;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static boolean isZip(InputStream in) {
        try {
            ZipInputStream swcZipInputStream = new ZipInputStream(in);
            swcZipInputStream.getNextEntry();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static String actionListToString(ActionList al, String[] args) {
        boolean showActions = true;
        boolean showOffset = false;
        boolean showDebugSource = false;
        boolean decompile = false;
        boolean defunc = true;
        boolean tabbedGlyphs = true;
        int index = 0;
        while (args != null && index < args.length && args[index].startsWith("-")) {
            if (args[index].equals("-decompile")) {
                decompile = true;
                ++index;
                continue;
            }
            if (args[index].equals("-nofunctions")) {
                defunc = false;
                ++index;
                continue;
            }
            if (args[index].equals("-asm")) {
                decompile = false;
                ++index;
                continue;
            }
            if (args[index].equals("-noactions")) {
                showActions = false;
                ++index;
                continue;
            }
            if (args[index].equals("-showoffset")) {
                showOffset = true;
                ++index;
                continue;
            }
            if (args[index].equals("-showdebugsource")) {
                showDebugSource = true;
                ++index;
                continue;
            }
            if (!args[index].equalsIgnoreCase("-tabbedGlyphs")) continue;
            tabbedGlyphs = true;
            ++index;
        }
        StringWriter sw = new StringWriter();
        PrintWriter out = new PrintWriter(sw);
        SwfxPrinter printer = new SwfxPrinter(out);
        printer.showActions = showActions;
        printer.showOffset = showOffset;
        printer.showDebugSource = showDebugSource;
        printer.decompile = decompile;
        printer.defunc = defunc;
        printer.tabbedGlyphs = tabbedGlyphs;
        printer.printActions(al);
        out.flush();
        return sw.toString();
    }

    static {
        TypeValue.init();
        ObjectValue.init();
        digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        abcOption = false;
        encodeOption = false;
        showActionsOption = true;
        showOffsetOption = false;
        showDebugSourceOption = false;
        glyphsOption = true;
        externalOption = false;
        decompileOption = true;
        defuncOption = true;
        saveOption = false;
        tabbedGlyphsOption = true;
    }
}

